# -*- coding: utf-8 -*-
#
# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# In addition, as a special exception, the copyright holders give
# permission to link the code of portions of this program with the
# OpenSSL library under certain conditions as described in each
# individual source file, and distribute linked combinations
# including the two.
# You must obey the GNU General Public License in all respects
# for all of the code used other than OpenSSL.  If you modify
# file(s) with this exception, you may extend this exception to your
# version of the file(s), but you are not obligated to do so.  If you
# do not wish to do so, delete this exception statement from your
# version.  If you delete this exception statement from all source
# files in the program, then also delete it here.
"""Tests for the main SSO Linux client code."""

# pylint: disable=C0103
do_tests = False
try:
    import dbus
    import dbus.service
    from ubuntu_sso.main import linux as main
    do_tests = True
except ImportError:
    do_tests = False
# pylint enable=C0103

from ubuntuone.devtools.testcases import BaseTestCase, skipIf


@skipIf(do_tests != True, 'Tests only work with DBus and linux imports.')
class LinuxProxyTestCase(BaseTestCase):
    """Test some Linux specific cases."""

    def test_dbus_missing_exists_clean(self):
        """Test that dbus-daemon not being available gives us a clean exit."""
        def patched(*args, **kwargs):
            """Method to patch in for testing."""
            raise dbus.service.DBusException(
                'org.freedesktop.DBus.Error.NoServer')

        self.patch(dbus, "SessionBus", patched)
        self.patch(main, "shutdown_func", patched)
        self.assertRaises(dbus.service.DBusException,
                          main.UbuntuSSOProxy, None)
