/*
 * jingle-content.h - Header for GabbleJingleContent
 * Copyright (C) 2008 Collabora Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __JINGLE_CONTENT_H__
#define __JINGLE_CONTENT_H__

#include <glib-object.h>

#include "jingle-factory.h"
#include "jingle-transport-iface.h"
#include "jingle-types.h"

G_BEGIN_DECLS

typedef enum {
  JINGLE_MEDIA_TYPE_NONE = 0,
  JINGLE_MEDIA_TYPE_AUDIO,
  JINGLE_MEDIA_TYPE_VIDEO,
} JingleMediaType;

typedef enum {
  JINGLE_CONTENT_STATE_EMPTY = 0,
  JINGLE_CONTENT_STATE_NEW,
  JINGLE_CONTENT_STATE_SENT,
  JINGLE_CONTENT_STATE_ACKNOWLEDGED,
  JINGLE_CONTENT_STATE_REMOVING
} JingleContentState;

struct _JingleCandidate {
  JingleTransportProtocol protocol;
  JingleCandidateType type;

  gchar *id;
  gchar *address;
  int port;
  int component;
  int generation;

  int preference;
  gchar *username;
  gchar *password;
  int network;
};

typedef struct _GabbleJingleContentClass GabbleJingleContentClass;

GType gabble_jingle_content_get_type (void);

/* TYPE MACROS */
#define GABBLE_TYPE_JINGLE_CONTENT \
  (gabble_jingle_content_get_type ())
#define GABBLE_JINGLE_CONTENT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_JINGLE_CONTENT, \
                              GabbleJingleContent))
#define GABBLE_JINGLE_CONTENT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), GABBLE_TYPE_JINGLE_CONTENT, \
                           GabbleJingleContentClass))
#define GABBLE_IS_JINGLE_CONTENT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_JINGLE_CONTENT))
#define GABBLE_IS_JINGLE_CONTENT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), GABBLE_TYPE_JINGLE_CONTENT))
#define GABBLE_JINGLE_CONTENT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), GABBLE_TYPE_JINGLE_CONTENT, \
                              GabbleJingleContentClass))

struct _GabbleJingleContentClass {
    GObjectClass parent_class;

    void  (*parse_description) (GabbleJingleContent *, WockyNode *,
        GError **);
    void  (*produce_description) (GabbleJingleContent *, WockyNode *);
    void  (*transport_created) (GabbleJingleContent *,
        GabbleJingleTransportIface *);
    JingleContentSenders (*get_default_senders) (GabbleJingleContent *);
};

typedef struct _GabbleJingleContentPrivate GabbleJingleContentPrivate;

struct _GabbleJingleContent {
    GObject parent;
    GabbleJingleContentPrivate *priv;

    GabbleJingleSession *session;
};

void gabble_jingle_content_parse_add (GabbleJingleContent *c,
    WockyNode *content_node, gboolean google_mode, GError **error);
void gabble_jingle_content_update_senders (GabbleJingleContent *c,
    WockyNode *content_node, GError **error);
void gabble_jingle_content_produce_node (GabbleJingleContent *c,
    WockyNode *parent,
    gboolean include_description,
    gboolean include_transport,
    WockyNode **trans_node_out);
void gabble_jingle_content_parse_accept (GabbleJingleContent *c,
  WockyNode *content_node, gboolean google_mode, GError **error);

void gabble_jingle_content_parse_info (GabbleJingleContent *c,
    WockyNode *content_node, GError **error);
void gabble_jingle_content_parse_transport_info (GabbleJingleContent *self,
  WockyNode *trans_node, GError **error);
void gabble_jingle_content_parse_description_info (GabbleJingleContent *self,
  WockyNode *trans_node, GError **error);
guint gabble_jingle_content_create_share_channel (GabbleJingleContent *self,
    const gchar *name);
void gabble_jingle_content_add_candidates (GabbleJingleContent *self, GList *li);
void _gabble_jingle_content_set_media_ready (GabbleJingleContent *self);
gboolean gabble_jingle_content_is_ready (GabbleJingleContent *self);
void gabble_jingle_content_set_transport_state (GabbleJingleContent *content,
    JingleTransportState state);
void gabble_jingle_content_remove (GabbleJingleContent *c, gboolean signal_peer);
void gabble_jingle_content_reject (GabbleJingleContent *c,
    JingleReason reason);

GList *gabble_jingle_content_get_remote_candidates (GabbleJingleContent *c);
GList *gabble_jingle_content_get_local_candidates (GabbleJingleContent *c);
gboolean gabble_jingle_content_get_credentials (GabbleJingleContent *c,
  gchar **ufrag, gchar **pwd);
gboolean gabble_jingle_content_change_direction (GabbleJingleContent *c,
    JingleContentSenders senders);
void gabble_jingle_content_retransmit_candidates (GabbleJingleContent *self,
    gboolean all);
void gabble_jingle_content_inject_candidates (GabbleJingleContent *self,
    WockyNode *transport_node);
gboolean gabble_jingle_content_is_created_by_us (GabbleJingleContent *c);
gboolean gabble_jingle_content_creator_is_initiator (GabbleJingleContent *c);

const gchar *gabble_jingle_content_get_name (GabbleJingleContent *self);
const gchar *gabble_jingle_content_get_ns (GabbleJingleContent *self);
const gchar *gabble_jingle_content_get_disposition (GabbleJingleContent *self);
JingleTransportType gabble_jingle_content_get_transport_type (GabbleJingleContent *c);
const gchar *gabble_jingle_content_get_transport_ns (GabbleJingleContent *self);

void gabble_jingle_content_maybe_send_description (GabbleJingleContent *self);

gboolean gabble_jingle_content_sending (GabbleJingleContent *self);
gboolean gabble_jingle_content_receiving (GabbleJingleContent *self);

void gabble_jingle_content_set_sending (GabbleJingleContent *self,
    gboolean send);
void gabble_jingle_content_request_receiving (GabbleJingleContent *self,
    gboolean receive);

void gabble_jingle_content_send_complete (GabbleJingleContent *self);

#endif /* __JINGLE_CONTENT_H__ */

