/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */


#include "pthread.h"

#include "pkcsslotd.h"

  static ConstInfo SysErrorInfo[] = {

	CONSTINFO(EPERM), 
	CONSTINFO(ENOENT), 
	CONSTINFO(ESRCH), 
	CONSTINFO(EINTR), 
	CONSTINFO(EIO), 
	CONSTINFO(ENXIO), 
	CONSTINFO(E2BIG), 
	CONSTINFO(ENOEXEC), 
	CONSTINFO(EBADF), 
	CONSTINFO(ECHILD), 
	CONSTINFO(EAGAIN), 
	CONSTINFO(ENOMEM), 
	CONSTINFO(EACCES), 
	CONSTINFO(EFAULT), 
	CONSTINFO(ENOTBLK), 
	CONSTINFO(EBUSY), 
	CONSTINFO(EEXIST), 
	CONSTINFO(EXDEV), 
	CONSTINFO(ENODEV), 
	CONSTINFO(ENOTDIR), 
	CONSTINFO(EISDIR), 
	CONSTINFO(EINVAL), 
	CONSTINFO(ENFILE), 
	CONSTINFO(EMFILE), 
	CONSTINFO(ENOTTY), 
	CONSTINFO(ETXTBSY), 
	CONSTINFO(EFBIG), 
	CONSTINFO(ENOSPC), 
	CONSTINFO(ESPIPE), 
	CONSTINFO(EROFS), 
	CONSTINFO(EMLINK), 
	CONSTINFO(EPIPE), 
	CONSTINFO(EDOM), 
	CONSTINFO(ERANGE), 
	CONSTINFO(ENOMSG), 
	CONSTINFO(EIDRM), 
	CONSTINFO(ECHRNG), 
	CONSTINFO(EL2NSYNC), 
	CONSTINFO(EL3HLT), 
	CONSTINFO(EL3RST), 
	CONSTINFO(ELNRNG), 
	CONSTINFO(EUNATCH), 
	CONSTINFO(ENOCSI), 
	CONSTINFO(EL2HLT), 
	CONSTINFO(EDEADLK),
	CONSTINFO(ESTALE), 
	CONSTINFO(EWOULDBLOCK), 
	CONSTINFO(EINPROGRESS), 
	CONSTINFO(EALREADY), 
	CONSTINFO(ENOTSOCK), 
	CONSTINFO(EDESTADDRREQ), 
	CONSTINFO(EMSGSIZE), 
	CONSTINFO(EPROTOTYPE), 
	CONSTINFO(ENOPROTOOPT), 
	CONSTINFO(EPROTONOSUPPORT), 
	CONSTINFO(ESOCKTNOSUPPORT), 
	CONSTINFO(EOPNOTSUPP), 
	CONSTINFO(EPFNOSUPPORT), 
	CONSTINFO(EAFNOSUPPORT), 
	CONSTINFO(EADDRINUSE), 
	CONSTINFO(EADDRNOTAVAIL), 
	CONSTINFO(ENETDOWN), 
	CONSTINFO(ENETUNREACH), 
	CONSTINFO(ENETRESET), 
	CONSTINFO(ECONNABORTED), 
	CONSTINFO(ECONNRESET), 
	CONSTINFO(ENOBUFS), 
	CONSTINFO(EISCONN), 
	CONSTINFO(ENOTCONN), 
	CONSTINFO(ESHUTDOWN), 
	CONSTINFO(ETIMEDOUT), 
	CONSTINFO(ECONNREFUSED), 
	CONSTINFO(EHOSTDOWN), 
	CONSTINFO(EHOSTUNREACH), 
	CONSTINFO(ERESTART), 
	CONSTINFO(EUSERS), 
	CONSTINFO(ELOOP), 
	CONSTINFO(ENAMETOOLONG), 
	CONSTINFO(ENOTEMPTY), 
	CONSTINFO(EDQUOT), 
	CONSTINFO(EREMOTE), 
	CONSTINFO(ENOSYS), 
	CONSTINFO(ETOOMANYREFS), 
	CONSTINFO(EILSEQ), 
	CONSTINFO(ECANCELED), 
	CONSTINFO(ENOSR), 
	CONSTINFO(ETIME), 
	CONSTINFO(EBADMSG), 
	CONSTINFO(EPROTO), 
	CONSTINFO(ENODATA), 
	CONSTINFO(ENOSTR), 
	CONSTINFO(ENOTSUP), 
	CONSTINFO(EMULTIHOP), 
	CONSTINFO(ENOLINK), 
	CONSTINFO(EOVERFLOW),

  };

  static int SysErrorSize = ( sizeof(SysErrorInfo) / sizeof(SysErrorInfo[0]));



  static ConstInfo SignalInfo[] = {

	CONSTINFO(SIGHUP), 
	CONSTINFO(SIGINT), 
	CONSTINFO(SIGQUIT), 
	CONSTINFO(SIGILL), 
	CONSTINFO(SIGTRAP), 
	CONSTINFO(SIGABRT), 
	CONSTINFO(SIGFPE), 
	CONSTINFO(SIGKILL), 
	CONSTINFO(SIGBUS), 
	CONSTINFO(SIGSEGV), 
	CONSTINFO(SIGSYS), 
	CONSTINFO(SIGPIPE), 
	CONSTINFO(SIGALRM), 
	CONSTINFO(SIGTERM), 
	CONSTINFO(SIGURG), 
	CONSTINFO(SIGSTOP), 
	CONSTINFO(SIGTSTP), 
	CONSTINFO(SIGCONT), 
	CONSTINFO(SIGCHLD), 
	CONSTINFO(SIGTTIN), 
	CONSTINFO(SIGTTOU), 
	CONSTINFO(SIGIO), 
	CONSTINFO(SIGXCPU), 
	CONSTINFO(SIGXFSZ), 
	CONSTINFO(SIGWINCH), 
	CONSTINFO(SIGPWR), 
	CONSTINFO(SIGUSR1), 
	CONSTINFO(SIGUSR2), 
	CONSTINFO(SIGPROF), 
	CONSTINFO(SIGVTALRM), 
	CONSTINFO(SIGIOT), 
	CONSTINFO(SIGCLD), 
	CONSTINFO(SIGPOLL), 
        #if 0
	  CONSTINFO(SIG_DFL), 
	  CONSTINFO(SIG_IGN), 
	  CONSTINFO(SIG_HOLD), 
	  CONSTINFO(SIG_CATCH), 
	  CONSTINFO(SIG_ERR), 
        #endif /* 0 */

  };

  static int SignalInfoSize = (sizeof(SignalInfo) / sizeof(SignalInfo[0]));




#ifndef NODAE
  static ConstInfo DAEError[] = {

	CONSTINFO(DAE_E_OK), 
	CONSTINFO(DAE_E_NOTAGAIN), 
	CONSTINFO(DAE_E_PINVALID), 
	CONSTINFO(DAE_E_PWRONG), 
	CONSTINFO(DAE_E_PERROR), 
	CONSTINFO(DAE_E_CHILD), 
	CONSTINFO(DAE_E_SESSION), 
	CONSTINFO(DAE_E_SIGNAL), 
	CONSTINFO(DAE_E_CLOSE), 
	CONSTINFO(DAE_E_DEVNULL), 
	CONSTINFO(DAE_E_CHDIR), 
	CONSTINFO(DAE_E_SRCPREP), 
	CONSTINFO(DAE_E_NOPSALLOC), 
	CONSTINFO(DAE_E_AINVALID), 
	CONSTINFO(DAE_E_SETPSALLOC), 
	CONSTINFO(DAE_E_EXCLINVALID), 
	CONSTINFO(DAE_E_EXCLERROR), 
	CONSTINFO(DAE_E_EXCLBUSY), 

  };

  static int DAEErrorSize = (sizeof(DAEError) / sizeof(DAEError[0]));
#endif



#ifndef NOODM

  static ConstInfo ODMError[] = {
        CONSTINFO(ODMI_OPEN_ERR), 
        CONSTINFO(ODMI_MALLOC_ERR), 
        CONSTINFO(ODMI_MAGICNO_ERR), 
        CONSTINFO(ODMI_NO_OBJECT), 
        CONSTINFO(ODMI_BAD_CRIT), 
        CONSTINFO(ODMI_INTERNAL_ERR), 
        CONSTINFO(ODMI_TOOMANYCLASSES), 
        CONSTINFO(ODMI_LINK_NOT_FOUND), 
        CONSTINFO(ODMI_INVALID_CLASS), 
        CONSTINFO(ODMI_CLASS_EXISTS), 
        CONSTINFO(ODMI_CLASS_DNE), 
        CONSTINFO(ODMI_BAD_CLASSNAME), 
        CONSTINFO(ODMI_UNLINKCLASS_ERR), 
        CONSTINFO(ODMI_UNLINKCLXN_ERR), 
        CONSTINFO(ODMI_INVALID_CLXN), 
        CONSTINFO(ODMI_CLXNMAGICNO_ERR), 
        CONSTINFO(ODMI_BAD_CLXNNAME), 
        CONSTINFO(ODMI_CLASS_PERMS), 
        CONSTINFO(ODMI_BAD_TIMEOUT), 
        CONSTINFO(ODMI_BAD_TOKEN), 
        CONSTINFO(ODMI_LOCK_BLOCKED), 
        CONSTINFO(ODMI_LOCK_ENV), 
        CONSTINFO(ODMI_UNLOCK), 
        CONSTINFO(ODMI_BAD_LOCK), 
        CONSTINFO(ODMI_LOCK_ID), 
        CONSTINFO(ODMI_PARAMS), 
        CONSTINFO(ODMI_OPEN_PIPE), 
        CONSTINFO(ODMI_READ_PIPE), 
        CONSTINFO(ODMI_FORK), 
        CONSTINFO(ODMI_INVALID_PATH), 
        CONSTINFO(ODMI_READ_ONLY), 
        CONSTINFO(ODMI_NO_SPACE), 
        CONSTINFO(VCHAR_OPEN_ERR), 
        CONSTINFO(VCHAR_MAGICNO_ERR), 
        CONSTINFO(VCHAR_CLASS_DNE), 
        CONSTINFO(VCHAR_BADSTRINGADDR), 
        CONSTINFO(VCHAR_CLASS_PERMS)
  };

  static int ODMErrorSize = (sizeof(ODMError) / sizeof(ODMError[0]));
#endif




  static ConstInfo PkcsReturnInfo[] = {

	CONSTINFO(CKR_OK), 
	CONSTINFO(CKR_CANCEL), 
	CONSTINFO(CKR_HOST_MEMORY), 
	CONSTINFO(CKR_SLOT_ID_INVALID), 
	CONSTINFO(CKR_GENERAL_ERROR), 
	CONSTINFO(CKR_FUNCTION_FAILED), 
	CONSTINFO(CKR_ARGUMENTS_BAD), 
	CONSTINFO(CKR_NO_EVENT), 
	CONSTINFO(CKR_NEED_TO_CREATE_THREADS), 
	CONSTINFO(CKR_CANT_LOCK), 
	CONSTINFO(CKR_ATTRIBUTE_READ_ONLY), 
	CONSTINFO(CKR_ATTRIBUTE_SENSITIVE), 
	CONSTINFO(CKR_ATTRIBUTE_TYPE_INVALID), 
	CONSTINFO(CKR_ATTRIBUTE_VALUE_INVALID), 
	CONSTINFO(CKR_DATA_INVALID), 
	CONSTINFO(CKR_DATA_LEN_RANGE), 
	CONSTINFO(CKR_DEVICE_ERROR), 
	CONSTINFO(CKR_DEVICE_MEMORY), 
	CONSTINFO(CKR_DEVICE_REMOVED), 
	CONSTINFO(CKR_ENCRYPTED_DATA_INVALID), 
	CONSTINFO(CKR_ENCRYPTED_DATA_LEN_RANGE), 
	CONSTINFO(CKR_FUNCTION_CANCELED), 
	CONSTINFO(CKR_FUNCTION_NOT_PARALLEL), 
	CONSTINFO(CKR_FUNCTION_NOT_SUPPORTED), 
	CONSTINFO(CKR_KEY_HANDLE_INVALID), 
	CONSTINFO(CKR_KEY_SIZE_RANGE), 
	CONSTINFO(CKR_KEY_TYPE_INCONSISTENT), 
	CONSTINFO(CKR_KEY_NOT_NEEDED), 
	CONSTINFO(CKR_KEY_CHANGED), 
	CONSTINFO(CKR_KEY_NEEDED), 
	CONSTINFO(CKR_KEY_INDIGESTIBLE), 
	CONSTINFO(CKR_KEY_FUNCTION_NOT_PERMITTED), 
	CONSTINFO(CKR_KEY_NOT_WRAPPABLE), 
	CONSTINFO(CKR_KEY_UNEXTRACTABLE), 
	CONSTINFO(CKR_MECHANISM_INVALID), 
	CONSTINFO(CKR_MECHANISM_PARAM_INVALID), 
	CONSTINFO(CKR_OBJECT_HANDLE_INVALID), 
	CONSTINFO(CKR_OPERATION_ACTIVE), 
	CONSTINFO(CKR_OPERATION_NOT_INITIALIZED), 
	CONSTINFO(CKR_PIN_INCORRECT), 
	CONSTINFO(CKR_PIN_INVALID), 
	CONSTINFO(CKR_PIN_LEN_RANGE), 
	CONSTINFO(CKR_PIN_EXPIRED), 
	CONSTINFO(CKR_PIN_LOCKED), 
	CONSTINFO(CKR_SESSION_CLOSED), 
	CONSTINFO(CKR_SESSION_COUNT), 
	CONSTINFO(CKR_SESSION_HANDLE_INVALID), 
	CONSTINFO(CKR_SESSION_PARALLEL_NOT_SUPPORTED), 
	CONSTINFO(CKR_SESSION_READ_ONLY), 
	CONSTINFO(CKR_SESSION_EXISTS), 
	CONSTINFO(CKR_SESSION_READ_ONLY_EXISTS), 
	CONSTINFO(CKR_SESSION_READ_WRITE_SO_EXISTS), 
	CONSTINFO(CKR_SIGNATURE_INVALID), 
	CONSTINFO(CKR_SIGNATURE_LEN_RANGE), 
	CONSTINFO(CKR_TEMPLATE_INCOMPLETE), 
	CONSTINFO(CKR_TEMPLATE_INCONSISTENT), 
	CONSTINFO(CKR_TOKEN_NOT_PRESENT), 
	CONSTINFO(CKR_TOKEN_NOT_RECOGNIZED), 
	CONSTINFO(CKR_TOKEN_WRITE_PROTECTED), 
	CONSTINFO(CKR_UNWRAPPING_KEY_HANDLE_INVALID), 
	CONSTINFO(CKR_UNWRAPPING_KEY_SIZE_RANGE), 
	CONSTINFO(CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT), 
	CONSTINFO(CKR_USER_ALREADY_LOGGED_IN), 
	CONSTINFO(CKR_USER_NOT_LOGGED_IN), 
	CONSTINFO(CKR_USER_PIN_NOT_INITIALIZED), 
	CONSTINFO(CKR_USER_TYPE_INVALID), 
	CONSTINFO(CKR_USER_ANOTHER_ALREADY_LOGGED_IN), 
	CONSTINFO(CKR_USER_TOO_MANY_TYPES), 
	CONSTINFO(CKR_WRAPPED_KEY_INVALID), 
	CONSTINFO(CKR_WRAPPED_KEY_LEN_RANGE), 
	CONSTINFO(CKR_WRAPPING_KEY_HANDLE_INVALID), 
	CONSTINFO(CKR_WRAPPING_KEY_SIZE_RANGE), 
	CONSTINFO(CKR_WRAPPING_KEY_TYPE_INCONSISTENT), 
	CONSTINFO(CKR_RANDOM_SEED_NOT_SUPPORTED), 
	CONSTINFO(CKR_RANDOM_NO_RNG), 
	CONSTINFO(CKR_BUFFER_TOO_SMALL), 
	CONSTINFO(CKR_SAVED_STATE_INVALID), 
	CONSTINFO(CKR_INFORMATION_SENSITIVE), 
	CONSTINFO(CKR_STATE_UNSAVEABLE), 
	CONSTINFO(CKR_CRYPTOKI_NOT_INITIALIZED), 
	CONSTINFO(CKR_CRYPTOKI_ALREADY_INITIALIZED), 
	CONSTINFO(CKR_MUTEX_BAD), 
	CONSTINFO(CKR_MUTEX_NOT_LOCKED), 
	CONSTINFO(CKR_VENDOR_DEFINED), 

  };


  static int PkcsReturnSize = ( sizeof(PkcsReturnInfo) / sizeof(PkcsReturnInfo[0]) );




  static ConstInfo PkcsFlagsInfo[] = {

	CONSTINFO( ( CKF_RNG | CKF_HW | CKF_LIBRARY_CANT_CREATE_OS_THREADS | CKF_TOKEN_PRESENT )), 
	CONSTINFO( ( CKF_REMOVABLE_DEVICE | CKF_OS_LOCKING_OK | CKF_RW_SESSION | CKF_WRITE_PROTECTED )), 
	CONSTINFO( ( CKF_SERIAL_SESSION | CKF_HW_SLOT | CKF_LOGIN_REQUIRED )), 
	CONSTINFO( CKF_USER_PIN_INITIALIZED ), 
	CONSTINFO( CKF_RESTORE_KEY_NOT_NEEDED ), 
	CONSTINFO( CKF_CLOCK_ON_TOKEN), 
	CONSTINFO( ( CKF_PROTECTED_AUTHENTICATION_PATH | CKF_ENCRYPT )), 
	CONSTINFO( ( CKF_DUAL_CRYPTO_OPERATIONS | CKF_DECRYPT )), 
	CONSTINFO(CKF_DIGEST), 
	CONSTINFO(CKF_SIGN), 
	CONSTINFO(CKF_SIGN_RECOVER), 
	CONSTINFO(CKF_VERIFY), 
	CONSTINFO(CKF_VERIFY_RECOVER), 
	CONSTINFO(CKF_GENERATE), 
	CONSTINFO( ( CKF_GENERATE_KEY_PAIR | CKF_USER_PIN_COUNT_LOW )), 
	CONSTINFO( ( CKF_USER_PIN_FINAL_TRY| CKF_WRAP )), 
	CONSTINFO( ( CKF_UNWRAP | CKF_USER_PIN_LOCKED )), 
	CONSTINFO( ( CKF_DERIVE /*| CKF_USER_PIN_MANUFACT_VALUE*/ )), 
	CONSTINFO(CKF_SO_PIN_DERIVED), 
	CONSTINFO(CKF_SO_CARD), 
	CONSTINFO(CKF_SO_PIN_COUNT_LOW), 
	CONSTINFO(CKF_SO_PIN_FINAL_TRY), 
	CONSTINFO(CKF_SO_PIN_LOCKED), 
	/*CONSTINFO(CKF_SO_PIN_MANUFACT_VALUE),*/
	CONSTINFO(CKF_EXTENSION), 

  };

  static int PkcsFlagsSize = ( sizeof(PkcsFlagsInfo) / sizeof(PkcsFlagsInfo[0]));



  static ConstInfo PkcsMechanismInfo[] = {

	CONSTINFO(CKM_RSA_PKCS_KEY_PAIR_GEN), 
	CONSTINFO(CKM_RSA_PKCS), 
	CONSTINFO(CKM_RSA_9796), 
	CONSTINFO(CKM_RSA_X_509), 
	CONSTINFO(CKM_MD2_RSA_PKCS), 
	CONSTINFO(CKM_MD5_RSA_PKCS), 
	CONSTINFO(CKM_SHA1_RSA_PKCS), 
	CONSTINFO(CKM_DSA_KEY_PAIR_GEN), 
	CONSTINFO(CKM_DSA), 
	CONSTINFO(CKM_DSA_SHA1), 
	CONSTINFO(CKM_DH_PKCS_KEY_PAIR_GEN), 
	CONSTINFO(CKM_DH_PKCS_DERIVE), 
	CONSTINFO(CKM_RC2_KEY_GEN), 
	CONSTINFO(CKM_RC2_ECB), 
	CONSTINFO(CKM_RC2_CBC), 
	CONSTINFO(CKM_RC2_MAC), 
	CONSTINFO(CKM_RC2_MAC_GENERAL), 
	CONSTINFO(CKM_RC2_CBC_PAD), 
	CONSTINFO(CKM_RC4_KEY_GEN), 
	CONSTINFO(CKM_RC4), 
	CONSTINFO(CKM_DES_KEY_GEN), 
	CONSTINFO(CKM_DES_ECB), 
	CONSTINFO(CKM_DES_CBC), 
	CONSTINFO(CKM_DES_MAC), 
	CONSTINFO(CKM_DES_MAC_GENERAL), 
	CONSTINFO(CKM_DES_CBC_PAD), 
	CONSTINFO(CKM_DES2_KEY_GEN), 
	CONSTINFO(CKM_DES3_KEY_GEN), 
	CONSTINFO(CKM_DES3_ECB), 
	CONSTINFO(CKM_DES3_CBC), 
	CONSTINFO(CKM_DES3_MAC), 
	CONSTINFO(CKM_DES3_MAC_GENERAL), 
	CONSTINFO(CKM_DES3_CBC_PAD), 
	CONSTINFO(CKM_CDMF_KEY_GEN), 
	CONSTINFO(CKM_CDMF_ECB), 
	CONSTINFO(CKM_CDMF_CBC), 
	CONSTINFO(CKM_CDMF_MAC), 
	CONSTINFO(CKM_CDMF_MAC_GENERAL), 
	CONSTINFO(CKM_CDMF_CBC_PAD), 
	CONSTINFO(CKM_MD2), 
	CONSTINFO(CKM_MD2_HMAC), 
	CONSTINFO(CKM_MD2_HMAC_GENERAL), 
	CONSTINFO(CKM_MD5), 
	CONSTINFO(CKM_MD5_HMAC), 
	CONSTINFO(CKM_MD5_HMAC_GENERAL), 
	CONSTINFO(CKM_SHA_1), 
	CONSTINFO(CKM_SHA_1_HMAC), 
	CONSTINFO(CKM_SHA_1_HMAC_GENERAL), 
	CONSTINFO(CKM_CAST_KEY_GEN), 
	CONSTINFO(CKM_CAST_ECB), 
	CONSTINFO(CKM_CAST_CBC), 
	CONSTINFO(CKM_CAST_MAC), 
	CONSTINFO(CKM_CAST_MAC_GENERAL), 
	CONSTINFO(CKM_CAST_CBC_PAD), 
	CONSTINFO(CKM_CAST3_KEY_GEN), 
	CONSTINFO(CKM_CAST3_ECB), 
	CONSTINFO(CKM_CAST3_CBC), 
	CONSTINFO(CKM_CAST3_MAC), 
	CONSTINFO(CKM_CAST3_MAC_GENERAL), 
	CONSTINFO(CKM_CAST3_CBC_PAD), 
	CONSTINFO(CKM_CAST5_KEY_GEN), 
	CONSTINFO(CKM_CAST128_KEY_GEN), 
	CONSTINFO(CKM_CAST5_ECB), 
	CONSTINFO(CKM_CAST128_ECB), 
	CONSTINFO(CKM_CAST5_CBC), 
	CONSTINFO(CKM_CAST128_CBC), 
	CONSTINFO(CKM_CAST5_MAC), 
	CONSTINFO(CKM_CAST128_MAC), 
	CONSTINFO(CKM_CAST5_MAC_GENERAL), 
	CONSTINFO(CKM_CAST128_MAC_GENERAL), 
	CONSTINFO(CKM_CAST5_CBC_PAD), 
	CONSTINFO(CKM_CAST128_CBC_PAD), 
	CONSTINFO(CKM_RC5_KEY_GEN), 
	CONSTINFO(CKM_RC5_ECB), 
	CONSTINFO(CKM_RC5_CBC), 
	CONSTINFO(CKM_RC5_MAC), 
	CONSTINFO(CKM_RC5_MAC_GENERAL), 
	CONSTINFO(CKM_RC5_CBC_PAD), 
	CONSTINFO(CKM_IDEA_KEY_GEN), 
	CONSTINFO(CKM_IDEA_ECB), 
	CONSTINFO(CKM_IDEA_CBC), 
	CONSTINFO(CKM_IDEA_MAC), 
	CONSTINFO(CKM_IDEA_MAC_GENERAL), 
	CONSTINFO(CKM_IDEA_CBC_PAD), 
	CONSTINFO(CKM_GENERIC_SECRET_KEY_GEN), 
	CONSTINFO(CKM_CONCATENATE_BASE_AND_KEY), 
	CONSTINFO(CKM_CONCATENATE_BASE_AND_DATA), 
	CONSTINFO(CKM_CONCATENATE_DATA_AND_BASE), 
	CONSTINFO(CKM_XOR_BASE_AND_DATA), 
	CONSTINFO(CKM_EXTRACT_KEY_FROM_KEY), 
	CONSTINFO(CKM_SSL3_PRE_MASTER_KEY_GEN), 
	CONSTINFO(CKM_SSL3_MASTER_KEY_DERIVE), 
	CONSTINFO(CKM_SSL3_KEY_AND_MAC_DERIVE), 
	CONSTINFO(CKM_SSL3_MD5_MAC), 
	CONSTINFO(CKM_SSL3_SHA1_MAC), 
	CONSTINFO(CKM_MD5_KEY_DERIVATION), 
	CONSTINFO(CKM_MD2_KEY_DERIVATION), 
	CONSTINFO(CKM_SHA1_KEY_DERIVATION), 
	CONSTINFO(CKM_PBE_MD2_DES_CBC), 
	CONSTINFO(CKM_PBE_MD5_DES_CBC), 
	CONSTINFO(CKM_PBE_MD5_CAST_CBC), 
	CONSTINFO(CKM_PBE_MD5_CAST3_CBC), 
	CONSTINFO(CKM_PBE_MD5_CAST5_CBC), 
	CONSTINFO(CKM_PBE_MD5_CAST128_CBC), 
	CONSTINFO(CKM_PBE_SHA1_CAST5_CBC), 
	CONSTINFO(CKM_PBE_SHA1_CAST128_CBC), 
	CONSTINFO(CKM_PBE_SHA1_RC4_128), 
	CONSTINFO(CKM_PBE_SHA1_RC4_40), 
	CONSTINFO(CKM_PBE_SHA1_DES3_EDE_CBC), 
	CONSTINFO(CKM_PBE_SHA1_DES2_EDE_CBC), 
	CONSTINFO(CKM_PBE_SHA1_RC2_128_CBC), 
	CONSTINFO(CKM_PBE_SHA1_RC2_40_CBC), 
	CONSTINFO(CKM_PBA_SHA1_WITH_SHA1_HMAC), 
	CONSTINFO(CKM_KEY_WRAP_LYNKS), 
	CONSTINFO(CKM_KEY_WRAP_SET_OAEP), 
	CONSTINFO(CKM_SKIPJACK_KEY_GEN), 
	CONSTINFO(CKM_SKIPJACK_ECB64), 
	CONSTINFO(CKM_SKIPJACK_CBC64), 
	CONSTINFO(CKM_SKIPJACK_OFB64), 
	CONSTINFO(CKM_SKIPJACK_CFB64), 
	CONSTINFO(CKM_SKIPJACK_CFB32), 
	CONSTINFO(CKM_SKIPJACK_CFB16), 
	CONSTINFO(CKM_SKIPJACK_CFB8), 
	CONSTINFO(CKM_SKIPJACK_WRAP), 
	CONSTINFO(CKM_SKIPJACK_PRIVATE_WRAP), 
	CONSTINFO(CKM_SKIPJACK_RELAYX), 
	CONSTINFO(CKM_KEA_KEY_PAIR_GEN), 
	CONSTINFO(CKM_KEA_KEY_DERIVE), 
	CONSTINFO(CKM_FORTEZZA_TIMESTAMP), 
	CONSTINFO(CKM_BATON_KEY_GEN), 
	CONSTINFO(CKM_BATON_ECB128), 
	CONSTINFO(CKM_BATON_ECB96), 
	CONSTINFO(CKM_BATON_CBC128), 
	CONSTINFO(CKM_BATON_COUNTER), 
	CONSTINFO(CKM_BATON_SHUFFLE), 
	CONSTINFO(CKM_BATON_WRAP), 
	CONSTINFO(CKM_ECDSA_KEY_PAIR_GEN), 
	CONSTINFO(CKM_ECDSA), 
	CONSTINFO(CKM_ECDSA_SHA1), 
	CONSTINFO(CKM_JUNIPER_KEY_GEN), 
	CONSTINFO(CKM_JUNIPER_ECB128), 
	CONSTINFO(CKM_JUNIPER_CBC128), 
	CONSTINFO(CKM_JUNIPER_COUNTER), 
	CONSTINFO(CKM_JUNIPER_SHUFFLE), 
	CONSTINFO(CKM_JUNIPER_WRAP), 
	CONSTINFO(CKM_FASTHASH), 
	CONSTINFO(CKM_VENDOR_DEFINED), 

  };


  static unsigned int PkcsMechanismSize = (sizeof(PkcsMechanismInfo) / sizeof(PkcsMechanismInfo[0]));



  static ConstInfo PkcsObjectInfo[] = {

	CONSTINFO(CKO_DATA), 
	CONSTINFO(CKO_CERTIFICATE), 
	CONSTINFO(CKO_PUBLIC_KEY), 
	CONSTINFO(CKO_PRIVATE_KEY), 
	CONSTINFO(CKO_SECRET_KEY), 
	CONSTINFO(CKO_VENDOR_DEFINED), 

  };

  static unsigned int PkcsObjectSize = (sizeof(PkcsObjectInfo) / sizeof(PkcsObjectInfo[0]));





  static ConstInfo PkcsKeyInfo[] = {

	CONSTINFO(CKK_RSA), 
	CONSTINFO(CKK_DSA), 
	CONSTINFO(CKK_DH), 
	CONSTINFO(CKK_ECDSA), 
	CONSTINFO(CKK_KEA), 
	CONSTINFO(CKK_GENERIC_SECRET), 
	CONSTINFO(CKK_RC2), 
	CONSTINFO(CKK_RC4), 
	CONSTINFO(CKK_DES), 
	CONSTINFO(CKK_DES2), 
	CONSTINFO(CKK_DES3), 
	CONSTINFO(CKK_CAST), 
	CONSTINFO(CKK_CAST3), 
	CONSTINFO( (CKK_CAST5 | CKK_CAST128 )), 
	CONSTINFO(CKK_RC5), 
	CONSTINFO(CKK_IDEA), 
	CONSTINFO(CKK_SKIPJACK), 
	CONSTINFO(CKK_BATON), 
	CONSTINFO(CKK_JUNIPER), 
	CONSTINFO(CKK_CDMF), 
	CONSTINFO(CKK_VENDOR_DEFINED), 

  };

  static unsigned int PkcsKeySize = ( sizeof(PkcsKeyInfo) / sizeof(PkcsKeyInfo[0]) );





  static ConstInfo PkcsAttributeInfo[] = {
	CONSTINFO(CKA_CLASS),
	CONSTINFO(CKA_TOKEN),
	CONSTINFO(CKA_PRIVATE),
	CONSTINFO(CKA_LABEL),
	CONSTINFO(CKA_APPLICATION),
	CONSTINFO(CKA_VALUE),
	CONSTINFO(CKA_CERTIFICATE_TYPE),
	CONSTINFO(CKA_ISSUER),
	CONSTINFO(CKA_SERIAL_NUMBER),
	CONSTINFO(CKA_KEY_TYPE),
	CONSTINFO(CKA_SUBJECT),
	CONSTINFO(CKA_ID),
	CONSTINFO(CKA_SENSITIVE),
	CONSTINFO(CKA_ENCRYPT),
	CONSTINFO(CKA_DECRYPT),
	CONSTINFO(CKA_WRAP),
	CONSTINFO(CKA_UNWRAP),
	CONSTINFO(CKA_SIGN),
	CONSTINFO(CKA_SIGN_RECOVER),
	CONSTINFO(CKA_VERIFY),
	CONSTINFO(CKA_VERIFY_RECOVER),
	CONSTINFO(CKA_DERIVE),
	CONSTINFO(CKA_START_DATE),
	CONSTINFO(CKA_END_DATE),
	CONSTINFO(CKA_MODULUS),
	CONSTINFO(CKA_MODULUS_BITS),
	CONSTINFO(CKA_PUBLIC_EXPONENT),
	CONSTINFO(CKA_PRIVATE_EXPONENT),
	CONSTINFO(CKA_PRIME_1),
	CONSTINFO(CKA_PRIME_2),
	CONSTINFO(CKA_EXPONENT_1),
	CONSTINFO(CKA_EXPONENT_2),
	CONSTINFO(CKA_COEFFICIENT),
	CONSTINFO(CKA_PRIME),
	CONSTINFO(CKA_SUBPRIME),
	CONSTINFO(CKA_BASE),
	CONSTINFO(CKA_VALUE_BITS),
	CONSTINFO(CKA_VALUE_LEN),
	CONSTINFO(CKA_EXTRACTABLE),
	CONSTINFO(CKA_LOCAL),
	CONSTINFO(CKA_NEVER_EXTRACTABLE),
	CONSTINFO(CKA_ALWAYS_SENSITIVE),
	CONSTINFO(CKA_MODIFIABLE),
	CONSTINFO(CKA_ECDSA_PARAMS),
	CONSTINFO(CKA_EC_POINT),
	CONSTINFO(CKA_VENDOR_DEFINED),


  };


  static unsigned int PkcsAttributeSize = ( sizeof(PkcsAttributeInfo) / sizeof(PkcsAttributeInfo[0]) );

#if 0
static ConstInfo PkcsSessionStateInfo[] = {

  CONSTINFO(CKS_RO_PUBLIC_SESSION), 
  CONSTINFO(CKS_RO_USER_FUNCTIONS), 
  CONSTINFO(CKS_RW_PUBLIC_SESSION), 
  CONSTINFO(CKS_RW_USER_FUNCTIONS), 
  CONSTINFO(CKS_RW_SO_FUNCTIONS), 


};
#endif


static ConstInfo PkcsResponseSeverityInfo[] = {
  { SEV_EXPECTED, "expected" }, 
  { SEV_ALLOWED,  "allowed"  }, 
  { SEV_ERROR,    "an error" }, 
  { SEV_FATAL,    "fatal"    }, 
};

static unsigned int PkcsResponseSeveritySize = ( sizeof(PkcsResponseSeverityInfo) / sizeof(PkcsResponseSeverityInfo[0]) );


const unsigned char *ConstName( pConstInfo pInfoArray, unsigned int InfoArraySize, unsigned int ConstValue ) {

  unsigned int i;
  unsigned const char *retval = NULL;


  for ( i = 0; i <  InfoArraySize; i++ ) {

    if ( pInfoArray[i].Code == ConstValue ) {

      retval = &(pInfoArray[i].Name[0]);
      break;

    } /* end if */

  } /* end for i */

  if ( retval == NULL  ) {

    if ( ConstValue == 0 ) { 
      retval = (const unsigned char *) "NULL";
    } else {
      retval = (const unsigned char *) "\"<*>CONSTANT NOT FOUND<*>\"";
    }

  }

  return retval;

}


#ifndef NODAE
  const unsigned char *DAEConst( unsigned int Val ) {
    return ConstName( DAEError, DAEErrorSize, Val);
  }
#endif

  const unsigned char *SignalConst ( unsigned int Val ) {
    return ConstName ( SignalInfo, SignalInfoSize, Val );
  }

#ifndef NOODM
  const unsigned char *ODMConst( unsigned int Val ) {
    return ConstName( ODMError, ODMErrorSize, Val);
  }
#endif

  const unsigned char *SysConst ( unsigned int Val ) {
    return ConstName ( SysErrorInfo, SysErrorSize, Val );
  }



  const unsigned char *PkcsReturn ( unsigned int Val ) {
    return ConstName( PkcsReturnInfo,  PkcsReturnSize, Val );
  }

  const unsigned char *PkcsFlags ( unsigned int Val ) {
    return ConstName( PkcsFlagsInfo, PkcsFlagsSize, Val );
  }

  const unsigned char *PkcsMechanism ( unsigned int Val) {
    return ConstName(PkcsMechanismInfo, PkcsMechanismSize, Val);
  }

  const unsigned char *PkcsObject ( unsigned int Val ) {
    return ConstName ( PkcsObjectInfo, PkcsObjectSize, Val );
  }

  const unsigned char *PkcsKey ( unsigned int Val ) {
    return ConstName( PkcsKeyInfo, PkcsKeySize, Val);
  }

  const unsigned char *PkcsAttribute ( unsigned int Val ) {
    return ConstName ( PkcsAttributeInfo, PkcsAttributeSize, Val);
  }

const unsigned char *ResponseSeverity( unsigned int Val ) {
  return ConstName ( PkcsResponseSeverityInfo, PkcsResponseSeveritySize, Val);
}
