/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/charting/plot2d/_PlotEvents":function(){define("dojox/charting/plot2d/_PlotEvents",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(_1,_2,_3,_4){return _3("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=_1.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";_2.forEach(this.chart.stack,function(_5){if(_5!==this&&_5.plotEvent){t.plot=_5;_5.plotEvent(t);}},this);},connect:function(_6,_7){this.dirty=true;return _4.connect(this,"plotEvent",_6,_7);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){_2.forEach(this._shapeEvents,function(_8){_8.shape.disconnect(_8.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_9){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_9,this,function(e){o.type=_9;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_a){var a=this._eventSeries[_a];if(a){_2.forEach(a,this._connectEvents,this);}},fireEvent:function(_b,_c,_d,_e){var s=this._eventSeries[_b];if(s&&s.length&&_d<s.length){var o=s[_d];o.type=_c;o.event=_e||null;this.raiseEvent(o);o.event=null;}}});});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./ready","./_base/sniff","./_base/window"],function(_f,_10,_11,has,_12){var _13=_12.doc.documentElement,ie=has("ie"),_14=has("opera"),maj=Math.floor,ff=has("ff"),_15=_f.boxModel.replace(/-/,""),_16={"dj_ie":ie,"dj_ie6":maj(ie)==6,"dj_ie7":maj(ie)==7,"dj_ie8":maj(ie)==8,"dj_ie9":maj(ie)==9,"dj_quirks":has("quirks"),"dj_iequirks":ie&&has("quirks"),"dj_opera":_14,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla"),"dj_ff3":maj(ff)==3};_16["dj_"+_15]=true;var _17="";for(var clz in _16){if(_16[clz]){_17+=clz+" ";}}_13.className=_10.trim(_13.className+" "+_17);_11(90,function(){if(!_f.isBodyLtr()){var _18="dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl ");_13.className=_10.trim(_13.className+" "+_18+"dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl "));}});return has;});},"dojox/charting/axis2d/Invisible":function(){define(["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/gfx","dojox/lang/utils","dojox/lang/functional","dojo/string"],function(_19,_1a,_1b,lin,g,du,df,_1c){var _1d=du.merge,_1e=4,_1f=45;return _1a("dojox.charting.axis2d.Invisible",_1b,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null},constructor:function(_20,_21){this.opt=_19.clone(this.defaultParams);du.updateWithObject(this.opt,_21);du.updateWithPattern(this.opt,_21,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_22,_23){this.scale=_22;this.offset=_23;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},_groupLabelWidth:function(_24,_25,_26){if(!_24.length){return 0;}if(_19.isObject(_24[0])){_24=df.map(_24,function(_27){return _27.text;});}if(_26){_24=df.map(_24,function(_28){return _19.trim(_28).length==0?"":_28.substring(0,_26)+this.trailingSymbol;},this);}var s=_24.join("<br>");return g._base._getTextBox(s,{font:_25}).w||0;},calculate:function(min,max,_29,_2a){if(this.initialized()){return this;}var o=this.opt;this.labels="labels" in o?o.labels:_2a;this.scaler=lin.buildScaler(min,max,_29,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,_29,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}var ta=this.chart.theme.axis,_2b=0,_2c=o.rotation%360,_2d=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_2e=_2d?g.normalizedLength(g.splitFontString(_2d).size):0,_2f=Math.abs(Math.cos(_2c*Math.PI/180)),_30=Math.abs(Math.sin(_2c*Math.PI/180));if(_2c<0){_2c+=360;}if(_2e){if(this.vertical?_2c!=0&&_2c!=180:_2c!=90&&_2c!=270){if(this.labels){_2b=this._groupLabelWidth(this.labels,_2d,o.maxLabelCharCount);}else{var _31=Math.ceil(Math.log(Math.max(Math.abs(tsb.from),Math.abs(tsb.to)))/Math.LN10),t=[];if(tsb.from<0||tsb.to<0){t.push("-");}t.push(_1c.rep("9",_31));var _32=Math.floor(Math.log(tsb.to-tsb.from)/Math.LN10);if(_32>0){t.push(".");t.push(_1c.rep("9",_32));}_2b=g._base._getTextBox(t.join(""),{font:_2d}).w;}_2b=o.maxLabelSize?Math.min(o.maxLabelSize,_2b):_2b;}else{_2b=_2e;}switch(_2c){case 0:case 90:case 180:case 270:break;default:var _33=Math.sqrt(_2b*_2b+_2e*_2e),_34=this.vertical?_2e*_2f+_2b*_30:_2b*_2f+_2e*_30;_2b=Math.min(_33,_34);break;}}this.scaler.minMinorStep=_2b+_1e;this.ticks=lin.buildTicks(this.scaler,o);return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dojo/text":function(){define(["./_base/kernel","require","./has","./_base/xhr"],function(_35,_36,has,xhr){var _37;if(1){_37=function(url,_38,_39){xhr("GET",{url:url,sync:!!_38,load:_39});};}else{if(_36.getText){_37=_36.getText;}else{console.error("dojo/text plugin failed to load because loader does not support getText");}}var _3a={},_3b=function(_3c){if(_3c){_3c=_3c.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");var _3d=_3c.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_3d){_3c=_3d[1];}}else{_3c="";}return _3c;},_3e={},_3f={},_40={dynamic:true,normalize:function(id,_41){var _42=id.split("!"),url=_42[0];return (/^\./.test(url)?_41(url):url)+(_42[1]?"!"+_42[1]:"");},load:function(id,_43,_44){var _45=id.split("!"),_46=_45.length>1,_47=_45[0],url=_43.toUrl(_45[0]),_48=_3e,_49=function(_4a){_44(_46?_3b(_4a):_4a);};if(_47 in _3a){_48=_3a[_47];}else{if(url in _43.cache){_48=_43.cache[url];}else{if(url in _3a){_48=_3a[url];}}}if(_48===_3e){if(_3f[url]){_3f[url].push(_49);}else{var _4b=_3f[url]=[_49];_37(url,!_43.async,function(_4c){_3a[_47]=_3a[url]=_4c;for(var i=0;i<_4b.length;){_4b[i++](_4c);}delete _3f[url];});}}else{_49(_48);}}};_35.cache=function(_4d,url,_4e){var key;if(typeof _4d=="string"){if(/\//.test(_4d)){key=_4d;_4e=url;}else{key=_36.toUrl(_4d.replace(/\./g,"/")+(url?("/"+url):""));}}else{key=_4d+"";_4e=url;}var val=(_4e!=undefined&&typeof _4e!="string")?_4e.value:_4e,_4f=_4e&&_4e.sanitize;if(typeof val=="string"){_3a[key]=val;return _4f?_3b(val):val;}else{if(val===null){delete _3a[key];return null;}else{if(!(key in _3a)){_37(key,true,function(_50){_3a[key]=_50;});}return _4f?_3b(_3a[key]):_3a[key];}}};return _40;});},"dojox/lang/utils":function(){define("dojox/lang/utils",["..","dojo/_base/lang"],function(_51,_52){var du=_52.getObject("lang.utils",true,_51);var _53={},_54=Object.prototype.toString;var _55=function(o){if(o){switch(_54.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return _52.delegate(o);}}return o;};_52.mixin(du,{coerceType:function(_56,_57){switch(typeof _56){case "number":return Number(eval("("+_57+")"));case "string":return String(_57);case "boolean":return Boolean(eval("("+_57+")"));}return eval("("+_57+")");},updateWithObject:function(_58,_59,_5a){if(!_59){return _58;}for(var x in _58){if(x in _59&&!(x in _53)){var t=_58[x];if(t&&typeof t=="object"){du.updateWithObject(t,_59[x],_5a);}else{_58[x]=_5a?du.coerceType(t,_59[x]):_55(_59[x]);}}}return _58;},updateWithPattern:function(_5b,_5c,_5d,_5e){if(!_5c||!_5d){return _5b;}for(var x in _5d){if(x in _5c&&!(x in _53)){_5b[x]=_5e?du.coerceType(_5d[x],_5c[x]):_55(_5c[x]);}}return _5b;},merge:function(_5f,_60){if(_60){var _61=_54.call(_5f),_62=_54.call(_60),t,i,l,m;switch(_62){case "[object Array]":if(_62==_61){t=new Array(Math.max(_5f.length,_60.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_5f[i],_60[i]);}return t;}return _60.slice(0);case "[object Object]":if(_62==_61&&_5f){t=_52.delegate(_5f);for(i in _60){if(i in _5f){l=_5f[i];m=_60[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=_52.clone(_60[i]);}}return t;}return _52.clone(_60);}}return _60;}});return du;});},"dojox/charting/plot2d/Pie":function(){define("dojox/charting/plot2d/Pie",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","../Element","./_PlotEvents","./common","../axis2d/common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils"],function(_63,arr,_64,_65,_66,dc,da,g,m,df,du){var _67=0.2;return _64("dojox.charting.plot2d.Pie",[_65,_66],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:"",labelWiring:{}},constructor:function(_68,_69){this.opt=_63.clone(this.defaultParams);du.updateWithObject(this.opt,_69);du.updateWithPattern(this.opt,_69,this.optionalParams);this.run=null;this.dyn=[];},clear:function(){this.dirty=true;this.dyn=[];this.run=null;return this;},setAxis:function(_6a){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return _63.delegate(dc.defaultStats);},initializeScalers:function(){return this;},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_6b){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_6b.l-_6b.r)/2,ry=(dim.height-_6b.t-_6b.b)/2,r=Math.min(rx,ry),_6c="font" in this.opt?this.opt.font:t.axis.font,_6d=_6c?g.normalizedLength(g.splitFontString(_6c).size):0,_6e="fontColor" in this.opt?this.opt.fontColor:t.axis.fontColor,_6f=m._degToRad(this.opt.startAngle),_70=_6f,_71,_72,_73,_74,_75,_76,run=this.run.data,_77=this.events();if(typeof run[0]=="number"){_72=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_72,"<= 0")){return this;}_73=df.map(_72,"/this",df.foldl(_72,"+",0));if(this.opt.labels){_74=arr.map(_73,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_72=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(_72,"<= 0")){return this;}_73=df.map(_72,"/this",df.foldl(_72,"+",0));if(this.opt.labels){_74=arr.map(_73,function(x,i){if(x<=0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}var _78=df.map(run,function(v,i){if(v===null||typeof v=="number"){return t.next("slice",[this.opt,this.run],true);}return t.next("slice",[this.opt,this.run,v],true);},this);if(this.opt.labels){_75=df.foldl1(df.map(_74,function(_79,i){var _7a=_78[i].series.font;return g._base._getTextBox(_79,{font:_7a}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_75,ry-_6d)+this.opt.labelOffset;}_76=r-this.opt.labelOffset;}if("radius" in this.opt){r=this.opt.radius;_76=r-this.opt.labelOffset;}var _7b={cx:_6b.l+rx,cy:_6b.t+ry,r:r};this.dyn=[];var _7c=new Array(_73.length);arr.some(_73,function(_7d,i){if(_7d<0){return false;}if(_7d==0){this.dyn.push({fill:null,stroke:null});return false;}var v=run[i],_7e=_78[i],_7f;if(_7d>=1){_7f=this._plotFill(_7e.series.fill,dim,_6b);_7f=this._shapeFill(_7f,{x:_7b.cx-_7b.r,y:_7b.cy-_7b.r,width:2*_7b.r,height:2*_7b.r});_7f=this._pseudoRadialFill(_7f,{x:_7b.cx,y:_7b.cy},_7b.r);var _80=s.createCircle(_7b).setFill(_7f).setStroke(_7e.series.stroke);this.dyn.push({fill:_7f,stroke:_7e.series.stroke});if(_77){var o={element:"slice",index:i,run:this.run,shape:_80,x:i,y:typeof v=="number"?v:v.y,cx:_7b.cx,cy:_7b.cy,cr:r};this._connectEvents(o);_7c[i]=o;}return true;}var end=_70+_7d*2*Math.PI;if(i+1==_73.length){end=_6f+2*Math.PI;}var _81=end-_70,x1=_7b.cx+r*Math.cos(_70),y1=_7b.cy+r*Math.sin(_70),x2=_7b.cx+r*Math.cos(end),y2=_7b.cy+r*Math.sin(end);var _82=m._degToRad(this.opt.fanSize);if(_7e.series.fill&&_7e.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&_81>_82){var _83=s.createGroup(),_84=Math.ceil(_81/_82),_85=_81/_84;_7f=this._shapeFill(_7e.series.fill,{x:_7b.cx-_7b.r,y:_7b.cy-_7b.r,width:2*_7b.r,height:2*_7b.r});for(var j=0;j<_84;++j){var _86=j==0?x1:_7b.cx+r*Math.cos(_70+(j-_67)*_85),_87=j==0?y1:_7b.cy+r*Math.sin(_70+(j-_67)*_85),_88=j==_84-1?x2:_7b.cx+r*Math.cos(_70+(j+1+_67)*_85),_89=j==_84-1?y2:_7b.cy+r*Math.sin(_70+(j+1+_67)*_85),fan=_83.createPath().moveTo(_7b.cx,_7b.cy).lineTo(_86,_87).arcTo(r,r,0,_85>Math.PI,true,_88,_89).lineTo(_7b.cx,_7b.cy).closePath().setFill(this._pseudoRadialFill(_7f,{x:_7b.cx,y:_7b.cy},r,_70+(j+0.5)*_85,_70+(j+0.5)*_85));}_83.createPath().moveTo(_7b.cx,_7b.cy).lineTo(x1,y1).arcTo(r,r,0,_81>Math.PI,true,x2,y2).lineTo(_7b.cx,_7b.cy).closePath().setStroke(_7e.series.stroke);_80=_83;}else{_80=s.createPath().moveTo(_7b.cx,_7b.cy).lineTo(x1,y1).arcTo(r,r,0,_81>Math.PI,true,x2,y2).lineTo(_7b.cx,_7b.cy).closePath().setStroke(_7e.series.stroke);var _7f=_7e.series.fill;if(_7f&&_7f.type==="radial"){_7f=this._shapeFill(_7f,{x:_7b.cx-_7b.r,y:_7b.cy-_7b.r,width:2*_7b.r,height:2*_7b.r});if(this.opt.radGrad==="linear"){_7f=this._pseudoRadialFill(_7f,{x:_7b.cx,y:_7b.cy},r,_70,end);}}else{if(_7f&&_7f.type==="linear"){_7f=this._plotFill(_7f,dim,_6b);_7f=this._shapeFill(_7f,_80.getBoundingBox());}}_80.setFill(_7f);}this.dyn.push({fill:_7f,stroke:_7e.series.stroke});if(_77){var o={element:"slice",index:i,run:this.run,shape:_80,x:i,y:typeof v=="number"?v:v.y,cx:_7b.cx,cy:_7b.cy,cr:r};this._connectEvents(o);_7c[i]=o;}_70=end;return false;},this);if(this.opt.labels){if(this.opt.labelStyle=="default"){_70=_6f;arr.some(_73,function(_8a,i){if(_8a<=0){return false;}var _8b=_78[i];if(_8a>=1){var v=run[i],_8c=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,_7b.cx,_7b.cy+_6d/2,"middle",_74[i],_8b.series.font,_8b.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(_8c);}return true;}var end=_70+_8a*2*Math.PI,v=run[i];if(i+1==_73.length){end=_6f+2*Math.PI;}var _8d=(_70+end)/2,x=_7b.cx+_76*Math.cos(_8d),y=_7b.cy+_76*Math.sin(_8d)+_6d/2;var _8c=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,x,y,"middle",_74[i],_8b.series.font,_8b.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(_8c);}_70=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){_70=_6f;var _8e=[];arr.forEach(_73,function(_8f,i){var end=_70+_8f*2*Math.PI;if(i+1==_73.length){end=_6f+2*Math.PI;}var _90=(_70+end)/2;_8e.push({angle:_90,left:Math.cos(_90)<0,theme:_78[i],index:i,omit:end-_70<0.001});_70=end;});var _91=g._base._getTextBox("a",{font:_6c}).h;this._getProperLabelRadius(_8e,_91,_7b.r*1.1);arr.forEach(_8e,function(_92,i){if(!_92.omit){var _93=_7b.cx-_7b.r*2,_94=_7b.cx+_7b.r*2,_95=g._base._getTextBox(_74[i],{font:_6c}).w,x=_7b.cx+_92.labelR*Math.cos(_92.angle),y=_7b.cy+_92.labelR*Math.sin(_92.angle),_96=(_92.left)?(_93+_95):(_94-_95),_97=(_92.left)?_93:_96;var _98=s.createPath().moveTo(_7b.cx+_7b.r*Math.cos(_92.angle),_7b.cy+_7b.r*Math.sin(_92.angle));if(Math.abs(_92.labelR*Math.cos(_92.angle))<_7b.r*2-_95){_98.lineTo(x,y);}_98.lineTo(_96,y).setStroke(_92.theme.series.labelWiring);var _99=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,_97,y,"left",_74[i],_92.theme.series.font,_92.theme.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(_99);}}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_7c[esi++];});return this;},_getProperLabelRadius:function(_9a,_9b,_9c){var _9d={},_9e={},_9f=1,_a0=1;if(_9a.length==1){_9a[0].labelR=_9c;return;}for(var i=0;i<_9a.length;i++){var _a1=Math.abs(Math.sin(_9a[i].angle));if(_9a[i].left){if(_9f>_a1){_9f=_a1;_9d=_9a[i];}}else{if(_a0>_a1){_a0=_a1;_9e=_9a[i];}}}_9d.labelR=_9e.labelR=_9c;this._calculateLabelR(_9d,_9a,_9b);this._calculateLabelR(_9e,_9a,_9b);},_calculateLabelR:function(_a2,_a3,_a4){var i=_a2.index,_a5=_a3.length,_a6=_a2.labelR;while(!(_a3[i%_a5].left^_a3[(i+1)%_a5].left)){if(!_a3[(i+1)%_a5].omit){var _a7=(Math.sin(_a3[i%_a5].angle)*_a6+((_a3[i%_a5].left)?(-_a4):_a4))/Math.sin(_a3[(i+1)%_a5].angle);_a6=(_a7<_a2.labelR)?_a2.labelR:_a7;_a3[(i+1)%_a5].labelR=_a6;}i++;}i=_a2.index;var j=(i==0)?_a5-1:i-1;while(!(_a3[i].left^_a3[j].left)){if(!_a3[j].omit){var _a7=(Math.sin(_a3[i].angle)*_a6+((_a3[i].left)?_a4:(-_a4)))/Math.sin(_a3[j].angle);_a6=(_a7<_a2.labelR)?_a2.labelR:_a7;_a3[j].labelR=_a6;}i--;j--;i=(i<0)?i+_a3.length:i;j=(j<0)?j+_a3.length:j;}},_getLabel:function(_a8){return dc.getLabel(_a8,this.opt.fixed,this.opt.precision);}});});},"dijit/hccss":function(){define("dijit/hccss",["require","dojo/_base/config","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/ready","dojo/_base/sniff","dojo/_base/window"],function(_a9,_aa,_ab,_ac,_ad,_ae,has,win){if(has("ie")||has("mozilla")){_ae(90,function(){var div=_ac.create("div",{id:"a11yTestNode",style:{cssText:"border: 1px solid;"+"border-color:red green;"+"position: absolute;"+"height: 5px;"+"top: -999px;"+"background-image: url(\""+(_aa.blankGif||_a9.toUrl("dojo/resources/blank.gif"))+"\");"}},win.body());var cs=_ad.getComputedStyle(div);if(cs){var _af=cs.backgroundImage;var _b0=(cs.borderTopColor==cs.borderRightColor)||(_af!=null&&(_af=="none"||_af=="url(invalid-url:)"));if(_b0){_ab.add(win.body(),"dijit_a11y");}if(has("ie")){div.outerHTML="";}else{win.body().removeChild(div);}}});}});},"dojox/charting/action2d/Shake":function(){define("dojox/charting/action2d/Shake",["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojo/fx","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx"],function(hub,_b1,_b2,df,dfe,m,gf){var _b3=3;return _b1("dojox.charting.action2d.Shake",_b2,{defaultParams:{duration:400,easing:dfe.backOut,shiftX:_b3,shiftY:_b3},optionalParams:{},constructor:function(_b4,_b5,_b6){if(!_b6){_b6={};}this.shiftX=typeof _b6.shiftX=="number"?_b6.shiftX:_b3;this.shiftY=typeof _b6.shiftY=="number"?_b6.shiftY:_b3;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _b7=o.run.name,_b8=o.index,_b9=[],_ba,_bb=o.type=="onmouseover"?this.shiftX:-this.shiftX,_bc=o.type=="onmouseover"?this.shiftY:-this.shiftY;if(_b7 in this.anim){_ba=this.anim[_b7][_b8];}else{this.anim[_b7]={};}if(_ba){_ba.action.stop(true);}else{this.anim[_b7][_b8]=_ba={};}var _bd={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_b9.push(gf.animateTransform(_bd));}if(o.oultine){_bd.shape=o.outline;_b9.push(gf.animateTransform(_bd));}if(o.shadow){_bd.shape=o.shadow;_b9.push(gf.animateTransform(_bd));}if(!_b9.length){delete this.anim[_b7][_b8];return;}_ba.action=df.combine(_b9);if(o.type=="onmouseout"){hub.connect(_ba.action,"onEnd",this,function(){if(this.anim[_b7]){delete this.anim[_b7][_b8];}});}_ba.action.play();}});});},"dojox/lang/functional/lambda":function(){define("dojox/lang/functional/lambda",["../..","dojo/_base/kernel","dojo/_base/lang","dojo/_base/array"],function(_be,_bf,_c0,arr){var df=_c0.getObject("lang.functional",true,_be);var _c1={};var _c2="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _c3=function(s){var _c4=[],_c5=_c2.call(s,/\s*->\s*/m);if(_c5.length>1){while(_c5.length){s=_c5.pop();_c4=_c5.pop().split(/\s*,\s*|\s+/m);if(_c5.length){_c5.push("(function("+_c4+"){return ("+s+")})");}}}else{if(s.match(/\b_\b/)){_c4=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_c4.push("$1");s="$1"+s;}if(r){_c4.push("$2");s=s+"$2";}}else{var _c6=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(_c6,function(v){if(!(v in t)){_c4.push(v);t[v]=1;}});}}}return {args:_c4,body:s};};var _c7=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};_c0.mixin(df,{rawLambda:function(s){return _c3(s);},buildLambda:function(s){s=_c3(s);return "function("+s.args.join(",")+"){return ("+s.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _c7(s);}if(s in _c1){return _c1[s];}s=_c3(s);return _c1[s]=new Function(s.args,"return ("+s.body+");");},clearLambdaCache:function(){_c1={};}});return df;});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/window","./lambda"],function(_c8,win,df){_c8.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/scaler/primitive":function(){define("dojox/charting/scaler/primitive",["dojo/_base/lang"],function(_c9){var _ca=_c9.getObject("dojox.charting.scaler.primitive",true);return _c9.mixin(_ca,{buildScaler:function(min,max,_cb,_cc){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:_cb/(max-min),span:_cb},scaler:_ca};},buildTicks:function(_cd,_ce){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_cf){var _d0=_cf.bounds.from,_d1=_cf.bounds.scale;return function(x){return (x-_d0)*_d1;};},getTransformerFromPlot:function(_d2){var _d3=_d2.bounds.from,_d4=_d2.bounds.scale;return function(x){return x/_d4+_d3;};}});});},"dojox/charting/plot2d/Candlesticks":function(){define("dojox/charting/plot2d/Candlesticks",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(_d5,_d6,arr,_d7,dc,df,dfr,du,fx){var _d8=dfr.lambda("item.purgeGroup()");return _d6("dojox.charting.plot2d.Candlesticks",_d7,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_d9,_da){this.opt=_d5.clone(this.defaultParams);du.updateWithObject(this.opt,_da);du.updateWithPattern(this.opt,_da,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_db){var _dc=_d5.delegate(dc.defaultStats);for(var i=0;i<_db.length;i++){var run=_db[i];if(!run.data.length){continue;}var _dd=_dc.vmin,_de=_dc.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_dc.hmin=Math.min(_dc.hmin,x);_dc.hmax=Math.max(_dc.hmax,x);_dc.vmin=Math.min(_dc.vmin,val.open,val.close,val.high,val.low);_dc.vmax=Math.max(_dc.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_dc.vmin=Math.min(_dd,run.ymin);}if("ymax" in run){_dc.vmax=Math.max(_de,run.ymax);}}return _dc;},getSeriesStats:function(){var _df=this.collectStats(this.series);_df.hmin-=0.5;_df.hmax+=0.5;return _df;},render:function(dim,_e0){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_e0);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_d8);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(_e1){_e1.cleanGroup(s);});}var t=this.chart.theme,f,gap,_e2,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_e3=Math.max(0,this._vScaler.bounds.lower),_e4=vt(_e3),_e5=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_e2=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _e6=t.next("candlestick",[this.opt,run]),s=run.group,_e7=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _e8=t.addMixin(_e6,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_e0.l+gap,y=dim.height-_e0.b,_e9=vt(v.open),_ea=vt(v.close),_eb=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>_eb){var tmp=_eb;_eb=low;low=tmp;}if(_e2>=1){var _ec=_e9>_ea;var _ed={x1:_e2/2,x2:_e2/2,y1:y-_eb,y2:y-low},_ee={x:0,y:y-Math.max(_e9,_ea),width:_e2,height:Math.max(_ec?_e9-_ea:_ea-_e9,1)};var _ef=s.createGroup();_ef.setTransform({dx:x,dy:0});var _f0=_ef.createGroup();_f0.createLine(_ed).setStroke(_e8.series.stroke);_f0.createRect(_ee).setStroke(_e8.series.stroke).setFill(_ec?_e8.series.fill:"white");if("mid" in v){_f0.createLine({x1:(_e8.series.stroke.width||1),x2:_e2-(_e8.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(_ec?"white":_e8.series.stroke);}run.dyn.fill=_e8.series.fill;run.dyn.stroke=_e8.series.stroke;if(_e5){var o={element:"candlestick",index:j,run:run,shape:_f0,x:x,y:y-Math.max(_e9,_ea),cx:_e2/2,cy:(y-Math.max(_e9,_ea))+(Math.max(_ec?_e9-_ea:_ea-_e9,1)/2),width:_e2,height:Math.max(_ec?_e9-_ea:_ea-_e9,1),data:v};this._connectEvents(o);_e7[j]=o;}}if(this.animate){this._animateCandlesticks(_ef,y-low,_eb-low);}}}this._eventSeries[run.name]=_e7;run.dirty=false;}this.dirty=false;return this;},_animateCandlesticks:function(_f1,_f2,_f3){fx.animateTransform(_d5.delegate({shape:_f1,duration:1200,transform:[{name:"translate",start:[0,_f2-(_f2/_f3)],end:[0,0]},{name:"scale",start:[1,1/_f3],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/widget/Sparkline":function(){define("dojox/charting/widget/Sparkline",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/html","dojo/query","./Chart","../themes/GreySkies","../plot2d/Lines","dojo/dom-prop"],function(_f4,_f5,_f6,_f7,_f8,_f9,_fa,_fb,_fc){_f6("dojox.charting.widget.Sparkline",_f9,{theme:_fa,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!_f8("> .axis, > .plot, > .action, > .series",n).length){var _fd=document.createElement("div");_fc.set(_fd,{"class":"plot","name":"default","type":this.type});n.appendChild(_fd);var _fe=document.createElement("div");_fc.set(_fe,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});_f5.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){_fc.set(_fe,i,this[i]);}},this);n.appendChild(_fe);}this.inherited(arguments);}});});},"dojox/gfx/matrix":function(){define("dojox/gfx/matrix",["./_base","dojo/_base/lang"],function(g,_ff){var m=g.matrix={};var _100={};m._degToRad=function(_101){return _100[_101]||(_100[_101]=(Math.PI*_101/180));};m._radToDeg=function(_102){return _102/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _103=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_103,r=m.normalize(arg[i]);_103=new m.Matrix2D();_103.xx=l.xx*r.xx+l.xy*r.yx;_103.xy=l.xx*r.xy+l.xy*r.yy;_103.yx=l.yx*r.xx+l.yy*r.yx;_103.yy=l.yx*r.xy+l.yy*r.yy;_103.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_103.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}_ff.mixin(this,_103);}}else{_ff.mixin(this,arg);}}}};_ff.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});_ff.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_104){var c=Math.cos(_104);var s=Math.sin(_104);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_105){return m.rotate(m._degToRad(_105));},skewX:function(_106){return new m.Matrix2D({xy:Math.tan(_106)});},skewXg:function(_107){return m.skewX(m._degToRad(_107));},skewY:function(_108){return new m.Matrix2D({yx:Math.tan(_108)});},skewYg:function(_109){return m.skewY(m._degToRad(_109));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_10a){return (_10a instanceof m.Matrix2D)?_10a:new m.Matrix2D(_10a);},clone:function(_10b){var obj=new m.Matrix2D();for(var i in _10b){if(typeof (_10b[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_10b[i]){obj[i]=_10b[i];}}return obj;},invert:function(_10c){var M=m.normalize(_10c),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_10d,x,y){return {x:_10d.xx*x+_10d.xy*y+_10d.dx,y:_10d.yx*x+_10d.yy*y+_10d.dy};},multiplyPoint:function(_10e,a,b){var M=m.normalize(_10e);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiply:function(_10f){var M=m.normalize(_10f);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_110,x,y){return m.multiply(m.translate(x,y),_110,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_111,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_111),a,b);}return m._sandwich(m.rotate(_111),a.x,a.y);},rotategAt:function(_112,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_112),a,b);}return m._sandwich(m.rotateg(_112),a.x,a.y);},skewXAt:function(_113,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_113),a,b);}return m._sandwich(m.skewX(_113),a.x,a.y);},skewXgAt:function(_114,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_114),a,b);}return m._sandwich(m.skewXg(_114),a.x,a.y);},skewYAt:function(_115,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_115),a,b);}return m._sandwich(m.skewY(_115),a.x,a.y);},skewYgAt:function(_116,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_116),a,b);}return m._sandwich(m.skewYg(_116),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/plot2d/Scatter":function(){define("dojox/charting/plot2d/Scatter",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx","dojox/gfx/gradutils"],function(lang,arr,_117,Base,dc,df,dfr,du,fx,_118){var _119=dfr.lambda("item.purgeGroup()");return _117("dojox.charting.plot2d.Scatter",Base,{defaultParams:{hAxis:"x",vAxis:"y",shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_11a,_11b){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_11b);du.updateWithPattern(this.opt,_11b,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_11c){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_11c);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_119);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_11d=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _11e=t.next("marker",[this.opt,run]),s=run.group,_11f,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(typeof run.data[0]=="number"){_11f=arr.map(run.data,function(v,i){return {x:ht(i+1)+_11c.l,y:dim.height-_11c.b-vt(v)};},this);}else{_11f=arr.map(run.data,function(v,i){return {x:ht(v.x)+_11c.l,y:dim.height-_11c.b-vt(v.y)};},this);}var _120=new Array(_11f.length),_121=new Array(_11f.length),_122=new Array(_11f.length);arr.forEach(_11f,function(c,i){var _123=typeof run.data[i]=="number"?t.post(_11e,"marker"):t.addMixin(_11e,"marker",run.data[i],true),path="M"+c.x+" "+c.y+" "+_123.symbol;if(_123.marker.shadow){_120[i]=s.createPath("M"+(c.x+_123.marker.shadow.dx)+" "+(c.y+_123.marker.shadow.dy)+" "+_123.symbol).setStroke(_123.marker.shadow).setFill(_123.marker.shadow.color);if(this.animate){this._animateScatter(_120[i],dim.height-_11c.b);}}if(_123.marker.outline){var _124=dc.makeStroke(_123.marker.outline);_124.width=2*_124.width+_123.marker.stroke.width;_122[i]=s.createPath(path).setStroke(_124);if(this.animate){this._animateScatter(_122[i],dim.height-_11c.b);}}var _125=dc.makeStroke(_123.marker.stroke),fill=this._plotFill(_123.marker.fill,dim,_11c);if(fill&&(fill.type==="linear"||fill.type=="radial")){var _126=_118.getColor(fill,{x:c.x,y:c.y});if(_125){_125.color=_126;}_121[i]=s.createPath(path).setStroke(_125).setFill(_126);}else{_121[i]=s.createPath(path).setStroke(_125).setFill(fill);}if(this.animate){this._animateScatter(_121[i],dim.height-_11c.b);}},this);if(_121.length){run.dyn.stroke=_121[_121.length-1].getStroke();run.dyn.fill=_121[_121.length-1].getFill();}if(_11d){var _127=new Array(_121.length);arr.forEach(_121,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_122&&_122[i]||null,shadow:_120&&_120[i]||null,cx:_11f[i].x,cy:_11f[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(o);_127[i]=o;},this);this._eventSeries[run.name]=_127;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateScatter:function(_128,_129){fx.animateTransform(lang.delegate({shape:_128,duration:1200,transform:[{name:"translate",start:[0,_129],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/scan":function(){define("dojox/lang/functional/scan",["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(d,_12a,df){var _12b={};d.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _12b)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,z,_12c=true;if(d.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _12b)){if(_12c){t=[z=a[i]];_12c=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dojox/color/_base":function(){define("dojox/color/_base",["dojo/_base/kernel","../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(dojo,_12d,lang,_12e,_12f){var cx=lang.getObject("dojox.color",true);cx.Color=_12e;cx.blend=_12e.blendColors;cx.fromRgb=_12e.fromRgb;cx.fromHex=_12e.fromHex;cx.fromArray=_12e.fromArray;cx.fromString=_12e.fromString;cx.greyscale=_12f.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_130,_131){if(lang.isArray(cyan)){_130=cyan[1],_131=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_130=cyan.m,_131=cyan.y,cyan=cyan.c;}}cyan/=100,_130/=100,_131/=100;var r=1-cyan,g=1-_130,b=1-_131;return new _12e({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_132,_133,_134){if(lang.isArray(cyan)){_132=cyan[1],_133=cyan[2],_134=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_132=cyan.m,_133=cyan.y,_134=cyan.b,cyan=cyan.c;}}cyan/=100,_132/=100,_133/=100,_134/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_134)+_134);g=1-Math.min(1,_132*(1-_134)+_134);b=1-Math.min(1,_133*(1-_134)+_134);return new _12e({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_135,_136){if(lang.isArray(hue)){_135=hue[1],_136=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_135=hue.s,_136=hue.l,hue=hue.h;}}_135/=100;_136/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_135*Math.min(r,1)+(1-_135);g=2*_135*Math.min(g,1)+(1-_135);b=2*_135*Math.min(b,1)+(1-_135);if(_136<0.5){r*=_136,g*=_136,b*=_136;}else{r=(1-_136)*r+2*_136-1;g=(1-_136)*g+2*_136-1;b=(1-_136)*b+2*_136-1;}return new _12e({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_137,_138){if(lang.isArray(hue)){_137=hue[1],_138=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_137=hue.s,_138=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_137/=100;_138/=100;var r,g,b;if(_137==0){r=_138,b=_138,g=_138;}else{var _139=hue/60,i=Math.floor(_139),f=_139-i;var p=_138*(1-_137);var q=_138*(1-(_137*f));var t=_138*(1-(_137*(1-f)));switch(i){case 0:r=_138,g=t,b=p;break;case 1:r=q,g=_138,b=p;break;case 2:r=p,g=_138,b=t;break;case 3:r=p,g=q,b=_138;break;case 4:r=t,g=p,b=_138;break;case 5:r=_138,g=p,b=q;break;}}return new _12e({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_12e,{toCmy:function(){var cyan=1-(this.r/255),_13a=1-(this.g/255),_13b=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_13a*100),y:Math.round(_13b*100)};},toCmyk:function(){var cyan,_13c,_13d,_13e;var r=this.r/255,g=this.g/255,b=this.b/255;_13e=Math.min(1-r,1-g,1-b);cyan=(1-r-_13e)/(1-_13e);_13c=(1-g-_13e)/(1-_13e);_13d=(1-b-_13e)/(1-_13e);return {c:Math.round(cyan*100),m:Math.round(_13c*100),y:Math.round(_13d*100),b:Math.round(_13e*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _13f=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_13f/((l<0.5)?(2*l):(2-2*l));}if(_13f>0){if(max==r&&max!=g){h+=(g-b)/_13f;}if(max==g&&max!=b){h+=(2+(b-r)/_13f);}if(max==b&&max!=r){h+=(4+(r-g)/_13f);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _140=max-min;var h=null,s=(max==0)?0:(_140/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_140;}else{if(g==max){h=120+60*(b-r)/_140;}else{h=240+60*(r-g)/_140;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojox/charting/plot2d/OHLC":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_141,Base,dc,df,dfr,du,fx){var _142=dfr.lambda("item.purgeGroup()");return _141("dojox.charting.plot2d.OHLC",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_143,_144){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_144);du.updateWithPattern(this.opt,_144,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_145){var _146=lang.delegate(dc.defaultStats);for(var i=0;i<_145.length;i++){var run=_145[i];if(!run.data.length){continue;}var _147=_146.vmin,_148=_146.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_146.hmin=Math.min(_146.hmin,x);_146.hmax=Math.max(_146.hmax,x);_146.vmin=Math.min(_146.vmin,val.open,val.close,val.high,val.low);_146.vmax=Math.max(_146.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_146.vmin=Math.min(_147,run.ymin);}if("ymax" in run){_146.vmax=Math.max(_148,run.ymax);}}return _146;},getSeriesStats:function(){var _149=this.collectStats(this.series);_149.hmin-=0.5;_149.hmax+=0.5;return _149;},render:function(dim,_14a){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_14a);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_142);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_14b,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_14c=Math.max(0,this._vScaler.bounds.lower),_14d=vt(_14c),_14e=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_14b=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _14f=t.next("candlestick",[this.opt,run]),s=run.group,_150=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _151=t.addMixin(_14f,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_14a.l+gap,y=dim.height-_14a.b,open=vt(v.open),_152=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_14b>=1){var hl={x1:_14b/2,x2:_14b/2,y1:y-high,y2:y-low},op={x1:0,x2:((_14b/2)+((_151.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_14b/2)-((_151.series.stroke.width||1)/2)),x2:_14b,y1:y-_152,y2:y-_152};var _153=s.createGroup();_153.setTransform({dx:x,dy:0});var _154=_153.createGroup();_154.createLine(hl).setStroke(_151.series.stroke);_154.createLine(op).setStroke(_151.series.stroke);_154.createLine(cl).setStroke(_151.series.stroke);run.dyn.stroke=_151.series.stroke;if(_14e){var o={element:"candlestick",index:j,run:run,shape:_154,x:x,y:y-Math.max(open,_152),cx:_14b/2,cy:(y-Math.max(open,_152))+(Math.max(open>_152?open-_152:_152-open,1)/2),width:_14b,height:Math.max(open>_152?open-_152:_152-open,1),data:v};this._connectEvents(o);_150[j]=o;}}if(this.animate){this._animateOHLC(_153,y-low,high-low);}}}this._eventSeries[run.name]=_150;run.dirty=false;}this.dirty=false;return this;},_animateOHLC:function(_155,_156,_157){fx.animateTransform(lang.delegate({shape:_155,duration:1200,transform:[{name:"translate",start:[0,_156-(_156/_157)],end:[0,0]},{name:"scale",start:[1,1/_157],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/plot2d/ClusteredColumns":function(){define("dojox/charting/plot2d/ClusteredColumns",["dojo/_base/array","dojo/_base/declare","./Columns","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils"],function(arr,_158,_159,dc,df,dfr,du){var _15a=dfr.lambda("item.purgeGroup()");return _158("dojox.charting.plot2d.ClusteredColumns",_159,{render:function(dim,_15b){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_15b);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_15a);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_15c,_15d,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_15e=Math.max(0,this._vScaler.bounds.lower),_15f=vt(_15e),_160=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_15c=_15d=f.size;for(var i=0;i<this.series.length;++i){var run=this.series[i],_161=_15d*i;if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _162=t.next("column",[this.opt,run]),s=run.group,_163=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _164=run.data[j];if(_164!==null){var v=typeof _164=="number"?_164:_164.y,vv=vt(v),_165=vv-_15f,h=Math.abs(_165),_166=typeof _164!="number"?t.addMixin(_162,"column",_164,true):t.post(_162,"column");if(_15c>=1&&h>=0){var rect={x:_15b.l+ht(j+0.5)+gap+_161,y:dim.height-_15b.b-(v>_15e?vv:_15f),width:_15c,height:h};var _167=this._plotFill(_166.series.fill,dim,_15b);_167=this._shapeFill(_167,rect);var _168=s.createRect(rect).setFill(_167).setStroke(_166.series.stroke);run.dyn.fill=_168.getFill();run.dyn.stroke=_168.getStroke();if(_160){var o={element:"column",index:j,run:run,shape:_168,x:j+0.5,y:v};this._connectEvents(o);_163[j]=o;}if(this.animate){this._animateColumn(_168,dim.height-_15b.b-_15f,h);}}}}this._eventSeries[run.name]=_163;run.dirty=false;}this.dirty=false;return this;}});});},"dojox/charting/Chart":function(){define("dojox/charting/Chart",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/html","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/_base/sniff","./Element","./Theme","./Series","./axis2d/common","dojox/gfx","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(lang,arr,_169,html,dom,_16a,_16b,_16c,has,_16d,_16e,_16f,_170,g,func,_171,_172){var dc=dojox.charting,_173=func.lambda("item.clear()"),_174=func.lambda("item.purgeGroup()"),_175=func.lambda("item.destroy()"),_176=func.lambda("item.dirty = false"),_177=func.lambda("item.dirty = true"),_178=func.lambda("item.name");_169("dojox.charting.Chart",null,{constructor:function(node,_179){if(!_179){_179={};}this.margins=_179.margins?_179.margins:{l:10,t:10,r:10,b:10};this.stroke=_179.stroke;this.fill=_179.fill;this.delayInMs=_179.delayInMs||200;this.title=_179.title;this.titleGap=_179.titleGap;this.titlePos=_179.titlePos;this.titleFont=_179.titleFont;this.titleFontColor=_179.titleFontColor;this.chartTitle=null;this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.coords=null;this.node=dom.byId(node);var box=_16a.getMarginBox(node);this.surface=g.createSurface(this.node,box.w||400,box.h||300);},destroy:function(){arr.forEach(this.series,_175);arr.forEach(this.stack,_175);func.forIn(this.axes,_175);if(this.chartTitle&&this.chartTitle.tagName){_16b.destroy(this.chartTitle);}this.surface.destroy();},getCoords:function(){if(!this.coords){this.coords=html.coords(this.node,true);}return this.coords;},setTheme:function(_17a){this.theme=_17a.clone();this.dirty=true;return this;},addAxis:function(name,_17b){var axis,_17c=_17b&&_17b.type||"Default";if(typeof _17c=="string"){if(!dc.axis2d||!dc.axis2d[_17c]){throw Error("Can't find axis: "+_17c+" - Check "+"require() dependencies.");}axis=new dc.axis2d[_17c](this,_17b);}else{axis=new _17c(this,_17b);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_17d){var plot,_17e=_17d&&_17d.type||"Default";if(typeof _17e=="string"){if(!dc.plot2d||!dc.plot2d[_17e]){throw Error("Can't find plot: "+_17e+" - didn't you forget to dojo"+".require() it?");}plot=new dc.plot2d[_17e](this,_17d);}else{plot=new _17e(this,_17d);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},getPlot:function(name){return this.stack[this.plots[name]];},removePlot:function(name){if(name in this.plots){var _17f=this.plots[name];delete this.plots[name];this.stack[_17f].destroy();this.stack.splice(_17f,1);func.forIn(this.plots,function(idx,name,_180){if(idx>_17f){_180[name]=idx-1;}});var ns=arr.filter(this.series,function(run){return run.plot!=name;});if(ns.length<this.series.length){arr.forEach(this.series,function(run){if(run.plot==name){run.destroy();}});this.runs={};arr.forEach(ns,function(run,_181){this.runs[run.plot]=_181;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return func.map(this.stack,_178);},setPlotOrder:function(_182){var _183={},_184=func.filter(_182,function(name){if(!(name in this.plots)||(name in _183)){return false;}_183[name]=1;return true;},this);if(_184.length<this.stack.length){func.forEach(this.stack,function(plot){var name=plot.name;if(!(name in _183)){_184.push(name);}});}var _185=func.map(_184,function(name){return this.stack[this.plots[name]];},this);func.forEach(_185,function(plot,i){this.plots[plot.name]=i;},this);this.stack=_185;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var _186=this.plots[name];if(_186){var _187=this.getPlotOrder();_187.splice(_186,1);_187.unshift(name);return this.setPlotOrder(_187);}}return this;},movePlotToBack:function(name){if(name in this.plots){var _188=this.plots[name];if(_188<this.stack.length-1){var _189=this.getPlotOrder();_189.splice(_188,1);_189.push(name);return this.setPlotOrder(_189);}}return this;},addSeries:function(name,data,_18a){var run=new _16f(this,data,_18a);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(name){return this.series[this.runs[name]];},removeSeries:function(name){if(name in this.runs){var _18b=this.runs[name];delete this.runs[name];this.series[_18b].destroy();this.series.splice(_18b,1);func.forIn(this.runs,function(idx,name,runs){if(idx>_18b){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}return this;},getSeriesOrder:function(_18c){return func.map(func.filter(this.series,function(run){return run.plot==_18c;}),_178);},setSeriesOrder:function(_18d){var _18e,_18f={},_190=func.filter(_18d,function(name){if(!(name in this.runs)||(name in _18f)){return false;}var run=this.series[this.runs[name]];if(_18e){if(run.plot!=_18e){return false;}}else{_18e=run.plot;}_18f[name]=1;return true;},this);func.forEach(this.series,function(run){var name=run.name;if(!(name in _18f)&&run.plot==_18e){_190.push(name);}});var _191=func.map(_190,function(name){return this.series[this.runs[name]];},this);this.series=_191.concat(func.filter(this.series,function(run){return run.plot!=_18e;}));func.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var _192=this.runs[name],_193=this.getSeriesOrder(this.series[_192].plot);if(name!=_193[0]){_193.splice(_192,1);_193.unshift(name);return this.setSeriesOrder(_193);}}return this;},moveSeriesToBack:function(name){if(name in this.runs){var _194=this.runs[name],_195=this.getSeriesOrder(this.series[_194].plot);if(name!=_195[_195.length-1]){_195.splice(_194,1);_195.push(name);return this.setSeriesOrder(_195);}}return this;},resize:function(_196,_197){var box;switch(arguments.length){case 1:box=lang.mixin({},_196);_16a.setMarginBox(this.node,box);break;case 2:box={w:_196,h:_197};_16a.setMarginBox(this.node,box);break;}box=_16a.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;this.coords=null;return this.render();}else{return this;}},getGeometry:function(){var ret={};func.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_198,_199,zoom){var axis=this.axes[name];if(axis){axis.setWindow(_198,_199);arr.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}});}return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea" in this)){this.calculateGeometry();}func.forIn(this.axes,function(axis){var _19a,_19b,_19c=axis.getScaler().bounds,s=_19c.span/(_19c.upper-_19c.lower);if(axis.vertical){_19a=sy;_19b=dy/s/_19a;}else{_19a=sx;_19b=dx/s/_19a;}axis.setWindow(_19a,_19b);});arr.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,_19d){var axis=this.axes[name];if(axis){var _19e,_19f,_1a0=axis.getScaler().bounds;var _1a1=Math.min(_19d[0],_19d[1]);var _1a2=Math.max(_19d[0],_19d[1]);_1a1=_19d[0]<_1a0.lower?_1a0.lower:_1a1;_1a2=_19d[1]>_1a0.upper?_1a0.upper:_1a2;_19e=(_1a0.upper-_1a0.lower)/(_1a2-_1a1);_19f=_1a1-_1a0.lower;this.setAxisWindow(name,_19e,_19f);this.render();}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _1a3=arr.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);_1a4(_1a3,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();arr.forEach(this.stack,_173);if(!this.theme){this.setTheme(new _16e(dojox.charting._def));}arr.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);arr.forEach(this.stack,function(plot){if(plot.hAxis){plot.setAxis(this.axes[plot.hAxis]);}if(plot.vAxis){plot.setAxis(this.axes[plot.vAxis]);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);func.forIn(this.axes,_173);_1a4(this.stack,dim);var _1a5=this.offsets={l:0,r:0,t:0,b:0};func.forIn(this.axes,function(axis){func.forIn(axis.getOffsets(),function(o,i){_1a5[i]+=o;});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";var _1a6=g.normalizedLength(g.splitFontString(this.titleFont).size);_1a5[this.titlePos=="top"?"t":"b"]+=(_1a6+this.titleGap);}func.forIn(this.margins,function(o,i){_1a5[i]+=o;});this.plotArea={width:dim.width-_1a5.l-_1a5.r,height:dim.height-_1a5.t-_1a5.b};func.forIn(this.axes,_173);_1a4(this.stack,this.plotArea);return this;},render:function(){if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();func.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);func.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();if(this.surface.render){this.surface.render();}return this;},fullRender:function(){this.fullGeometry();var _1a7=this.offsets,dim=this.dim,rect;arr.forEach(this.series,_174);func.forIn(this.axes,_174);arr.forEach(this.stack,_174);if(this.chartTitle&&this.chartTitle.tagName){_16b.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;var t=this.theme,fill=t.plotarea&&t.plotarea.fill,_1a8=t.plotarea&&t.plotarea.stroke,w=Math.max(0,dim.width-_1a7.l-_1a7.r),h=Math.max(0,dim.height-_1a7.t-_1a7.b),rect={x:_1a7.l-1,y:_1a7.t-1,width:w+2,height:h+2};if(fill){fill=_16d.prototype._shapeFill(_16d.prototype._plotFill(fill,dim,_1a7),rect);this.surface.createRect(rect).setFill(fill);}if(_1a8){this.surface.createRect({x:_1a7.l,y:_1a7.t,width:w+1,height:h+1}).setStroke(_1a8);}func.foldr(this.stack,function(z,plot){return plot.render(dim,_1a7),0;},0);fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);_1a8=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node,fill=new _16c(html.style(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new _16c(html.style(node,"backgroundColor"));node=node.parentNode;}}if(fill){fill=_16d.prototype._plotFill(fill,dim,_1a7);if(_1a7.l){rect={width:_1a7.l,height:dim.height+1};this.surface.createRect(rect).setFill(_16d.prototype._shapeFill(fill,rect));}if(_1a7.r){rect={x:dim.width-_1a7.r,width:_1a7.r+1,height:dim.height+2};this.surface.createRect(rect).setFill(_16d.prototype._shapeFill(fill,rect));}if(_1a7.t){rect={width:dim.width+1,height:_1a7.t};this.surface.createRect(rect).setFill(_16d.prototype._shapeFill(fill,rect));}if(_1a7.b){rect={y:dim.height-_1a7.b,width:dim.width+1,height:_1a7.b+2};this.surface.createRect(rect).setFill(_16d.prototype._shapeFill(fill,rect));}}if(_1a8){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_1a8);}if(this.title){var _1a9=(g.renderer=="canvas"),_1aa=_1a9||!has("ie")&&!has("opera")?"html":"gfx",_1ab=g.normalizedLength(g.splitFontString(this.titleFont).size);this.chartTitle=_170.createText[_1aa](this,this.surface,dim.width/2,this.titlePos=="top"?_1ab+this.margins.t:dim.height-this.margins.b,"middle",this.title,this.titleFont,this.titleFontColor);}func.forIn(this.axes,function(axis){axis.render(dim,_1a7);});this._makeClean();if(this.surface.render){this.surface.render();}return this;},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(lang.hitch(this,function(){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;this.render();}),this.delayInMs);}return this;},connectToPlot:function(name,_1ac,_1ad){return name in this.plots?this.stack[this.plots[name]].connect(_1ac,_1ad):null;},fireEvent:function(_1ae,_1af,_1b0){if(_1ae in this.runs){var _1b1=this.series[this.runs[_1ae]].plot;if(_1b1 in this.plots){var plot=this.stack[this.plots[_1b1]];if(plot){plot.fireEvent(_1ae,_1af,_1b0);}}}return this;},_makeClean:function(){arr.forEach(this.axes,_176);arr.forEach(this.stack,_176);arr.forEach(this.series,_176);this.dirty=false;},_makeDirty:function(){arr.forEach(this.axes,_177);arr.forEach(this.stack,_177);arr.forEach(this.series,_177);this.dirty=true;},_invalidateDependentPlots:function(_1b2,_1b3){if(_1b2 in this.plots){var plot=this.stack[this.plots[_1b2]],axis,_1b4=_1b3?"vAxis":"hAxis";if(plot[_1b4]){axis=this.axes[plot[_1b4]];if(axis&&axis.dependOnData()){axis.dirty=true;arr.forEach(this.stack,function(p){if(p[_1b4]&&p[_1b4]==plot[_1b4]){p.dirty=true;}});}}else{plot.dirty=true;}}}});function _1b5(_1b6){return {min:_1b6.hmin,max:_1b6.hmax};};function _1b7(_1b8){return {min:_1b8.vmin,max:_1b8.vmax};};function _1b9(_1ba,h){_1ba.hmin=h.min;_1ba.hmax=h.max;};function _1bb(_1bc,v){_1bc.vmin=v.min;_1bc.vmax=v.max;};function _1bd(_1be,_1bf){if(_1be&&_1bf){_1be.min=Math.min(_1be.min,_1bf.min);_1be.max=Math.max(_1be.max,_1bf.max);}return _1be||_1bf;};function _1a4(_1c0,_1c1){var _1c2={},axes={};arr.forEach(_1c0,function(plot){var _1c3=_1c2[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=_1bd(axes[plot.hAxis],_1b5(_1c3));}if(plot.vAxis){axes[plot.vAxis]=_1bd(axes[plot.vAxis],_1b7(_1c3));}});arr.forEach(_1c0,function(plot){var _1c4=_1c2[plot.name];if(plot.hAxis){_1b9(_1c4,axes[plot.hAxis]);}if(plot.vAxis){_1bb(_1c4,axes[plot.vAxis]);}plot.initializeScalers(_1c1,_1c4);});};return dojox.charting.Chart;});},"dojox/lang/functional/sequence":function(){define("dojox/lang/functional/sequence",["dojo/_base/lang","./lambda"],function(lang,df){lang.mixin(df,{repeat:function(n,f,z,o){o=o||dojo.global;f=df.lambda(f);var t=new Array(n),i=1;t[0]=z;for(;i<n;t[i]=z=f.call(o,z),++i){}return t;},until:function(pr,f,z,o){o=o||dojo.global;f=df.lambda(f);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(z),z=f.call(o,z)){}return t;}});return df;});},"dojox/charting/plot2d/MarkersOnly":function(){define("dojox/charting/plot2d/MarkersOnly",["dojo/_base/declare","./Default"],function(_1c5,_1c6){return _1c5("dojox.charting.plot2d.MarkersOnly",_1c6,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});});},"dojox/charting/plot2d/Areas":function(){define("dojox/charting/plot2d/Areas",["dojo/_base/declare","./Default"],function(_1c7,_1c8){return _1c7("dojox.charting.plot2d.Areas",_1c8,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/action2d/Base":function(){define("dojox/charting/action2d/Base",["dojo/_base/lang","dojo/_base/declare"],function(lang,_1c9){return _1c9("dojox.charting.action2d.Base",null,{constructor:function(_1ca,plot){this.chart=_1ca;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./_base/connect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_1cb,dojo,_1cc,_1cd,_1ce,dom,_1cf,geom,_1d0,_1d1){if(!dojo.isAsync){_1d0(0,function(){var _1d2=["./fx/Toggler"];_1d1(_1d2);});}var _1d3=dojo.fx={};var _1d4={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _1d5=function(_1d6){this._index=-1;this._animations=_1d6||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_1cc.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_1d5.prototype=new _1cb();lang.extend(_1d5,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){_1cd.disconnect(this._onAnimateCtx);_1cd.disconnect(this._onEndCtx);this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_1cd.connect(this._current,"onAnimate",this,"_onAnimate");this._onEndCtx=_1cd.connect(this._current,"onEnd",this,"_onEnd");this._current.play(0,true);}},play:function(_1d7,_1d8){if(!this._current){this._current=this._animations[this._index=0];}if(!_1d8&&this._current.status()=="playing"){return this;}var _1d9=_1cd.connect(this._current,"beforeBegin",this,function(){this._fire("beforeBegin");}),_1da=_1cd.connect(this._current,"onBegin",this,function(arg){this._fire("onBegin",arguments);}),_1db=_1cd.connect(this._current,"onPlay",this,function(arg){this._fire("onPlay",arguments);_1cd.disconnect(_1d9);_1cd.disconnect(_1da);_1cd.disconnect(_1db);});if(this._onAnimateCtx){_1cd.disconnect(this._onAnimateCtx);}this._onAnimateCtx=_1cd.connect(this._current,"onAnimate",this,"_onAnimate");if(this._onEndCtx){_1cd.disconnect(this._onEndCtx);}this._onEndCtx=_1cd.connect(this._current,"onEnd",this,"_onEnd");this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_1cd.connect(this._current,"onPause",this,function(arg){this._fire("onPause",arguments);_1cd.disconnect(e);});this._current.pause();}return this;},gotoPercent:function(_1dc,_1dd){this.pause();var _1de=this.duration*_1dc;this._current=null;_1cc.some(this._animations,function(a){if(a.duration<=_1de){this._current=a;return true;}_1de-=a.duration;return false;});if(this._current){this._current.gotoPercent(_1de/this._current.duration,_1dd);}return this;},stop:function(_1df){if(this._current){if(_1df){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_1cd.connect(this._current,"onStop",this,function(arg){this._fire("onStop",arguments);_1cd.disconnect(e);});this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){_1cd.disconnect(this._onAnimateCtx);}if(this._onEndCtx){_1cd.disconnect(this._onEndCtx);}}});lang.extend(_1d5,_1d4);_1d3.chain=function(_1e0){return new _1d5(_1e0);};var _1e1=function(_1e2){this._animations=_1e2||[];this._connects=[];this._finished=0;this.duration=0;_1cc.forEach(_1e2,function(a){var _1e3=a.duration;if(a.delay){_1e3+=a.delay;}if(this.duration<_1e3){this.duration=_1e3;}this._connects.push(_1cd.connect(a,"onEnd",this,"_onEnd"));},this);this._pseudoAnimation=new _1ce.Animation({curve:[0,1],duration:this.duration});var self=this;_1cc.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_1cd.connect(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);}));});};lang.extend(_1e1,{_doAction:function(_1e4,args){_1cc.forEach(this._animations,function(a){a[_1e4].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_1e5,args){var t=this._pseudoAnimation;t[_1e5].apply(t,args);},play:function(_1e6,_1e7){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_1e8,_1e9){var ms=this.duration*_1e8;_1cc.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_1e9);});this._call("gotoPercent",arguments);return this;},stop:function(_1ea){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_1cc.forEach(this._connects,_1cd.disconnect);}});lang.extend(_1e1,_1d4);_1d3.combine=function(_1eb){return new _1e1(_1eb);};_1d3.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1ce.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _1ec=_1cf.get(node,"height");return Math.max(_1ec,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_1cd.connect(anim,"onStop",fini);_1cd.connect(anim,"onEnd",fini);return anim;};_1d3.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1ce.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_1cd.connect(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";});var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_1cd.connect(anim,"onStop",fini);_1cd.connect(anim,"onEnd",fini);return anim;};_1d3.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_1cf.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_1ce.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_1cd.connect(anim,"beforeBegin",anim,init);return anim;};return _1d3;});},"dojox/gfx/fx":function(){define("dojox/gfx/fx",["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect"],function(lang,g,m,_1ed,arr,fx,Hub){var fxg=g.fx={};function _1ee(_1ef,end){this.start=_1ef,this.end=end;};_1ee.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _1f0(_1f1,end,_1f2){this.start=_1f1,this.end=end;this.units=_1f2;};_1f0.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _1f3(_1f4,end){this.start=_1f4,this.end=end;this.temp=new _1ed();};_1f3.prototype.getValue=function(r){return _1ed.blendColors(this.start,this.end,r,this.temp);};function _1f5(_1f6){this.values=_1f6;this.length=_1f6.length;};_1f5.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _1f7(_1f8,def){this.values=_1f8;this.def=def?def:{};};_1f7.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _1f9(_1fa,_1fb){this.stack=_1fa;this.original=_1fb;};_1f9.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_1fc=f.apply(m,val);if(_1fc instanceof m.Matrix2D){ret.push(_1fc);}},this);return ret;};var _1fd=new _1ed(0,0,0,0);function _1fe(prop,obj,name,def){if(prop.values){return new _1f5(prop.values);}var _1ff,_200,end;if(prop.start){_200=g.normalizeColor(prop.start);}else{_200=_1ff=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_1ff){_1ff=obj?(name?obj[name]:obj):def;}end=_1ff;}return new _1f3(_200,end);};function _201(prop,obj,name,def){if(prop.values){return new _1f5(prop.values);}var _202,_203,end;if(prop.start){_203=prop.start;}else{_203=_202=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _202!="number"){_202=obj?obj[name]:def;}end=_202;}return new _1ee(_203,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_204=args.shape,_205;Hub.connect(anim,"beforeBegin",anim,function(){_205=_204.getStroke();var prop=args.color,_206={},_207,_208,end;if(prop){_206.color=_1fe(prop,_205,"color",_1fd);}prop=args.style;if(prop&&prop.values){_206.style=new _1f5(prop.values);}prop=args.width;if(prop){_206.width=_201(prop,_205,"width",1);}prop=args.cap;if(prop&&prop.values){_206.cap=new _1f5(prop.values);}prop=args.join;if(prop){if(prop.values){_206.join=new _1f5(prop.values);}else{_208=prop.start?prop.start:(_205&&_205.join||0);end=prop.end?prop.end:(_205&&_205.join||0);if(typeof _208=="number"&&typeof end=="number"){_206.join=new _1ee(_208,end);}}}this.curve=new _1f7(_206,_205);});Hub.connect(anim,"onAnimate",_204,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_209=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_209.getFill();var prop=args.color,_20a={};if(prop){this.curve=_1fe(prop,fill,"",_1fd);}});Hub.connect(anim,"onAnimate",_209,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_20b=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_20b.getFont();var prop=args.style,_20c={},_20d,_20e,end;if(prop&&prop.values){_20c.style=new _1f5(prop.values);}prop=args.variant;if(prop&&prop.values){_20c.variant=new _1f5(prop.values);}prop=args.weight;if(prop&&prop.values){_20c.weight=new _1f5(prop.values);}prop=args.family;if(prop&&prop.values){_20c.family=new _1f5(prop.values);}prop=args.size;if(prop&&prop.units){_20e=parseFloat(prop.start?prop.start:(_20b.font&&_20b.font.size||"0"));end=parseFloat(prop.end?prop.end:(_20b.font&&_20b.font.size||"0"));_20c.size=new _1f0(_20e,end,prop.units);}this.curve=new _1f7(_20c,font);});Hub.connect(anim,"onAnimate",_20b,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_20f=args.shape,_210;Hub.connect(anim,"beforeBegin",anim,function(){_210=_20f.getTransform();this.curve=new _1f9(args.transform,_210);});Hub.connect(anim,"onAnimate",_20f,"setTransform");return anim;};return fxg;});},"dojox/charting/action2d/PlotAction":function(){define("dojox/charting/action2d/PlotAction",["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional","dojox/lang/functional/object"],function(hub,_211,Base,dfe,df,dlfo){var _212=400,_213=dfe.backOut;return _211("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_214,plot,_215){this.anim={};if(!_215){_215={};}this.duration=_215.duration?_215.duration:_212;this.easing=_215.easing?_215.easing:_213;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dijit/BackgroundIframe":function(){define("dijit/BackgroundIframe",["require",".","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/_base/sniff","dojo/_base/window"],function(_216,_217,_218,_219,_21a,lang,on,has,win){var _21b=new function(){var _21c=[];this.pop=function(){var _21d;if(_21c.length){_21d=_21c.pop();_21d.style.display="";}else{if(has("ie")<9){var burl=_218["dojoBlankHtmlUrl"]||_216.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_21d=win.doc.createElement(html);}else{_21d=_219.create("iframe");_21d.src="javascript:\"\"";_21d.className="dijitBackgroundIframe";_21d.setAttribute("role","presentation");_21a.set(_21d,"opacity",0.1);}_21d.tabIndex=-1;}return _21d;};this.push=function(_21e){_21e.style.display="none";_21c.push(_21e);};}();_217.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("ie")||has("mozilla")){var _21f=(this.iframe=_21b.pop());node.appendChild(_21f);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,function(){this.resize(node);}));}else{_21a.set(_21f,{width:"100%",height:"100%"});}}};lang.extend(_217.BackgroundIframe,{resize:function(node){if(this.iframe){_21a.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){_21b.push(this.iframe);delete this.iframe;}}});return _217.BackgroundIframe;});},"dojox/main":function(){define("dojox/main",["dojo/_base/kernel"],function(dojo){return dojo.dojox;});},"dojox/charting/action2d/Magnify":function(){define("dojox/charting/action2d/Magnify",["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/gfx/fx","dojo/fx","dojo/fx/easing"],function(Hub,_220,_221,m,gf,df,dfe){var _222=2;return _220("dojox.charting.action2d.Magnify",_221,{defaultParams:{duration:400,easing:dfe.backOut,scale:_222},optionalParams:{},constructor:function(_223,plot,_224){this.scale=_224&&typeof _224.scale=="number"?_224.scale:_222;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}var _225=o.run.name,_226=o.index,_227=[],anim,init,_228;if(_225 in this.anim){anim=this.anim[_225][_226];}else{this.anim[_225]={};}if(anim){anim.action.stop(true);}else{this.anim[_225][_226]=anim={};}if(o.type=="onmouseover"){init=m.identity;_228=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_228=1/this.scale;}var _229={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_228,o.cx,o.cy]},init]};if(o.shape){_227.push(gf.animateTransform(_229));}if(o.oultine){_229.shape=o.outline;_227.push(gf.animateTransform(_229));}if(o.shadow){_229.shape=o.shadow;_227.push(gf.animateTransform(_229));}if(!_227.length){delete this.anim[_225][_226];return;}anim.action=df.combine(_227);if(o.type=="onmouseout"){Hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_225]){delete this.anim[_225][_226];}});}anim.action.play();}});});},"dojo/Stateful":function(){define(["./_base/kernel","./_base/declare","./_base/lang","./_base/array"],function(dojo,_22a,lang,_22b){return dojo.declare("dojo.Stateful",null,{postscript:function(_22c){if(_22c){lang.mixin(this,_22c);}},get:function(name){return this[name];},set:function(name,_22d){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _22e=this[name];this[name]=_22d;if(this._watchCallbacks){this._watchCallbacks(name,_22e,_22d);}return this;},watch:function(name,_22f){var _230=this._watchCallbacks;if(!_230){var self=this;_230=this._watchCallbacks=function(name,_231,_232,_233){var _234=function(_235){if(_235){_235=_235.slice();for(var i=0,l=_235.length;i<l;i++){try{_235[i].call(self,name,_231,_232);}catch(e){console.error(e);}}}};_234(_230["_"+name]);if(!_233){_234(_230["*"]);}};}if(!_22f&&typeof name==="function"){_22f=name;name="*";}else{name="_"+name;}var _236=_230[name];if(typeof _236!=="object"){_236=_230[name]=[];}_236.push(_22f);return {unwatch:function(){_236.splice(_22b.indexOf(_236,_22f),1);}};}});});},"dojox/charting/plot2d/Markers":function(){define("dojox/charting/plot2d/Markers",["dojo/_base/declare","./Default"],function(_237,_238){return _237("dojox.charting.plot2d.Markers",_238,{constructor:function(){this.opt.markers=true;}});});},"dojox/charting/plot2d/Bubble":function(){define("dojox/charting/plot2d/Bubble",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_239,arr,Base,dc,df,dfr,du,fx){var _23a=dfr.lambda("item.purgeGroup()");return _239("dojox.charting.plot2d.Bubble",Base,{defaultParams:{hAxis:"x",vAxis:"y",animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_23b,_23c){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_23c);du.updateWithPattern(this.opt,_23c,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_23d){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_23d);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_23a);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_23e=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var _23f=t.next("circle",[this.opt,run]),s=run.group,_240=arr.map(run.data,function(v,i){return v?{x:ht(v.x)+_23d.l,y:dim.height-_23d.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);var _241=null,_242=null,_243=null;if(_23f.series.shadow){_243=arr.map(_240,function(item){if(item!==null){var _244=t.addMixin(_23f,"circle",item,true),_245=_244.series.shadow;var _246=s.createCircle({cx:item.x+_245.dx,cy:item.y+_245.dy,r:item.radius}).setStroke(_245).setFill(_245.color);if(this.animate){this._animateBubble(_246,dim.height-_23d.b,item.radius);}return _246;}return null;},this);if(_243.length){run.dyn.shadow=_243[_243.length-1].getStroke();}}if(_23f.series.outline){_242=arr.map(_240,function(item){if(item!==null){var _247=t.addMixin(_23f,"circle",item,true),_248=dc.makeStroke(_247.series.outline);_248.width=2*_248.width+_23f.series.stroke.width;var _249=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_248);if(this.animate){this._animateBubble(_249,dim.height-_23d.b,item.radius);}return _249;}return null;},this);if(_242.length){run.dyn.outline=_242[_242.length-1].getStroke();}}_241=arr.map(_240,function(item){if(item!==null){var _24a=t.addMixin(_23f,"circle",item,true),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _24b=this._plotFill(_24a.series.fill,dim,_23d);_24b=this._shapeFill(_24b,rect);var _24c=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_24b).setStroke(_24a.series.stroke);if(this.animate){this._animateBubble(_24c,dim.height-_23d.b,item.radius);}return _24c;}return null;},this);if(_241.length){run.dyn.fill=_241[_241.length-1].getFill();run.dyn.stroke=_241[_241.length-1].getStroke();}if(_23e){var _24d=new Array(_241.length);arr.forEach(_241,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_242&&_242[i]||null,shadow:_243&&_243[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_240[i].x,cy:_240[i].y,cr:_240[i].radius};this._connectEvents(o);_24d[i]=o;}},this);this._eventSeries[run.name]=_24d;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateBubble:function(_24e,_24f,size){fx.animateTransform(lang.delegate({shape:_24e,duration:1200,transform:[{name:"translate",start:[0,_24f],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojo/touch":function(){define(["./_base/kernel","./on","./has","./mouse"],function(dojo,on,has,_250){function _251(type){return function(node,_252){return on(node,type,_252);};};var _253=has("touch");dojo.touch={press:_251(_253?"touchstart":"mousedown"),move:_251(_253?"touchmove":"mousemove"),release:_251(_253?"touchend":"mouseup"),cancel:_253?_251("touchcancel"):_250.leave};return dojo.touch;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_254){var _255=g.gradutils={};function _256(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _254.blendColors(new _254(prev.color),new _254(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_255.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _257=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_258=m.rotate(-_257),_259=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_259,pt),pf1=m.multiplyPoint(_259,fill.x1,fill.y1),pf2=m.multiplyPoint(_259,fill.x2,fill.y2),_25a=m.multiplyPoint(_258,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_258,p.x-pf1.x,p.y-pf1.y).x/_25a;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _256(o,fill.colors);}return new _254(fill||[0,0,0,0]);};_255.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _255;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){lang.getObject("string",true,dojo);dojo.string.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};dojo.string.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=dojo.string.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};dojo.string.substitute=function(_25b,map,_25c,_25d){_25d=_25d||dojo.global;_25c=_25c?lang.hitch(_25d,_25c):function(v){return v;};return _25b.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_25e,key,_25f){var _260=lang.getObject(key,false,map);if(_25f){_260=lang.getObject(_25f,false,_25d).call(_25d,_260,key);}return _25c(_260,key).toString();});};dojo.string.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return dojo.string;});},"dijit/registry":function(){define("dijit/registry",["dojo/_base/array","dojo/_base/sniff","dojo/_base/unload","dojo/_base/window","."],function(_261,has,_262,win,_263){var _264={},hash={};var _265={length:0,add:function(_266){if(hash[_266.id]){throw new Error("Tried to register widget with id=="+_266.id+" but that id is already registered");}hash[_266.id]=_266;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_267){var id;do{id=_267+"_"+(_267 in _264?++_264[_267]:_264[_267]=0);}while(hash[id]);return _263._scopeName=="dijit"?id:_263._scopeName+"_"+id;},findWidgets:function(root){var _268=[];function _269(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _26a=node.getAttribute("widgetId");if(_26a){var _26b=hash[_26a];if(_26b){_268.push(_26b);}}else{_269(node);}}}};_269(root);return _268;},_destroyAll:function(){_263._curFocus=null;_263._prevFocus=null;_263._activeStack=[];_261.forEach(_265.findWidgets(win.body()),function(_26c){if(!_26c._destroyed){if(_26c.destroyRecursive){_26c.destroyRecursive();}else{if(_26c.destroy){_26c.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.getAttribute&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};if(has("ie")){_262.addOnWindowUnload(function(){_265._destroyAll();});}_263.registry=_265;return _265;});},"dojox/charting/plot2d/Lines":function(){define("dojox/charting/plot2d/Lines",["dojo/_base/declare","./Default"],function(_26d,_26e){return _26d("dojox.charting.plot2d.Lines",_26e,{constructor:function(){this.opt.lines=true;}});});},"dijit/_base/manager":function(){define("dijit/_base/manager",["dojo/_base/array","dojo/_base/config","../registry",".."],function(_26f,_270,_271,_272){_26f.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_272[name]=_271[name];});_272.defaultDuration=_270["defaultDuration"]||200;return _272;});},"dojox/charting/plot2d/StackedAreas":function(){define("dojox/charting/plot2d/StackedAreas",["dojo/_base/declare","./Stacked"],function(_273,_274){return _273("dojox.charting.plot2d.StackedAreas",_274,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/plot2d/Stacked":function(){define("dojox/charting/plot2d/Stacked",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Default","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/functional/sequence"],function(lang,_275,arr,_276,dc,df,dfr,dfs){var _277=dfr.lambda("item.purgeGroup()");return _275("dojox.charting.plot2d.Stacked",_276,{getSeriesStats:function(){var _278=dc.collectStackedStats(this.series);this._maxRunLength=_278.hmax;return _278;},render:function(dim,_279){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_279);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_277);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_27a=this.events(),ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _27b=t.next(this.opt.areas?"area":"line",[this.opt,run],true),s=run.group,_27c,_27d=arr.map(acc,function(v,i){return {x:ht(i+1)+_279.l,y:dim.height-_279.b-vt(v)};},this);var _27e=this.opt.tension?dc.curve(_27d,this.opt.tension):"";if(this.opt.areas){var _27f=lang.clone(_27d);if(this.opt.tension){var p=dc.curve(_27f,this.opt.tension);p+=" L"+_27d[_27d.length-1].x+","+(dim.height-_279.b)+" L"+_27d[0].x+","+(dim.height-_279.b)+" L"+_27d[0].x+","+_27d[0].y;run.dyn.fill=s.createPath(p).setFill(_27b.series.fill).getFill();}else{_27f.push({x:_27d[_27d.length-1].x,y:dim.height-_279.b});_27f.push({x:_27d[0].x,y:dim.height-_279.b});_27f.push(_27d[0]);run.dyn.fill=s.createPolyline(_27f).setFill(_27b.series.fill).getFill();}}if(this.opt.lines||this.opt.markers){if(_27b.series.outline){_27c=dc.makeStroke(_27b.series.outline);_27c.width=2*_27c.width+_27b.series.stroke.width;}}if(this.opt.markers){run.dyn.marker=_27b.symbol;}var _280,_281,_282;if(_27b.series.shadow&&_27b.series.stroke){var _283=_27b.series.shadow,_284=arr.map(_27d,function(c){return {x:c.x+_283.dx,y:c.y+_283.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_284,this.opt.tension)).setStroke(_283).getStroke();}else{run.dyn.shadow=s.createPolyline(_284).setStroke(_283).getStroke();}}if(this.opt.markers){_283=_27b.marker.shadow;_282=arr.map(_284,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_27b.symbol).setStroke(_283).setFill(_283.color);},this);}}if(this.opt.lines){if(_27c){if(this.opt.tension){run.dyn.outline=s.createPath(_27e).setStroke(_27c).getStroke();}else{run.dyn.outline=s.createPolyline(_27d).setStroke(_27c).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_27e).setStroke(_27b.series.stroke).getStroke();}else{run.dyn.stroke=s.createPolyline(_27d).setStroke(_27b.series.stroke).getStroke();}}if(this.opt.markers){_280=new Array(_27d.length);_281=new Array(_27d.length);_27c=null;if(_27b.marker.outline){_27c=dc.makeStroke(_27b.marker.outline);_27c.width=2*_27c.width+(_27b.marker.stroke?_27b.marker.stroke.width:0);}arr.forEach(_27d,function(c,i){var path="M"+c.x+" "+c.y+" "+_27b.symbol;if(_27c){_281[i]=s.createPath(path).setStroke(_27c);}_280[i]=s.createPath(path).setStroke(_27b.marker.stroke).setFill(_27b.marker.fill);},this);if(_27a){var _285=new Array(_280.length);arr.forEach(_280,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_281[i]||null,shadow:_282&&_282[i]||null,cx:_27d[i].x,cy:_27d[i].y,x:i+1,y:run.data[i]};this._connectEvents(o);_285[i]=o;},this);this._eventSeries[run.name]=_285;}else{delete this._eventSeries[run.name];}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _286={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_286.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _286.bounceIn(n*2)/2;}return (_286.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_286);return _286;});},"dojox/charting/action2d/Highlight":function(){define("dojox/charting/action2d/Highlight",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(dojo,lang,_287,_288,hub,c,_289,dfe,dgf){var _28a=100,_28b=75,_28c=50,cc=function(_28d){return function(){return _28d;};},hl=function(_28e){var a=new c.Color(_28e),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_28a;if(x.l<_28c){x.l=_28b;}else{if(x.l>_28b){x.l=_28c;}else{x.l=x.l-_28c>_28b-x.l?_28c:_28b;}}}return c.fromHsl(x);};return _287("dojox.charting.action2d.Highlight",_289,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_28f,plot,_290){var a=_290&&_290.highlight;this.colorFun=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _291=o.run.name,_292=o.index,anim,_293,_294;if(_291 in this.anim){anim=this.anim[_291][_292];}else{this.anim[_291]={};}if(anim){anim.action.stop(true);}else{var _295=o.shape.getFill();if(!_295||!(_295 instanceof _288)){return;}this.anim[_291][_292]=anim={start:_295,end:this.colorFun(_295)};}var _296=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_296;_296=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_296,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_291]){delete this.anim[_291][_292];}});}anim.action.play();}});});},"dojox/charting/axis2d/Base":function(){define("dojox/charting/axis2d/Base",["dojo/_base/declare","../Element"],function(_297,_298){return _297("dojox.charting.axis2d.Base",_298,{constructor:function(_299,_29a){this.vertical=_29a&&_29a.vertical;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_29b){this.dirty=false;return this;}});});},"dojox/color/Palette":function(){define("dojox/color/Palette",["dojo/_base/kernel","../main","dojo/_base/lang","dojo/_base/array","./_base"],function(dojo,_29c,lang,arr,dxc){dxc.Palette=function(base){this.colors=[];if(base instanceof dxc.Palette){this.colors=base.colors.slice(0);}else{if(base instanceof dxc.Color){this.colors=[null,null,base,null,null];}else{if(lang.isArray(base)){this.colors=arr.map(base.slice(0),function(item){if(lang.isString(item)){return new dxc.Color(item);}return item;});}else{if(lang.isString(base)){this.colors=[null,null,new dxc.Color(base),null,null];}}}}};function _29d(p,_29e,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var r=(_29e=="dr")?item.r+val:item.r,g=(_29e=="dg")?item.g+val:item.g,b=(_29e=="db")?item.b+val:item.b,a=(_29e=="da")?item.a+val:item.a;ret.colors.push(new dxc.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;};function tCMY(p,_29f,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmy(),c=(_29f=="dc")?o.c+val:o.c,m=(_29f=="dm")?o.m+val:o.m,y=(_29f=="dy")?o.y+val:o.y;ret.colors.push(dxc.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function _2a0(p,_2a1,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmyk(),c=(_2a1=="dc")?o.c+val:o.c,m=(_2a1=="dm")?o.m+val:o.m,y=(_2a1=="dy")?o.y+val:o.y,k=(_2a1=="dk")?o.b+val:o.b;ret.colors.push(dxc.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function tHSL(p,_2a2,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsl(),h=(_2a2=="dh")?o.h+val:o.h,s=(_2a2=="ds")?o.s+val:o.s,l=(_2a2=="dl")?o.l+val:o.l;ret.colors.push(dxc.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function tHSV(p,_2a3,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsv(),h=(_2a3=="dh")?o.h+val:o.h,s=(_2a3=="ds")?o.s+val:o.s,v=(_2a3=="dv")?o.v+val:o.v;ret.colors.push(dxc.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _2a4(val,low,high){return high-((high-val)*((high-low)/high));};lang.extend(dxc.Palette,{transform:function(_2a5){var fn=_29d;if(_2a5.use){var use=_2a5.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=tHSL;}else{fn=tHSV;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=_2a0;}else{fn=tCMY;}}}}else{if("dc" in _2a5||"dm" in _2a5||"dy" in _2a5){if("dk" in _2a5){fn=_2a0;}else{fn=tCMY;}}else{if("dh" in _2a5||"ds" in _2a5){if("dv" in _2a5){fn=tHSV;}else{fn=tHSL;}}}}var _2a6=this;for(var p in _2a5){if(p=="use"){continue;}_2a6=fn(_2a6,p,_2a5[p]);}return _2a6;},clone:function(){return new dxc.Palette(this);}});lang.mixin(dxc.Palette,{generators:{analogous:function(args){var high=args.high||60,low=args.low||18,base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(high/2)+360)%360,(hsv.h-high+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(arr.map(h,function(hue,i){return dxc.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_2a4(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v3),base,dxc.fromHsv(hsv.h,s1,v3),dxc.fromHsv(hsv.h,s2,v2)]);},triadic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,hsv.v),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h2,s2,v1),dxc.fromHsv(h2,s3,v3)]);},complementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_2a4(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h1,s3,v2),dxc.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,_2a7=args.da||30,hsv=base.toHsv();var _2a8=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(_2a8-_2a7+360)%360,h2=(_2a8+_2a7)%360,s1=Math.max(hsv.s-10,0),s2=_2a4(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v2),dxc.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v3),dxc.fromHsv(h3,s2,v2)]);},shades:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dxc.fromHsv(hsv.h,s,v1),new dxc.fromHsv(hsv.h,s,v2),base,new dxc.fromHsv(hsv.h,s,v3),new dxc.fromHsv(hsv.h,s,v4)]);}},generate:function(base,type){if(lang.isFunction(type)){return type({base:base});}else{if(dxc.Palette.generators[type]){return dxc.Palette.generators[type]({base:base});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+type+"') does not exist.");}});return dxc.Palette;});},"dijit/a11y":function(){define("dijit/a11y",["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/sniff","./_base/manager","."],function(_2a9,_2aa,_2ab,dom,_2ac,_2ad,has,_2ae,_2af){var _2b0=(_2af._isElementShown=function(elem){var s=_2ad.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_2ac.get(elem,"type")!="hidden");});_2af.hasDefaultTabStop=function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _2ac.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _2b1=elem.contentDocument;if("designMode" in _2b1&&_2b1.designMode=="on"){return true;}body=_2b1.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}};var _2b2=(_2af.isTabNavigable=function(elem){if(_2ac.get(elem,"disabled")){return false;}else{if(_2ac.has(elem,"tabIndex")){return _2ac.get(elem,"tabIndex")>=0;}else{return _2af.hasDefaultTabStop(elem);}}});_2af._getTabNavigable=function(root){var _2b3,last,_2b4,_2b5,_2b6,_2b7,_2b8={};function _2b9(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _2ba=function(_2bb){for(var _2bc=_2bb.firstChild;_2bc;_2bc=_2bc.nextSibling){if(_2bc.nodeType!=1||(has("ie")&&_2bc.scopeName!=="HTML")||!_2b0(_2bc)){continue;}if(_2b2(_2bc)){var _2bd=_2ac.get(_2bc,"tabIndex");if(!_2ac.has(_2bc,"tabIndex")||_2bd==0){if(!_2b3){_2b3=_2bc;}last=_2bc;}else{if(_2bd>0){if(!_2b4||_2bd<_2b5){_2b5=_2bd;_2b4=_2bc;}if(!_2b6||_2bd>=_2b7){_2b7=_2bd;_2b6=_2bc;}}}var rn=_2b9(_2bc);if(_2ac.get(_2bc,"checked")&&rn){_2b8[rn]=_2bc;}}if(_2bc.nodeName.toUpperCase()!="SELECT"){_2ba(_2bc);}}};if(_2b0(root)){_2ba(root);}function rs(node){return _2b8[_2b9(node)]||node;};return {first:rs(_2b3),last:rs(last),lowest:rs(_2b4),highest:rs(_2b6)};};_2af.getFirstInTabbingOrder=function(root){var _2be=_2af._getTabNavigable(dom.byId(root));return _2be.lowest?_2be.lowest:_2be.first;};_2af.getLastInTabbingOrder=function(root){var _2bf=_2af._getTabNavigable(dom.byId(root));return _2bf.last?_2bf.last:_2bf.highest;};return {hasDefaultTabStop:_2af.hasDefaultTabStop,isTabNavigable:_2af.isTabNavigable,_getTabNavigable:_2af._getTabNavigable,getFirstInTabbingOrder:_2af.getFirstInTabbingOrder,getLastInTabbingOrder:_2af.getLastInTabbingOrder};});},"dojox/charting/plot2d/Grid":function(){define("dojox/charting/plot2d/Grid",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","../Element","./common","dojox/lang/utils","dojox/gfx/fx"],function(lang,_2c0,hub,arr,_2c1,dc,du,fx){return _2c0("dojox.charting.plot2d.Grid",_2c1,{defaultParams:{hAxis:"x",vAxis:"y",hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:"none",vStripes:"none",animate:null,enableCache:false},optionalParams:{},constructor:function(_2c2,_2c3){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2c3);this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.dirty=true;this.animate=this.opt.animate;this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};if(this.opt.enableCache){this._lineFreePool=[];this._lineUsePool=[];}},clear:function(){this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},initializeScalers:function(){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},performZoom:function(dim,_2c4){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_2c5=dim.height-_2c4.b,_2c6=this._hAxis.getScaler().bounds,_2c7=(_2c6.from-_2c6.lower)*_2c6.scale,_2c8=this._vAxis.getScaler().bounds,_2c9=(_2c8.from-_2c8.lower)*_2c8.scale,_2ca=vs/this.lastWindow.vscale,_2cb=hs/this.lastWindow.hscale,_2cc=(this.lastWindow.xoffset-_2c7)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_2cd=(_2c9-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_2ce=this.group,anim=fx.animateTransform(lang.delegate({shape:_2ce,duration:1200,transform:[{name:"translate",start:[0,0],end:[_2c4.l*(1-_2cb),_2c5*(1-_2ca)]},{name:"scale",start:[1,1],end:[_2cb,_2ca]},{name:"original"},{name:"translate",start:[0,0],end:[_2cc,_2cd]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_2c7,yoffset:_2c9});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},getRequiredColors:function(){return 0;},cleanGroup:function(){this.inherited(arguments);if(this.opt.enableCache){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];}},createLine:function(_2cf,_2d0){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_2d0);_2cf.add(line);}else{line=_2cf.createLine(_2d0);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_2d1){if(this.zoom){return this.performZoom(dim,_2d1);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.group,ta=this.chart.theme.axis;try{var _2d2=this._vAxis.getScaler(),vt=_2d2.scaler.getTransformerFromModel(_2d2),_2d3=this._vAxis.getTicks();if(_2d3!=null){if(this.opt.hMinorLines){arr.forEach(_2d3.minor,function(tick){var y=dim.height-_2d1.b-vt(tick.value);var _2d4=this.createLine(s,{x1:_2d1.l,y1:y,x2:dim.width-_2d1.r,y2:y}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(_2d4,"h",_2d1.l,_2d1.r+_2d1.l-dim.width);}},this);}if(this.opt.hMajorLines){arr.forEach(_2d3.major,function(tick){var y=dim.height-_2d1.b-vt(tick.value);var _2d5=this.createLine(s,{x1:_2d1.l,y1:y,x2:dim.width-_2d1.r,y2:y}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(_2d5,"h",_2d1.l,_2d1.r+_2d1.l-dim.width);}},this);}}}catch(e){}try{var _2d6=this._hAxis.getScaler(),ht=_2d6.scaler.getTransformerFromModel(_2d6),_2d3=this._hAxis.getTicks();if(this!=null){if(_2d3&&this.opt.vMinorLines){arr.forEach(_2d3.minor,function(tick){var x=_2d1.l+ht(tick.value);var _2d7=this.createLine(s,{x1:x,y1:_2d1.t,x2:x,y2:dim.height-_2d1.b}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(_2d7,"v",dim.height-_2d1.b,dim.height-_2d1.b-_2d1.t);}},this);}if(_2d3&&this.opt.vMajorLines){arr.forEach(_2d3.major,function(tick){var x=_2d1.l+ht(tick.value);var _2d8=this.createLine(s,{x1:x,y1:_2d1.t,x2:x,y2:dim.height-_2d1.b}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(_2d8,"v",dim.height-_2d1.b,dim.height-_2d1.b-_2d1.t);}},this);}}}catch(e){}this.dirty=false;return this;},_animateGrid:function(_2d9,type,_2da,size){var _2db=type=="h"?[_2da,0]:[0,_2da];var _2dc=type=="h"?[1/size,1]:[1,1/size];fx.animateTransform(lang.delegate({shape:_2d9,duration:1200,transform:[{name:"translate",start:_2db,end:[0,0]},{name:"scale",start:_2dc,end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/fold":function(){define("dojox/lang/functional/fold",["dojo/_base/lang","dojo/_base/array","dojo/_base/window","./lambda"],function(lang,arr,win,df){var _2dd={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _2dd)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _2de=true;for(i in a){if(!(i in _2dd)){if(_2de){z=a[i];_2de=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||win.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n","dojox/charting/plot2d/Spider":function(){define("dojox/charting/plot2d/Spider",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/html","dojo/_base/array","dojo/dom-geometry","dojo/_base/fx","dojo/fx","dojo/_base/sniff","../Element","./_PlotEvents","dojo/_base/Color","dojox/color/_base","./common","../axis2d/common","../scaler/primitive","dojox/gfx","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/utils","dojo/fx/easing"],function(lang,_2df,hub,html,arr,_2e0,_2e1,_2e2,has,_2e3,_2e4,_2e5,_2e6,dc,da,_2e7,g,m,_2e8,df,du,_2e9){var _2ea=0.2;var _2eb=_2df("dojox.charting.plot2d.Spider",[_2e3,_2e4],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:-10,labelStyle:"default",htmlLabels:true,startAngle:-90,divisions:3,axisColor:"",axisWidth:0,spiderColor:"",spiderWidth:0,seriesWidth:0,seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,spiderType:"polygon",animationType:_2e9.backOut,axisTickFont:"",axisTickFontColor:"",axisFont:"",axisFontColor:""},optionalParams:{radius:0,font:"",fontColor:""},constructor:function(_2ec,_2ed){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2ed);du.updateWithPattern(this.opt,_2ed,this.optionalParams);this.series=[];this.dyn=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};},clear:function(){this.dirty=true;this.dyn=[];this.series=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};return this;},setAxis:function(axis){return this;},addSeries:function(run){var _2ee=false;this.series.push(run);for(var key in run.data){var val=run.data[key],data=this.datas[key];if(data){data.vlist.push(val);data.min=Math.min(data.min,val);data.max=Math.max(data.max,val);}else{this.datas[key]={min:val,max:val,vlist:[val]};}}if(this.labelKey.length<=0){for(var key in run.data){this.labelKey.push(key);}}return this;},getSeriesStats:function(){return dc.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},getRequiredColors:function(){return this.series.length;},initializeScalers:function(dim,_2ef){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_2ef.hmin,_2ef.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_2e7.buildScaler(_2ef.hmin,_2ef.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_2ef.vmin,_2ef.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_2e7.buildScaler(_2ef.vmin,_2ef.vmax,dim.height);}return this;},render:function(dim,_2f0){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,t=this.chart.theme;this.resetEvents();if(!this.series||!this.series.length){return this;}var o=this.opt,ta=t.axis,rx=(dim.width-_2f0.l-_2f0.r)/2,ry=(dim.height-_2f0.t-_2f0.b)/2,r=Math.min(rx,ry),_2f1=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font)||"normal normal normal 7pt Tahoma",_2f2=o.axisFont||(ta.tick&&ta.tick.titleFont)||"normal normal normal 11pt Tahoma",_2f3=o.axisTickFontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"silver",_2f4=o.axisFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_2f5=o.axisColor||(ta.tick&&ta.tick.axisColor)||"silver",_2f6=o.spiderColor||(ta.tick&&ta.tick.spiderColor)||"silver",_2f7=o.axisWidth||(ta.stroke&&ta.stroke.width)||2,_2f8=o.spiderWidth||(ta.stroke&&ta.stroke.width)||2,_2f9=o.seriesWidth||(ta.stroke&&ta.stroke.width)||2,_2fa=g.normalizedLength(g.splitFontString(_2f2).size),_2fb=m._degToRad(o.startAngle),_2fc=_2fb,step,_2fd,_2fe,_2ff,_300,_301,_302,_303,_304,_305,_306,ro=o.spiderOrigin,dv=o.divisions>=3?o.divisions:3,ms=o.markerSize,spt=o.spiderType,at=o.animationType,_307=o.labelOffset<-10?o.labelOffset:-10,_308=0.2;if(o.labels){_2ff=arr.map(this.series,function(s){return s.name;},this);_300=df.foldl1(df.map(_2ff,function(_309,i){var font=t.series.font;return g._base._getTextBox(_309,{font:font}).w;},this),"Math.max(a, b)")/2;r=Math.min(rx-2*_300,ry-_2fa)+_307;_301=r-_307;}if("radius" in o){r=o.radius;_301=r-_307;}r/=(1+_308);var _30a={cx:_2f0.l+rx,cy:_2f0.t+ry,r:r};for(var i=this.series.length-1;i>=0;i--){var _30b=this.series[i];if(!this.dirty&&!_30b.dirty){t.skip();continue;}_30b.cleanGroup();var run=_30b.data;if(run!==null){var len=this._getObjectLength(run);if(!_302||_302.length<=0){_302=[],_303=[],_306=[];this._buildPoints(_302,len,_30a,r,_2fc,true);this._buildPoints(_303,len,_30a,r*ro,_2fc,true);this._buildPoints(_306,len,_30a,_301,_2fc);if(dv>2){_304=[],_305=[];for(var j=0;j<dv-2;j++){_304[j]=[];this._buildPoints(_304[j],len,_30a,r*(ro+(1-ro)*(j+1)/(dv-1)),_2fc,true);_305[j]=r*(ro+(1-ro)*(j+1)/(dv-1));}}}}}var _30c=s.createGroup(),_30d={color:_2f5,width:_2f7},_30e={color:_2f6,width:_2f8};for(var j=_302.length-1;j>=0;--j){var _30f=_302[j],st={x:_30f.x+(_30f.x-_30a.cx)*_308,y:_30f.y+(_30f.y-_30a.cy)*_308},nd={x:_30f.x+(_30f.x-_30a.cx)*_308/2,y:_30f.y+(_30f.y-_30a.cy)*_308/2};_30c.createLine({x1:_30a.cx,y1:_30a.cy,x2:st.x,y2:st.y}).setStroke(_30d);this._drawArrow(_30c,st,nd,_30d);}var _310=s.createGroup();for(var j=_306.length-1;j>=0;--j){var _30f=_306[j],_311=g._base._getTextBox(this.labelKey[j],{font:_2f2}).w||0,_312=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx",elem=da.createText[_312](this.chart,_310,(!_2e0.isBodyLtr()&&_312=="html")?(_30f.x+_311-dim.width):_30f.x,_30f.y,"middle",this.labelKey[j],_2f2,_2f4);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}var _313=s.createGroup();if(spt=="polygon"){_313.createPolyline(_302).setStroke(_30e);_313.createPolyline(_303).setStroke(_30e);if(_304.length>0){for(var j=_304.length-1;j>=0;--j){_313.createPolyline(_304[j]).setStroke(_30e);}}}else{var _314=this._getObjectLength(this.datas);_313.createCircle({cx:_30a.cx,cy:_30a.cy,r:r}).setStroke(_30e);_313.createCircle({cx:_30a.cx,cy:_30a.cy,r:r*ro}).setStroke(_30e);if(_305.length>0){for(var j=_305.length-1;j>=0;--j){_313.createCircle({cx:_30a.cx,cy:_30a.cy,r:_305[j]}).setStroke(_30e);}}}var _315=s.createGroup(),len=this._getObjectLength(this.datas),k=0;for(var key in this.datas){var data=this.datas[key],min=data.min,max=data.max,_316=max-min,end=_2fc+2*Math.PI*k/len;for(var i=0;i<dv;i++){var text=min+_316*i/(dv-1),_30f=this._getCoordinate(_30a,r*(ro+(1-ro)*i/(dv-1)),end);text=this._getLabel(text);var _311=g._base._getTextBox(text,{font:_2f1}).w||0,_312=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";if(this.opt.htmlLabels){this.htmlElements.push(da.createText[_312](this.chart,_315,(!_2e0.isBodyLtr()&&_312=="html")?(_30f.x+_311-dim.width):_30f.x,_30f.y,"start",text,_2f1,_2f3));}}k++;}this.chart.seriesShapes={};var _317=[];for(var i=this.series.length-1;i>=0;i--){var _30b=this.series[i],run=_30b.data;if(run!==null){var _318=[],k=0,_319=[];for(var key in run){var data=this.datas[key],min=data.min,max=data.max,_316=max-min,_31a=run[key],end=_2fc+2*Math.PI*k/len,_30f=this._getCoordinate(_30a,r*(ro+(1-ro)*(_31a-min)/_316),end);_318.push(_30f);_319.push({sname:_30b.name,key:key,data:_31a});k++;}_318[_318.length]=_318[0];_319[_319.length]=_319[0];var _31b=this._getBoundary(_318),_31c=t.next("spider",[o,_30b]),ts=_30b.group,f=g.normalizeColor(_31c.series.fill),sk={color:_31c.series.fill,width:_2f9};f.a=o.seriesFillAlpha;_30b.dyn={fill:f,stroke:sk};var osps=this.oldSeriePoints[_30b.name];var cs=this._createSeriesEntry(ts,(osps||_303),_318,f,sk,r,ro,ms,at);this.chart.seriesShapes[_30b.name]=cs;this.oldSeriePoints[_30b.name]=_318;var po={element:"spider_poly",index:i,id:"spider_poly_"+_30b.name,run:_30b,plot:this,shape:cs.poly,parent:ts,brect:_31b,cx:_30a.cx,cy:_30a.cy,cr:r,f:f,s:s};this._connectEvents(po);var so={element:"spider_plot",index:i,id:"spider_plot_"+_30b.name,run:_30b,plot:this,shape:_30b.group};this._connectEvents(so);arr.forEach(cs.circles,function(c,i){var _31d=c.getShape(),co={element:"spider_circle",index:i,id:"spider_circle_"+_30b.name+i,run:_30b,plot:this,shape:c,parent:ts,tdata:_319[i],cx:_318[i].x,cy:_318[i].y,f:f,s:s};this._connectEvents(co);},this);}}return this;},_createSeriesEntry:function(ts,osps,sps,f,sk,r,ro,ms,at){var _31e=ts.createPolyline(osps).setFill(f).setStroke(sk),_31f=[];for(var j=0;j<osps.length;j++){var _320=osps[j],cr=ms;var _321=ts.createCircle({cx:_320.x,cy:_320.y,r:cr}).setFill(f).setStroke(sk);_31f.push(_321);}var _322=arr.map(sps,function(np,j){var sp=osps[j],anim=new _2e1.Animation({duration:1000,easing:at,curve:[sp.y,np.y]});var spl=_31e,sc=_31f[j];hub.connect(anim,"onAnimate",function(y){var _323=spl.getShape();_323.points[j].y=y;spl.setShape(_323);var _324=sc.getShape();_324.cy=y;sc.setShape(_324);});return anim;});var _325=arr.map(sps,function(np,j){var sp=osps[j],anim=new _2e1.Animation({duration:1000,easing:at,curve:[sp.x,np.x]});var spl=_31e,sc=_31f[j];hub.connect(anim,"onAnimate",function(x){var _326=spl.getShape();_326.points[j].x=x;spl.setShape(_326);var _327=sc.getShape();_327.cx=x;sc.setShape(_327);});return anim;});var _328=_2e2.combine(_322.concat(_325));_328.play();return {group:ts,poly:_31e,circles:_31f};},plotEvent:function(o){var _329=o.id?o.id:"default",a;if(_329 in this.animations){a=this.animations[_329];a.anim&&a.anim.stop(true);}else{a=this.animations[_329]={};}if(o.element=="spider_poly"){if(!a.color){var _32a=o.shape.getFill();if(!_32a||!(_32a instanceof _2e5)){return;}a.color={start:_32a,end:_32b(_32a)};}var _32c=a.color.start,end=a.color.end;if(o.type=="onmouseout"){var t=_32c;_32c=end;end=t;}a.anim=_2e8.animateFill({shape:o.shape,duration:800,easing:_2e9.backOut,color:{start:_32c,end:end}});a.anim.play();}else{if(o.element=="spider_circle"){var init,_32d,_32e=1.5;if(o.type=="onmouseover"){init=m.identity;_32d=_32e;var _32f={type:"rect"};_32f.x=o.cx;_32f.y=o.cy;_32f.width=_32f.height=1;var lt=html.coords(this.chart.node,true);_32f.x+=lt.x;_32f.y+=lt.y;_32f.x=Math.round(_32f.x);_32f.y=Math.round(_32f.y);_32f.width=Math.ceil(_32f.width);_32f.height=Math.ceil(_32f.height);this.aroundRect=_32f;var _330=["after","before"];dc.doIfLoaded("dijit/Tooltip",dojo.hitch(this,function(_331){_331.show(o.tdata.sname+"<br/>"+o.tdata.key+"<br/>"+o.tdata.data,this.aroundRect,_330);}));}else{init=m.scaleAt(_32e,o.cx,o.cy);_32d=1/_32e;dc.doIfLoaded("dijit/Tooltip",dojo.hitch(this,function(_332){this.aroundRect&&_332.hide(this.aroundRect);}));}var cs=o.shape.getShape(),init=m.scaleAt(_32e,cs.cx,cs.cy),_333={shape:o.shape,duration:200,easing:_2e9.backOut,transform:[{name:"scaleAt",start:[1,cs.cx,cs.cy],end:[_32d,cs.cx,cs.cy]},init]};a.anim=_2e8.animateTransform(_333);a.anim.play();}else{if(o.element=="spider_plot"){if(o.type=="onmouseover"&&!has("ie")){o.shape.moveToFront();}}}}},_getBoundary:function(_334){var xmax=_334[0].x,xmin=_334[0].x,ymax=_334[0].y,ymin=_334[0].y;for(var i=0;i<_334.length;i++){var _335=_334[i];xmax=Math.max(_335.x,xmax);ymax=Math.max(_335.y,ymax);xmin=Math.min(_335.x,xmin);ymin=Math.min(_335.y,ymin);}return {x:xmin,y:ymin,width:xmax-xmin,height:ymax-ymin};},_drawArrow:function(s,_336,end,_337){var len=Math.sqrt(Math.pow(end.x-_336.x,2)+Math.pow(end.y-_336.y,2)),sin=(end.y-_336.y)/len,cos=(end.x-_336.x)/len,_338={x:end.x+(len/3)*(-sin),y:end.y+(len/3)*cos},_339={x:end.x+(len/3)*sin,y:end.y+(len/3)*(-cos)};s.createPolyline([_336,_338,_339]).setFill(_337.color).setStroke(_337);},_buildPoints:function(_33a,_33b,_33c,_33d,_33e,_33f){for(var i=0;i<_33b;i++){var end=_33e+2*Math.PI*i/_33b;_33a.push(this._getCoordinate(_33c,_33d,end));}if(_33f){_33a.push(this._getCoordinate(_33c,_33d,_33e+2*Math.PI));}},_getCoordinate:function(_340,_341,_342){return {x:_340.cx+_341*Math.cos(_342),y:_340.cy+_341*Math.sin(_342)};},_getObjectLength:function(obj){var _343=0;if(lang.isObject(obj)){for(var key in obj){_343++;}}return _343;},_getLabel:function(_344){return dc.getLabel(_344,this.opt.fixed,this.opt.precision);}});function _32b(_345){var a=new _2e6.Color(_345),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=100;if(x.l<50){x.l=75;}else{if(x.l>75){x.l=50;}else{x.l=x.l-50>75-x.l?50:75;}}}var _345=_2e6.fromHsl(x);_345.a=0.7;return _345;};return _2eb;});},"dojox/charting/plot2d/StackedBars":function(){define("dojox/charting/plot2d/StackedBars",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Bars","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/functional/sequence"],function(lang,arr,_346,Bars,dc,df,dfr,dfs){var _347=dfr.lambda("item.purgeGroup()");return _346("dojox.charting.plot2d.StackedBars",Bars,{getSeriesStats:function(){var _348=dc.collectStackedStats(this.series),t;this._maxRunLength=_348.hmax;_348.hmin-=0.5;_348.hmax+=0.5;t=_348.hmin,_348.hmin=_348.vmin,_348.vmin=t;t=_348.hmax,_348.hmax=_348.vmax,_348.vmax=t;return _348;},render:function(dim,_349){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var _34a=run.data[j];if(_34a!==null){var v=typeof _34a=="number"?_34a:_34a.y;if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_349);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_347);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_34b,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_34c=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_34b=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _34d=t.next("bar",[this.opt,run]),s=run.group,_34e=new Array(acc.length);for(var j=0;j<acc.length;++j){var _34a=run.data[j];if(_34a!==null){var v=acc[j],_34f=ht(v),_350=typeof _34a!="number"?t.addMixin(_34d,"bar",_34a,true):t.post(_34d,"bar");if(_34f>=0&&_34b>=1){var rect={x:_349.l,y:dim.height-_349.b-vt(j+1.5)+gap,width:_34f,height:_34b};var _351=this._plotFill(_350.series.fill,dim,_349);_351=this._shapeFill(_351,rect);var _352=s.createRect(rect).setFill(_351).setStroke(_350.series.stroke);run.dyn.fill=_352.getFill();run.dyn.stroke=_352.getStroke();if(_34c){var o={element:"bar",index:j,run:run,shape:_352,x:v,y:j+1.5};this._connectEvents(o);_34e[j]=o;}if(this.animate){this._animateBar(_352,_349.l,-_34f);}}}}this._eventSeries[run.name]=_34e;run.dirty=false;for(var j=0;j<run.data.length;++j){var _34a=run.data[j];if(_34a!==null){var v=typeof _34a=="number"?_34a:_34a.y;if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});});},"dojox/charting/themes/GreySkies":function(){define("dojox/charting/themes/GreySkies",["../Theme","./common"],function(_353,_354){_354.GreySkies=new _353(_353._def);return _354.GreySkies;});},"dojox/charting/plot2d/Columns":function(){define("dojox/charting/plot2d/Columns",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_355,Base,dc,df,dfr,du,fx){var _356=dfr.lambda("item.purgeGroup()");return _355("dojox.charting.plot2d.Columns",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_357,_358){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_358);du.updateWithPattern(this.opt,_358,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var _359=dc.collectSimpleStats(this.series);_359.hmin-=0.5;_359.hmax+=0.5;return _359;},createRect:function(run,_35a,_35b){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_35b);_35a.add(rect);}else{rect=_35a.createRect(_35b);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_35c){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_35c);}var t=this.getSeriesStats();this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_356);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_35d,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_35e=Math.max(0,this._vScaler.bounds.lower),_35f=vt(_35e),min=Math.max(0,Math.floor(this._hScaler.bounds.from-1)),max=Math.ceil(this._hScaler.bounds.to),_360=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_35d=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _361=t.next("column",[this.opt,run]),s=run.group,_362=new Array(run.data.length);var l=Math.min(run.data.length,max);for(var j=min;j<l;++j){var _363=run.data[j];if(_363!==null){var v=typeof _363=="number"?_363:_363.y,vv=vt(v),_364=vv-_35f,h=Math.abs(_364),_365=typeof _363!="number"?t.addMixin(_361,"column",_363,true):t.post(_361,"column");if(_35d>=1&&h>=0){var rect={x:_35c.l+ht(j+0.5)+gap,y:dim.height-_35c.b-(v>_35e?vv:_35f),width:_35d,height:h};var _366=this._plotFill(_365.series.fill,dim,_35c);_366=this._shapeFill(_366,rect);var _367=this.createRect(run,s,rect).setFill(_366).setStroke(_365.series.stroke);run.dyn.fill=_367.getFill();run.dyn.stroke=_367.getStroke();if(_360){var o={element:"column",index:j,run:run,shape:_367,x:j+0.5,y:v};this._connectEvents(o);_362[j]=o;}if(this.animate){this._animateColumn(_367,dim.height-_35c.b-_35f,h);}}}}this._eventSeries[run.name]=_362;run.dirty=false;}this.dirty=false;return this;},_animateColumn:function(_368,_369,_36a){fx.animateTransform(lang.delegate({shape:_368,duration:1200,transform:[{name:"translate",start:[0,_369-(_369/_36a)],end:[0,0]},{name:"scale",start:[1,1/_36a],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/place":function(){define("dijit/place",["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","dojo/window","."],function(_36b,_36c,_36d,_36e,win,_36f,_370){function _371(node,_372,_373,_374){var view=_36f.getBox();if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body().appendChild(node);}var best=null;_36b.some(_372,function(_375){var _376=_375.corner;var pos=_375.pos;var _377=0;var _378={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_376.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_376.charAt(0)]};if(_373){var res=_373(node,_375.aroundCorner,_376,_378,_374);_377=typeof res=="undefined"?0:res;}var _379=node.style;var _37a=_379.display;var _37b=_379.visibility;if(_379.display=="none"){_379.visibility="hidden";_379.display="";}var mb=_36c.getMarginBox(node);_379.display=_37a;_379.visibility=_37b;var _37c={"L":pos.x,"R":pos.x-mb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(mb.w>>1))-mb.w)}[_376.charAt(1)],_37d={"T":pos.y,"B":pos.y-mb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(mb.h>>1))-mb.h)}[_376.charAt(0)],_37e=Math.max(view.l,_37c),_37f=Math.max(view.t,_37d),endX=Math.min(view.l+view.w,_37c+mb.w),endY=Math.min(view.t+view.h,_37d+mb.h),_380=endX-_37e,_381=endY-_37f;_377+=(mb.w-_380)+(mb.h-_381);if(best==null||_377<best.overflow){best={corner:_376,aroundCorner:_375.aroundCorner,x:_37e,y:_37f,w:_380,h:_381,overflow:_377,spaceAvailable:_378};}return !_377;});if(best.overflow&&_373){_373(node,best.aroundCorner,best.corner,best.spaceAvailable,_374);}var l=_36c.isBodyLtr(),s=node.style;s.top=best.y+"px";s[l?"left":"right"]=(l?best.x:view.w-best.x-best.w)+"px";s[l?"right":"left"]="auto";return best;};return (_370.place={at:function(node,pos,_382,_383){var _384=_36b.map(_382,function(_385){var c={corner:_385,pos:{x:pos.x,y:pos.y}};if(_383){c.pos.x+=_385.charAt(1)=="L"?_383.x:-_383.x;c.pos.y+=_385.charAt(0)=="T"?_383.y:-_383.y;}return c;});return _371(node,_384);},around:function(node,_386,_387,_388,_389){var _38a=(typeof _386=="string"||"offsetWidth" in _386)?_36c.position(_386,true):_386;if(_386.parentNode){var _38b=_386.parentNode;while(_38b&&_38b.nodeType==1&&_38b.nodeName!="BODY"){var _38c=_36c.position(_38b,true);var _38d=_36d.getComputedStyle(_38b).overflow;if(_38d=="hidden"||_38d=="auto"||_38d=="scroll"){var _38e=Math.min(_38a.y+_38a.h,_38c.y+_38c.h);var _38f=Math.min(_38a.x+_38a.w,_38c.x+_38c.w);_38a.x=Math.max(_38a.x,_38c.x);_38a.y=Math.max(_38a.y,_38c.y);_38a.h=_38e-_38a.y;_38a.w=_38f-_38a.x;}_38b=_38b.parentNode;}}var x=_38a.x,y=_38a.y,_390="w" in _38a?_38a.w:(_38a.w=_38a.width),_391="h" in _38a?_38a.h:(_36e.deprecated("place.around: dijit.place.__Rectangle: { x:"+x+", y:"+y+", height:"+_38a.height+", width:"+_390+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_38a.height+", w:"+_390+" }","","2.0"),_38a.h=_38a.height);var _392=[];function push(_393,_394){_392.push({aroundCorner:_393,corner:_394,pos:{x:{"L":x,"R":x+_390,"M":x+(_390>>1)}[_393.charAt(1)],y:{"T":y,"B":y+_391,"M":y+(_391>>1)}[_393.charAt(0)]}});};_36b.forEach(_387,function(pos){var ltr=_388;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after":ltr=!ltr;case "before":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _395=_371(node,_392,_389,{w:_390,h:_391});_395.aroundNodePos=_38a;return _395;}});});},"dojox/lang/functional/array":function(){define("dojox/lang/functional/array",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/window","./lambda"],function(dojo,lang,arr,win,df){var _396={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _396)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _396)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _396)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _396)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _396)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/charting/Theme":function(){define("dojox/charting/Theme",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/color/_base","dojox/color/Palette","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_397,_398,_399,_39a,dlu,dgg){var _39b=_397("dojox.charting.Theme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_39c){_39c=_39c||{};var def=_39b.defaultTheme;arr.forEach(["chart","plotarea","axis","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_39c[name]);},this);if(_39c.seriesThemes&&_39c.seriesThemes.length){this.colors=null;this.seriesThemes=_39c.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_39c.colors||_39b.defaultColors).slice(0);}this.markerThemes=null;if(_39c.markerThemes&&_39c.markerThemes.length){this.markerThemes=_39c.markerThemes.slice(0);}this.markers=_39c.markers?lang.clone(_39c.markers):lang.delegate(_39b.defaultMarkers);this.noGradConv=_39c.noGradConv;this.noRadialConv=_39c.noRadialConv;if(_39c.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _39d=new _39b({chart:this.chart,plotarea:this.plotarea,axis:this.axis,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_39d[name]=this[name];}},this);return _39d;},clear:function(){this._current=0;},next:function(_39e,_39f,_3a0){var _3a1=dlu.merge,_3a2,_3a3;if(this.colors){_3a2=lang.delegate(this.series);_3a3=lang.delegate(this.marker);var _3a4=new _398(this.colors[this._current%this.colors.length]),old;if(_3a2.stroke&&_3a2.stroke.color){_3a2.stroke=lang.delegate(_3a2.stroke);old=new _398(_3a2.stroke.color);_3a2.stroke.color=new _398(_3a4);_3a2.stroke.color.a=old.a;}else{_3a2.stroke={color:_3a4};}if(_3a3.stroke&&_3a3.stroke.color){_3a3.stroke=lang.delegate(_3a3.stroke);old=new _398(_3a3.stroke.color);_3a3.stroke.color=new _398(_3a4);_3a3.stroke.color.a=old.a;}else{_3a3.stroke={color:_3a4};}if(!_3a2.fill||_3a2.fill.type){_3a2.fill=_3a4;}else{old=new _398(_3a2.fill);_3a2.fill=new _398(_3a4);_3a2.fill.a=old.a;}if(!_3a3.fill||_3a3.fill.type){_3a3.fill=_3a4;}else{old=new _398(_3a3.fill);_3a3.fill=new _398(_3a4);_3a3.fill.a=old.a;}}else{_3a2=this.seriesThemes?_3a1(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_3a3=this.markerThemes?_3a1(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_3a2;}var _3a5=_3a3&&_3a3.symbol||this._markers[this._current%this._markers.length];var _3a6={series:_3a2,marker:_3a3,symbol:_3a5};++this._current;if(_39f){_3a6=this.addMixin(_3a6,_39e,_39f);}if(_3a0){_3a6=this.post(_3a6,_39e);}return _3a6;},skip:function(){++this._current;},addMixin:function(_3a7,_3a8,_3a9,_3aa){if(lang.isArray(_3a9)){arr.forEach(_3a9,function(m){_3a7=this.addMixin(_3a7,_3a8,m);},this);}else{var t={};if("color" in _3a9){if(_3a8=="line"||_3a8=="area"){lang.setObject("series.stroke.color",_3a9.color,t);lang.setObject("marker.stroke.color",_3a9.color,t);}else{lang.setObject("series.fill",_3a9.color,t);}}arr.forEach(["stroke","outline","shadow","fill","font","fontColor","labelWiring"],function(name){var _3ab="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_3ab in _3a9;if(name in _3a9){lang.setObject("series."+name,_3a9[name],t);if(!b){lang.setObject("marker."+name,_3a9[name],t);}}if(b){lang.setObject("marker."+name,_3a9[_3ab],t);}});if("marker" in _3a9){t.symbol=_3a9.marker;}_3a7=dlu.merge(_3a7,t);}if(_3aa){_3a7=this.post(_3a7,_3a8);}return _3a7;},post:function(_3ac,_3ad){var fill=_3ac.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_3ad=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_3ad=="slice"||_3ad=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_3ac,{series:{fill:t}});}}return _3ac;},getTick:function(name,_3ae){var tick=this.axis.tick,_3af=name+"Tick",_3b0=dlu.merge;if(tick){if(this.axis[_3af]){tick=_3b0(tick,this.axis[_3af]);}}else{tick=this.axis[_3af];}if(_3ae){if(tick){if(_3ae[_3af]){tick=_3b0(tick,_3ae[_3af]);}}else{tick=_3ae[_3af];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_3b1){this.markers[name]=_3b1;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_39b,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",titleGap:15,titleFont:"normal normal normal 11pt Tahoma",titleFontColor:"#333",titleOrientation:"axis"},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}},defineColors:function(_3b2){_3b2=_3b2||{};var l,c=[],n=_3b2.num||5;if(_3b2.colors){l=_3b2.colors.length;for(var i=0;i<n;i++){c.push(_3b2.colors[i%l]);}return c;}if(_3b2.hue){var s=_3b2.saturation||100,st=_3b2.low||30,end=_3b2.high||90;l=(end+st)/2;return _399.Palette.generate(_399.fromHsv(_3b2.hue,s,l),"monochromatic").colors;}if(_3b2.generator){return _399.Palette.generate(_3b2.base,_3b2.generator).colors;}return c;},generateGradient:function(_3b3,_3b4,_3b5){var fill=lang.delegate(_3b3);fill.colors=[{offset:0,color:_3b4},{offset:1,color:_3b5}];return fill;},generateHslColor:function(_3b6,_3b7){_3b6=new _398(_3b6);var hsl=_3b6.toHsl(),_3b8=_399.fromHsl(hsl.h,hsl.s,_3b7);_3b8.a=_3b6.a;return _3b8;},generateHslGradient:function(_3b9,_3ba,_3bb,_3bc){_3b9=new _398(_3b9);var hsl=_3b9.toHsl(),_3bd=_399.fromHsl(hsl.h,hsl.s,_3bb),_3be=_399.fromHsl(hsl.h,hsl.s,_3bc);_3bd.a=_3be.a=_3b9.a;return _39b.generateGradient(_3ba,_3bd,_3be);}});return _39b;});},"dojox/charting/themes/common":function(){define("dojox/charting/themes/common",["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dojox/charting/plot2d/common":function(){define("dojox/charting/plot2d/common",["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_3bf,g,df,sc){var _3c0=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_3c0,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_3c1){if(!_3c1){return _3c1;}if(typeof _3c1=="string"||_3c1 instanceof _3bf){_3c1={color:_3c1};}return g.makeParameters(g.defaultStroke,_3c1);},augmentColor:function(_3c2,_3c3){var t=new _3bf(_3c2),c=new _3bf(_3c3);c.a=t.a;return c;},augmentStroke:function(_3c4,_3c5){var s=_3c0.makeStroke(_3c4);if(s){s.color=_3c0.augmentColor(s.color,_3c5);}return s;},augmentFill:function(fill,_3c6){var fc,c=new _3bf(_3c6);if(typeof fill=="string"||fill instanceof _3bf){return _3c0.augmentColor(fill,_3c6);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_3c7){var _3c8=lang.delegate(_3c0.defaultStats);for(var i=0;i<_3c7.length;++i){var run=_3c7[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var _3c9=_3c8.vmin,_3ca=_3c8.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}_3c8.hmin=Math.min(_3c8.hmin,x);_3c8.hmax=Math.max(_3c8.hmax,x);_3c8.vmin=Math.min(_3c8.vmin,y);_3c8.vmax=Math.max(_3c8.vmax,y);}});}if("ymin" in run){_3c8.vmin=Math.min(_3c9,run.ymin);}if("ymax" in run){_3c8.vmax=Math.max(_3ca,run.ymax);}}else{var _3cb=_3c8.hmin,_3cc=_3c8.hmax,_3c9=_3c8.vmin,_3ca=_3c8.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_3c8.hmin=Math.min(_3c8.hmin,x);_3c8.hmax=Math.max(_3c8.hmax,x);_3c8.vmin=Math.min(_3c8.vmin,y);_3c8.vmax=Math.max(_3c8.vmax,y);}});}if("xmin" in run){_3c8.hmin=Math.min(_3cb,run.xmin);}if("xmax" in run){_3c8.hmax=Math.max(_3cc,run.xmax);}if("ymin" in run){_3c8.vmin=Math.min(_3c9,run.ymin);}if("ymax" in run){_3c8.vmax=Math.max(_3ca,run.ymax);}}break;}}}return _3c8;},calculateBarSize:function(_3cd,opt,_3ce){if(!_3ce){_3ce=1;}var gap=opt.gap,size=(_3cd-2*gap)/_3ce;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_3cd-size*_3ce)/2;return {size:size,gap:gap};},collectStackedStats:function(_3cf){var _3d0=lang.clone(_3c0.defaultStats);if(_3cf.length){_3d0.hmin=Math.min(_3d0.hmin,1);_3d0.hmax=df.foldl(_3cf,"seed, run -> Math.max(seed, run.data.length)",_3d0.hmax);for(var i=0;i<_3d0.hmax;++i){var v=_3cf[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_3d0.vmin=Math.min(_3d0.vmin,v);for(var j=1;j<_3cf.length;++j){var t=_3cf[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_3d0.vmax=Math.max(_3d0.vmax,v);}}return _3d0;},curve:function(a,_3d1){var _3d2=a.slice(0);if(_3d1=="x"){_3d2[_3d2.length]=arr[0];}var p=arr.map(_3d2,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_3d1)){var dx=item.x-_3d2[i-1].x,dy=_3d2[i-1].y;return "C"+(item.x-(_3d1-1)*(dx/_3d1))+","+dy+" "+(item.x-(dx/_3d1))+","+item.y+" "+item.x+","+item.y;}else{if(_3d1=="X"||_3d1=="x"||_3d1=="S"){var p0,p1=_3d2[i-1],p2=_3d2[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_3d1=="x"){p0=_3d2[_3d2.length-2];}else{p0=p1;}f=1/3;}else{p0=_3d2[i-2];}if(i==(_3d2.length-1)){if(_3d1=="x"){p3=_3d2[1];}else{p3=p2;}f=1/3;}else{p3=_3d2[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _3d3=p0p2*f;var _3d4=p1p3*f;if(_3d3>p1p2/2&&_3d4>p1p2/2){_3d3=p1p2/2;_3d4=p1p2/2;}else{if(_3d3>p1p2/2){_3d3=p1p2/2;_3d4=p1p2/2*p1p3/p0p2;}else{if(_3d4>p1p2/2){_3d4=p1p2/2;_3d3=p1p2/2*p0p2/p1p3;}}}if(_3d1=="S"){if(p0==p1){_3d3=0;}if(p2==p3){_3d4=0;}}bz1x=p1.x+_3d3*(p2.x-p0.x)/p0p2;bz1y=p1.y+_3d3*(p2.y-p0.y)/p0p2;bz2x=p2.x-_3d4*(p3.x-p1.x)/p1p3;bz2y=p2.y-_3d4*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_3d5,_3d6,_3d7){return sc.doIfLoaded("dojo/number",function(_3d8){return (_3d6?_3d8.format(_3d5,{places:_3d7}):_3d8.format(_3d5))||"";},function(){return _3d6?_3d5.toFixed(_3d7):_3d5.toString();});}});});},"dijit/_Widget":function(){define("dijit/_Widget",["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_3d9,_3da,_3db,_3dc,_3dd,lang,_3de,_3df,_3e0,_3e1,_3e2,_3e3){function _3e4(){};function _3e5(_3e6){return function(obj,_3e7,_3e8,_3e9){if(obj&&typeof _3e7=="string"&&obj[_3e7]==_3e4){return obj.on(_3e7.substring(2).toLowerCase(),lang.hitch(_3e8,_3e9));}return _3e6.apply(_3db,arguments);};};_3d9.around(_3db,"connect",_3e5);if(_3dd.connect){_3d9.around(_3dd,"connect",_3e5);}var _3ea=_3dc("dijit._Widget",[_3e1,_3e2,_3e3],{onClick:_3e4,onDblClick:_3e4,onKeyDown:_3e4,onKeyPress:_3e4,onKeyUp:_3e4,onMouseDown:_3e4,onMouseMove:_3e4,onMouseOut:_3e4,onMouseOver:_3e4,onMouseLeave:_3e4,onMouseEnter:_3e4,onMouseUp:_3e4,constructor:function(_3eb){this._toConnect={};for(var name in _3eb){if(this[name]===_3e4){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_3eb[name];delete _3eb[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_3e4){return _3db.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_3ec){_3dd.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_3ec);},attr:function(name,_3ed){if(_3da.isDebug){var _3ee=arguments.callee._ach||(arguments.callee._ach={}),_3ef=(arguments.callee.caller||"unknown caller").toString();if(!_3ee[_3ef]){_3dd.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_3ef,"","2.0");_3ee[_3ef]=true;}}var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_3dd.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_3de("[widgetId]",this.containerNode).map(_3e0.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(!_3dd.isAsync){_3df(0,function(){var _3f0=["dijit/_base"];require(_3f0);});}return _3ea;});},"dijit/_FocusMixin":function(){define("dijit/_FocusMixin",["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_3f1,_3f2,_3f3,lang){lang.extend(_3f2,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _3f3("dijit._FocusMixin",null,{_focusManager:_3f1});});},"dijit/_OnDijitClickMixin":function(){define("dijit/_OnDijitClickMixin",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/_base/sniff","dojo/_base/unload","dojo/_base/window"],function(on,_3f4,keys,_3f5,has,_3f6,win){var _3f7=null;if(has("ie")){(function(){var _3f8=function(evt){_3f7=evt.srcElement;};win.doc.attachEvent("onkeydown",_3f8);_3f6.addOnWindowUnload(function(){win.doc.detachEvent("onkeydown",_3f8);});})();}else{win.doc.addEventListener("keydown",function(evt){_3f7=evt.target;},true);}var _3f9=function(node,_3fa){if(/input|button/i.test(node.nodeName)){return on(node,"click",_3fa);}else{function _3fb(e){return (e.keyCode==keys.ENTER||e.keyCode==keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey;};var _3fc=[on(node,"keypress",function(e){if(_3fb(e)){_3f7=e.target;e.preventDefault();}}),on(node,"keyup",function(e){if(_3fb(e)&&e.target==_3f7){_3f7=null;_3fa.call(this,e);}}),on(node,"click",function(e){_3fa.call(this,e);})];return {remove:function(){_3f4.forEach(_3fc,function(h){h.remove();});}};}};return _3f5("dijit._OnDijitClickMixin",null,{connect:function(obj,_3fd,_3fe){return this.inherited(arguments,[obj,_3fd=="ondijitclick"?_3f9:_3fd,_3fe]);}});});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo,text){return dojo.cache;});},"dojox/charting/plot2d/Bars":function(){define("dojox/charting/plot2d/Bars",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/gfx/fx","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/reversed"],function(dojo,lang,arr,_3ff,Base,dc,fx,du,df,dfr){var _400=dfr.lambda("item.purgeGroup()");return _3ff("dojox.charting.plot2d.Bars",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_401,_402){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_402);du.updateWithPattern(this.opt,_402,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var _403=dc.collectSimpleStats(this.series),t;_403.hmin-=0.5;_403.hmax+=0.5;t=_403.hmin,_403.hmin=_403.vmin,_403.vmin=t;t=_403.hmax,_403.hmax=_403.vmax,_403.vmax=t;return _403;},createRect:function(run,_404,_405){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_405);_404.add(rect);}else{rect=_404.createRect(_405);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_406){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_406);}this.dirty=this.isDirty();this.resetEvents();if(this.dirty){arr.forEach(this.series,_400);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_407,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_408=Math.max(0,this._hScaler.bounds.lower),_409=ht(_408),_40a=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_407=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _40b=t.next("bar",[this.opt,run]),s=run.group,_40c=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _40d=run.data[j];if(_40d!==null){var v=typeof _40d=="number"?_40d:_40d.y,hv=ht(v),_40e=hv-_409,w=Math.abs(_40e),_40f=typeof _40d!="number"?t.addMixin(_40b,"bar",_40d,true):t.post(_40b,"bar");if(w>=0&&_407>=1){var rect={x:_406.l+(v<_408?hv:_409),y:dim.height-_406.b-vt(j+1.5)+gap,width:w,height:_407};var _410=this._plotFill(_40f.series.fill,dim,_406);_410=this._shapeFill(_410,rect);var _411=this.createRect(run,s,rect).setFill(_410).setStroke(_40f.series.stroke);run.dyn.fill=_411.getFill();run.dyn.stroke=_411.getStroke();if(_40a){var o={element:"bar",index:j,run:run,shape:_411,x:v,y:j+1.5};this._connectEvents(o);_40c[j]=o;}if(this.animate){this._animateBar(_411,_406.l+_409,-w);}}}}this._eventSeries[run.name]=_40c;run.dirty=false;}this.dirty=false;return this;},_animateBar:function(_412,_413,_414){fx.animateTransform(lang.delegate({shape:_412,duration:1200,transform:[{name:"translate",start:[_413-(_413/_414),0],end:[0,0]},{name:"scale",start:[1/_414,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/gfx/_base":function(){define("dojox/gfx/_base",["dojo/_base/lang","dojo/_base/html","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(lang,html,_415,has,win,arr,dom,_416,_417){var g=lang.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(node,_418){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_418+" ")>=0;};g._addClass=function(node,_419){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_419+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+_419);}};g._removeClass=function(node,_41a){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_41a+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _41b={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p;if(has("ie")){win.doc.documentElement.style.fontSize="100%";}var div=_416.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _41b){div.style.fontSize=p;_41b[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}win.body().removeChild(div);return _41b;};var _41c=null;b._getCachedFontMeasurements=function(_41d){if(_41d||!_41c){_41c=b._getFontMeasurements();}return _41c;};var _41e=null,_41f={};b._getTextBox=function(text,_420,_421){var m,s,al=arguments.length;var i;if(!_41e){_41e=_416.create("div",{style:{position:"absolute",top:"-10000px",left:"0"}},win.body());}m=_41e;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_420){for(i in _420){if(i in _41f){continue;}s[i]=_420[i];}}if(al>2&&_421){m.className=_421;}m.innerHTML=text;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return {l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return _417.getMarginBox(m);}};var _422=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"xUnique"+(++_422);}while(dom.byId(id));return id;};lang.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _423={};return function(type){var t=_423[type];if(t){return new t();}t=_423[type]=new Function();t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_424){return (_424 instanceof _415)?_424:new _415(_424);},normalizeParameters:function(_425,_426){var x;if(_426){var _427={};for(x in _425){if(x in _426&&!(x in _427)){_425[x]=_426[x];}}}return _425;},makeParameters:function(_428,_429){var i=null;if(!_429){return lang.delegate(_428);}var _42a={};for(i in _428){if(!(i in _42a)){_42a[i]=lang.clone((i in _429)?_429[i]:_428[i]);}}return _42a;},formatNumber:function(x,_42b){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _42c=val.indexOf(".");if(_42c>=0&&val.length-_42c>5){val=x.toFixed(4);}}if(x<0){return val;}return _42b?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _42d=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_42d;case "in":return val*72*_42d;case "pc":return val*12*_42d;case "mm":return val*g.mm_in_pt*_42d;case "cm":return val*g.cm_in_pt*_42d;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_42e){var ns=typeof _42e=="string"?g[_42e]:_42e;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});}}});return g;});},"dijit/focus":function(){define("dijit/focus",["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","."],function(_42f,_430,dom,_431,_432,_433,lang,on,_434,has,_435,_436,win,_437,a11y,_438,_439){var _43a=_430([_435,_433],{curNode:null,activeStack:[],constructor:function(){var _43b=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_42f.before(_432,"empty",_43b);_42f.before(_432,"destroy",_43b);},registerIframe:function(_43c){return this.registerWin(_43c.contentWindow,_43c);},registerWin:function(_43d,_43e){var _43f=this;var _440=function(evt){_43f._justMouseDowned=true;setTimeout(function(){_43f._justMouseDowned=false;},0);if(has("ie")&&evt&&evt.srcElement&&evt.srcElement.parentNode==null){return;}_43f._onTouchNode(_43e||evt.target||evt.srcElement,"mouse");};var doc=has("ie")?_43d.document.documentElement:_43d.document;if(doc){if(has("ie")){_43d.document.body.attachEvent("onmousedown",_440);var _441=function(evt){var tag=evt.srcElement.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isTabNavigable(evt.srcElement)){_43f._onFocusNode(_43e||evt.srcElement);}else{_43f._onTouchNode(_43e||evt.srcElement);}};doc.attachEvent("onactivate",_441);var _442=function(evt){_43f._onBlurNode(_43e||evt.srcElement);};doc.attachEvent("ondeactivate",_442);return {remove:function(){_43d.document.detachEvent("onmousedown",_440);doc.detachEvent("onactivate",_441);doc.detachEvent("ondeactivate",_442);doc=null;}};}else{doc.body.addEventListener("mousedown",_440,true);doc.body.addEventListener("touchstart",_440,true);var _443=function(evt){_43f._onFocusNode(_43e||evt.target);};doc.addEventListener("focus",_443,true);var _444=function(evt){_43f._onBlurNode(_43e||evt.target);};doc.addEventListener("blur",_444,true);return {remove:function(){doc.body.removeEventListener("mousedown",_440,true);doc.body.removeEventListener("touchstart",_440,true);doc.removeEventListener("focus",_443,true);doc.removeEventListener("blur",_444,true);doc=null;}};}}},_onBlurNode:function(){this.set("prevNode",this.curNode);this.set("curNode",null);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);this.prevNode=null;}),100);},_onTouchNode:function(node,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}var _445=[];try{while(node){var _446=_431.get(node,"dijitPopupParent");if(_446){node=_438.byId(_446).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_437.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_447=id&&_438.byId(id);if(_447&&!(by=="mouse"&&_447.get("disabled"))){_445.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_445,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("curNode",node);},_setStack:function(_448,by){var _449=this.activeStack;this.set("activeStack",_448);for(var _44a=0;_44a<Math.min(_449.length,_448.length);_44a++){if(_449[_44a]!=_448[_44a]){break;}}var _44b;for(var i=_449.length-1;i>=_44a;i--){_44b=_438.byId(_449[i]);if(_44b){_44b._hasBeenBlurred=true;_44b.set("focused",false);if(_44b._focusManager==this){_44b._onBlur(by);}this.emit("widget-blur",_44b,by);}}for(i=_44a;i<_448.length;i++){_44b=_438.byId(_448[i]);if(_44b){_44b.set("focused",true);if(_44b._focusManager==this){_44b._onFocus(by);}this.emit("widget-focus",_44b,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _44c=new _43a();_434(function(){var _44d=_44c.registerWin(win.doc.parentWindow||win.doc.defaultView);if(has("ie")){_436.addOnWindowUnload(function(){_44d.remove();_44d=null;});}});_439.focus=function(node){_44c.focus(node);};for(var attr in _44c){if(!/^_/.test(attr)){_439.focus[attr]=typeof _44c[attr]=="function"?lang.hitch(_44c,attr):_44c[attr];}}_44c.watch(function(attr,_44e,_44f){_439.focus[attr]=_44f;});return _44c;});},"dojox/charting/widget/Legend":function(){define("dojox/charting/widget/Legend",["dojo/_base/lang","dojo/_base/html","dojo/_base/declare","dijit/_Widget","dojox/gfx","dojo/_base/array","dojox/lang/functional","dojox/lang/functional/array","dojox/lang/functional/fold","dojo/dom","dojo/dom-construct","dojo/dom-class","dijit/_base/manager"],function(lang,html,_450,_451,gfx,_452,df,dfa,dff,dom,_453,_454,_455){var _456=/\.(StackedColumns|StackedAreas|ClusteredBars)$/;return _450("dojox.charting.widget.Legend",_451,{chartRef:"",horizontal:true,swatchSize:18,legendBody:null,postCreate:function(){if(!this.chart){if(!this.chartRef){return;}this.chart=_455.byId(this.chartRef);if(!this.chart){var node=dom.byId(this.chartRef);if(node){this.chart=_455.byNode(node);}else{return;}}this.series=this.chart.chart.series;}else{this.series=this.chart.series;}this.refresh();},buildRendering:function(){this.domNode=_453.create("table",{role:"group","aria-label":"chart legend","class":"dojoxLegendNode"});this.legendBody=_453.create("tbody",null,this.domNode);this.inherited(arguments);},refresh:function(){if(this._surfaces){_452.forEach(this._surfaces,function(_457){_457.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){_453.destroy(this.legendBody.lastChild);}if(this.horizontal){_454.add(this.domNode,"dojoxLegendHorizontal");this._tr=_453.create("tr",null,this.legendBody);this._inrow=0;}var s=this.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _458=df.map(t.run.data,"Math.max(x, 0)");if(df.every(_458,"<= 0")){return;}var _459=df.map(_458,"/this",df.foldl(_458,"+",0));_452.forEach(_459,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{_452.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{if(this._isReversal()){s=s.slice(0).reverse();}_452.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_45a){var _45b=_453.create("td"),icon=_453.create("div",null,_45b),text=_453.create("label",null,_45b),div=_453.create("div",{style:{"width":this.swatchSize+"px","height":this.swatchSize+"px","float":"left"}},icon);_454.add(icon,"dojoxLegendIcon dijitInline");_454.add(text,"dojoxLegendText");if(this._tr){this._tr.appendChild(_45b);if(++this._inrow===this.horizontal){this._tr=_453.create("tr",null,this.legendBody);this._inrow=0;}}else{var tr=_453.create("tr",null,this.legendBody);tr.appendChild(_45b);}this._makeIcon(div,dyn);text.innerHTML=String(_45a);text.dir=this.getTextDir(_45a,text.dir);},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _45c=gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_45c);if(dyn.fill){_45c.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_45c.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};if(dyn.stroke){_45c.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.stroke.color).setStroke(dyn.stroke);}else{_45c.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.color).setStroke(dyn.color);}}}else{_45c.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_45c.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_45c.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}},_isReversal:function(){return (!this.horizontal)&&_452.some(this.chart.stack,function(item){return _456.test(item.declaredClass);});}});});},"dojox/charting/plot2d/StackedLines":function(){define("dojox/charting/plot2d/StackedLines",["dojo/_base/declare","./Stacked"],function(_45d,_45e){return _45d("dojox.charting.plot2d.StackedLines",_45e,{constructor:function(){this.opt.lines=true;}});});},"dojox/charting/plot2d/StackedColumns":function(){define("dojox/charting/plot2d/StackedColumns",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Columns","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/functional/sequence"],function(lang,arr,_45f,_460,dc,df,dfr,dfs){var _461=dfr.lambda("item.purgeGroup()");return _45f("dojox.charting.plot2d.StackedColumns",_460,{getSeriesStats:function(){var _462=dc.collectStackedStats(this.series);this._maxRunLength=_462.hmax;_462.hmin-=0.5;_462.hmax+=0.5;return _462;},render:function(dim,_463){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var _464=run.data[j];if(_464!==null){var v=typeof _464=="number"?_464:_464.y;if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_463);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_461);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_465,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_466=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_465=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _467=t.next("column",[this.opt,run]),s=run.group,_468=new Array(acc.length);for(var j=0;j<acc.length;++j){var _464=run.data[j];if(_464!==null){var v=acc[j],_469=vt(v),_46a=typeof _464!="number"?t.addMixin(_467,"column",_464,true):t.post(_467,"column");if(_465>=1&&_469>=0){var rect={x:_463.l+ht(j+0.5)+gap,y:dim.height-_463.b-vt(v),width:_465,height:_469};var _46b=this._plotFill(_46a.series.fill,dim,_463);_46b=this._shapeFill(_46b,rect);var _46c=s.createRect(rect).setFill(_46b).setStroke(_46a.series.stroke);run.dyn.fill=_46c.getFill();run.dyn.stroke=_46c.getStroke();if(_466){var o={element:"column",index:j,run:run,shape:_46c,x:j+0.5,y:v};this._connectEvents(o);_468[j]=o;}if(this.animate){this._animateColumn(_46c,dim.height-_463.b,_469);}}}}this._eventSeries[run.name]=_468;run.dirty=false;for(var j=0;j<run.data.length;++j){var _464=run.data[j];if(_464!==null){var v=typeof _464=="number"?_464:_464.y;if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_46d,_46e){return _46d("dojox.charting.Series",_46e,{constructor:function(_46f,data,_470){lang.mixin(this,_470);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/plot2d/Default":function(){define("dojox/charting/plot2d/Default",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_471,arr,Base,dc,df,dfr,du,fx){var _472=dfr.lambda("item.purgeGroup()");var _473=1200;return _471("dojox.charting.plot2d.Default",Base,{defaultParams:{hAxis:"x",vAxis:"y",lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_474,_475){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_475);du.updateWithPattern(this.opt,_475,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},createPath:function(run,_476,_477){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_477);_476.add(path);}else{path=_476.createPath(_477);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},render:function(dim,_478){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_478);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_472);this._eventSeries={};this.cleanGroup();this.group.setTransform(null);var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_479,_47a,_47b,_47c=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _47d=t.next(this.opt.areas?"area":"line",[this.opt,run],true),s=run.group,_47e=[],_47f=[],rseg=null,_480,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_481=this._eventSeries[run.name]=new Array(run.data.length);var _482=typeof run.data[0]=="number";var min=_482?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_482?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;j++){if(run.data[j]!=null){if(!rseg){rseg=[];_47f.push(j);_47e.push(rseg);}rseg.push(run.data[j]);}else{rseg=null;}}for(var seg=0;seg<_47e.length;seg++){if(typeof _47e[seg][0]=="number"){_480=arr.map(_47e[seg],function(v,i){return {x:ht(i+_47f[seg]+1)+_478.l,y:dim.height-_478.b-vt(v)};},this);}else{_480=arr.map(_47e[seg],function(v,i){return {x:ht(v.x)+_478.l,y:dim.height-_478.b-vt(v.y)};},this);}var _483=this.opt.tension?dc.curve(_480,this.opt.tension):"";if(this.opt.areas&&_480.length>1){var fill=_47d.series.fill;var _484=lang.clone(_480);if(this.opt.tension){var _485="L"+_484[_484.length-1].x+","+(dim.height-_478.b)+" L"+_484[0].x+","+(dim.height-_478.b)+" L"+_484[0].x+","+_484[0].y;run.dyn.fill=s.createPath(_483+" "+_485).setFill(fill).getFill();}else{_484.push({x:_480[_480.length-1].x,y:dim.height-_478.b});_484.push({x:_480[0].x,y:dim.height-_478.b});_484.push(_480[0]);run.dyn.fill=s.createPolyline(_484).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_479=_47d.series.stroke;if(_47d.series.outline){_47a=run.dyn.outline=dc.makeStroke(_47d.series.outline);_47a.width=2*_47a.width+_479.width;}}if(this.opt.markers){run.dyn.marker=_47d.symbol;}var _486=null,_487=null,_488=null;if(_479&&_47d.series.shadow&&_480.length>1){var _489=_47d.series.shadow,_48a=arr.map(_480,function(c){return {x:c.x+_489.dx,y:c.y+_489.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_48a,this.opt.tension)).setStroke(_489).getStroke();}else{run.dyn.shadow=s.createPolyline(_48a).setStroke(_489).getStroke();}}if(this.opt.markers&&_47d.marker.shadow){_489=_47d.marker.shadow;_488=arr.map(_48a,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_47d.symbol).setStroke(_489).setFill(_489.color);},this);}}if(this.opt.lines&&_480.length>1){if(_47a){if(this.opt.tension){run.dyn.outline=s.createPath(_483).setStroke(_47a).getStroke();}else{run.dyn.outline=s.createPolyline(_480).setStroke(_47a).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_483).setStroke(_479).getStroke();}else{run.dyn.stroke=s.createPolyline(_480).setStroke(_479).getStroke();}}if(this.opt.markers){_486=new Array(_480.length);_487=new Array(_480.length);_47a=null;if(_47d.marker.outline){_47a=dc.makeStroke(_47d.marker.outline);_47a.width=2*_47a.width+(_47d.marker.stroke?_47d.marker.stroke.width:0);}arr.forEach(_480,function(c,i){var path="M"+c.x+" "+c.y+" "+_47d.symbol;if(_47a){_487[i]=this.createPath(run,s,path).setStroke(_47a);}_486[i]=this.createPath(run,s,path).setStroke(_47d.marker.stroke).setFill(_47d.marker.fill);},this);run.dyn.markerFill=_47d.marker.fill;run.dyn.markerStroke=_47d.marker.stroke;if(_47c){arr.forEach(_486,function(s,i){var o={element:"marker",index:i+_47f[seg],run:run,shape:s,outline:_487[i]||null,shadow:_488&&_488[i]||null,cx:_480[i].x,cy:_480[i].y};if(typeof _47e[seg][0]=="number"){o.x=i+_47f[seg]+1;o.y=_47e[seg][i];}else{o.x=_47e[seg][i].x;o.y=_47e[seg][i].y;}this._connectEvents(o);_481[i+_47f[seg]]=o;},this);}else{delete this._eventSeries[run.name];}}}run.dirty=false;}if(this.animate){var _48b=this.group;fx.animateTransform(lang.delegate({shape:_48b,duration:_473,transform:[{name:"translate",start:[0,dim.height-_478.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dijit/main":function(){define("dijit/main",["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dojox/charting/plot2d/Base":function(){define("dojox/charting/plot2d/Base",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","../Element","./_PlotEvents","dojo/_base/array","../scaler/primitive","./common","dojox/gfx/fx"],function(lang,_48c,hub,_48d,_48e,arr,_48f,_490,fx){return _48c("dojox.charting.plot2d.Base",[_48d,_48e],{constructor:function(_491,_492){this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};},clear:function(){this.series=[];this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_493){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_494){var r={};r.x=th(_494[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_494[av.name]);return r;};return _493?t(_493):t;},toData:function(_495){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_496){var r={};r[ah.name]=th(_496.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_496.y-o.b);return r;};return _495?t(_495):t;},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _490.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},performZoom:function(dim,_497){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_498=dim.height-_497.b,_499=this._hScaler.bounds,_49a=(_499.from-_499.lower)*_499.scale,_49b=this._vScaler.bounds,_49c=(_49b.from-_49b.lower)*_49b.scale,_49d=vs/this.lastWindow.vscale,_49e=hs/this.lastWindow.hscale,_49f=(this.lastWindow.xoffset-_49a)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_4a0=(_49c-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_4a1=this.group,anim=fx.animateTransform(lang.delegate({shape:_4a1,duration:1200,transform:[{name:"translate",start:[0,0],end:[_497.l*(1-_49e),_498*(1-_49d)]},{name:"scale",start:[1,1],end:[_49e,_49d]},{name:"original"},{name:"translate",start:[0,0],end:[_49f,_4a0]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_49a,yoffset:_49c});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},render:function(dim,_4a2){return this;},getRequiredColors:function(){return this.series.length;},initializeScalers:function(dim,_4a3){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_4a3.hmin,_4a3.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_48f.buildScaler(_4a3.hmin,_4a3.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_4a3.vmin,_4a3.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_48f.buildScaler(_4a3.vmin,_4a3.vmax,dim.height);}return this;}});});},"dojox/charting/action2d/Tooltip":function(){define("dojox/charting/action2d/Tooltip",["dojo/_base/kernel","dijit/Tooltip","dojo/_base/lang","dojo/_base/html","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(dojo,_4a4,lang,html,_4a5,_4a6,m,df,dfs,dff){var _4a7=function(o){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(o.element=="candlestick"){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";}return o.element=="bar"?o.x:o.y;};var pi4=Math.PI/4,pi2=Math.PI/2;return _4a5("dojox.charting.action2d.Tooltip",_4a6,{defaultParams:{text:_4a7},optionalParams:{},constructor:function(_4a8,plot,_4a9){this.text=_4a9&&_4a9.text?_4a9.text:_4a7;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_4a4.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||o.type!=="onmouseover"){return;}var _4aa={type:"rect"},_4ab=["after","before"];switch(o.element){case "marker":_4aa.x=o.cx;_4aa.y=o.cy;_4aa.w=_4aa.h=1;break;case "circle":_4aa.x=o.cx-o.cr;_4aa.y=o.cy-o.cr;_4aa.w=_4aa.h=2*o.cr;break;case "column":_4ab=["above","below"];case "bar":_4aa=lang.clone(o.shape.getShape());break;case "candlestick":_4aa.x=o.x;_4aa.y=o.y;_4aa.w=o.width;_4aa.h=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _4ac=m._degToRad(o.plot.opt.startAngle),_4ad=(this.angles[o.index]+this.angles[o.index+1])/2+_4ac;_4aa.x=o.cx+o.cr*Math.cos(_4ad);_4aa.y=o.cy+o.cr*Math.sin(_4ad);_4aa.w=_4aa.h=1;if(_4ad<pi4){}else{if(_4ad<pi2+pi4){_4ab=["below","above"];}else{if(_4ad<Math.PI+pi4){_4ab=["before","after"];}else{if(_4ad<2*Math.PI-pi4){_4ab=["above","below"];}}}}break;}var lt=this.chart.getCoords();_4aa.x+=lt.x;_4aa.y+=lt.y;_4aa.x=Math.round(_4aa.x);_4aa.y=Math.round(_4aa.y);_4aa.w=Math.ceil(_4aa.w);_4aa.h=Math.ceil(_4aa.h);this.aroundRect=_4aa;var _4ae=this.text(o);if(this.chart.getTextDir){var _4af=(html.style(this.chart.node,"direction")=="rtl");var _4b0=(this.chart.getTextDir(_4ae)=="rtl");}if(_4ae){if(_4b0&&!_4af){_4a4.show("<span dir = 'rtl'>"+_4ae+"</span>",this.aroundRect,_4ab);}else{if(!_4b0&&_4af){_4a4.show("<span dir = 'ltr'>"+_4ae+"</span>",this.aroundRect,_4ab);}else{_4a4.show(_4ae,this.aroundRect,_4ab);}}}}});});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(lang,_4b1,_4b2){_4b1.switchTo(_4b2);return _4b1;});},"dojox/charting/Chart2D":function(){define("dojox/charting/Chart2D",["dojo/_base/kernel","dojox","./Chart","./axis2d/Default","./axis2d/Invisible","./plot2d/Default","./plot2d/Lines","./plot2d/Areas","./plot2d/Markers","./plot2d/MarkersOnly","./plot2d/Scatter","./plot2d/Stacked","./plot2d/StackedLines","./plot2d/StackedAreas","./plot2d/Columns","./plot2d/StackedColumns","./plot2d/ClusteredColumns","./plot2d/Bars","./plot2d/StackedBars","./plot2d/ClusteredBars","./plot2d/Grid","./plot2d/Pie","./plot2d/Bubble","./plot2d/Candlesticks","./plot2d/OHLC","./plot2d/Spider"],function(dojo,_4b3,_4b4){dojo.deprecated("dojox.charting.Chart2D","Use dojo.charting.Chart instead and require all other components explicitly","2.0");return _4b3.charting.Chart2D=_4b4;});},"dojox/charting/scaler/linear":function(){define("dojox/charting/scaler/linear",["dojo/_base/lang","./common"],function(lang,_4b5){var _4b6=lang.getObject("dojox.charting.scaler.linear",true);var _4b7=3,_4b8=_4b5.findString,_4b9=_4b5.getNumericLabel;var _4ba=function(min,max,_4bb,_4bc,_4bd,_4be,span){_4bb=lang.delegate(_4bb);if(!_4bc){if(_4bb.fixUpper=="major"){_4bb.fixUpper="minor";}if(_4bb.fixLower=="major"){_4bb.fixLower="minor";}}if(!_4bd){if(_4bb.fixUpper=="minor"){_4bb.fixUpper="micro";}if(_4bb.fixLower=="minor"){_4bb.fixLower="micro";}}if(!_4be){if(_4bb.fixUpper=="micro"){_4bb.fixUpper="none";}if(_4bb.fixLower=="micro"){_4bb.fixLower="none";}}var _4bf=_4b8(_4bb.fixLower,["major"])?Math.floor(_4bb.min/_4bc)*_4bc:_4b8(_4bb.fixLower,["minor"])?Math.floor(_4bb.min/_4bd)*_4bd:_4b8(_4bb.fixLower,["micro"])?Math.floor(_4bb.min/_4be)*_4be:_4bb.min,_4c0=_4b8(_4bb.fixUpper,["major"])?Math.ceil(_4bb.max/_4bc)*_4bc:_4b8(_4bb.fixUpper,["minor"])?Math.ceil(_4bb.max/_4bd)*_4bd:_4b8(_4bb.fixUpper,["micro"])?Math.ceil(_4bb.max/_4be)*_4be:_4bb.max;if(_4bb.useMin){min=_4bf;}if(_4bb.useMax){max=_4c0;}var _4c1=(!_4bc||_4bb.useMin&&_4b8(_4bb.fixLower,["major"]))?min:Math.ceil(min/_4bc)*_4bc,_4c2=(!_4bd||_4bb.useMin&&_4b8(_4bb.fixLower,["major","minor"]))?min:Math.ceil(min/_4bd)*_4bd,_4c3=(!_4be||_4bb.useMin&&_4b8(_4bb.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_4be)*_4be,_4c4=!_4bc?0:(_4bb.useMax&&_4b8(_4bb.fixUpper,["major"])?Math.round((max-_4c1)/_4bc):Math.floor((max-_4c1)/_4bc))+1,_4c5=!_4bd?0:(_4bb.useMax&&_4b8(_4bb.fixUpper,["major","minor"])?Math.round((max-_4c2)/_4bd):Math.floor((max-_4c2)/_4bd))+1,_4c6=!_4be?0:(_4bb.useMax&&_4b8(_4bb.fixUpper,["major","minor","micro"])?Math.round((max-_4c3)/_4be):Math.floor((max-_4c3)/_4be))+1,_4c7=_4bd?Math.round(_4bc/_4bd):0,_4c8=_4be?Math.round(_4bd/_4be):0,_4c9=_4bc?Math.floor(Math.log(_4bc)/Math.LN10):0,_4ca=_4bd?Math.floor(Math.log(_4bd)/Math.LN10):0,_4cb=span/(max-min);if(!isFinite(_4cb)){_4cb=1;}return {bounds:{lower:_4bf,upper:_4c0,from:min,to:max,scale:_4cb,span:span},major:{tick:_4bc,start:_4c1,count:_4c4,prec:_4c9},minor:{tick:_4bd,start:_4c2,count:_4c5,prec:_4ca},micro:{tick:_4be,start:_4c3,count:_4c6,prec:0},minorPerMajor:_4c7,microPerMinor:_4c8,scaler:_4b6};};return lang.mixin(_4b6,{buildScaler:function(min,max,span,_4cc){var h={fixUpper:"none",fixLower:"none",natural:false};if(_4cc){if("fixUpper" in _4cc){h.fixUpper=String(_4cc.fixUpper);}if("fixLower" in _4cc){h.fixLower=String(_4cc.fixLower);}if("natural" in _4cc){h.natural=Boolean(_4cc.natural);}}if("min" in _4cc){min=_4cc.min;}if("max" in _4cc){max=_4cc.max;}if(_4cc.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _4cc){min=_4cc.from;h.useMin=false;}if("to" in _4cc){max=_4cc.to;h.useMax=false;}if(max<=min){return _4ba(min,max,h,0,0,0,span);}var mag=Math.floor(Math.log(max-min)/Math.LN10),_4cd=_4cc&&("majorTickStep" in _4cc)?_4cc.majorTickStep:Math.pow(10,mag),_4ce=0,_4cf=0,_4d0;if(_4cc&&("minorTickStep" in _4cc)){_4ce=_4cc.minorTickStep;}else{do{_4ce=_4cd/10;if(!h.natural||_4ce>0.9){_4d0=_4ba(min,max,h,_4cd,_4ce,0,span);if(_4d0.bounds.scale*_4d0.minor.tick>_4b7){break;}}_4ce=_4cd/5;if(!h.natural||_4ce>0.9){_4d0=_4ba(min,max,h,_4cd,_4ce,0,span);if(_4d0.bounds.scale*_4d0.minor.tick>_4b7){break;}}_4ce=_4cd/2;if(!h.natural||_4ce>0.9){_4d0=_4ba(min,max,h,_4cd,_4ce,0,span);if(_4d0.bounds.scale*_4d0.minor.tick>_4b7){break;}}return _4ba(min,max,h,_4cd,0,0,span);}while(false);}if(_4cc&&("microTickStep" in _4cc)){_4cf=_4cc.microTickStep;_4d0=_4ba(min,max,h,_4cd,_4ce,_4cf,span);}else{do{_4cf=_4ce/10;if(!h.natural||_4cf>0.9){_4d0=_4ba(min,max,h,_4cd,_4ce,_4cf,span);if(_4d0.bounds.scale*_4d0.micro.tick>_4b7){break;}}_4cf=_4ce/5;if(!h.natural||_4cf>0.9){_4d0=_4ba(min,max,h,_4cd,_4ce,_4cf,span);if(_4d0.bounds.scale*_4d0.micro.tick>_4b7){break;}}_4cf=_4ce/2;if(!h.natural||_4cf>0.9){_4d0=_4ba(min,max,h,_4cd,_4ce,_4cf,span);if(_4d0.bounds.scale*_4d0.micro.tick>_4b7){break;}}_4cf=0;}while(false);}return _4cf?_4d0:_4ba(min,max,h,_4cd,_4ce,0,span);},buildTicks:function(_4d1,_4d2){var step,next,tick,_4d3=_4d1.major.start,_4d4=_4d1.minor.start,_4d5=_4d1.micro.start;if(_4d2.microTicks&&_4d1.micro.tick){step=_4d1.micro.tick,next=_4d5;}else{if(_4d2.minorTicks&&_4d1.minor.tick){step=_4d1.minor.tick,next=_4d4;}else{if(_4d1.major.tick){step=_4d1.major.tick,next=_4d3;}else{return null;}}}var _4d6=1/_4d1.bounds.scale;if(_4d1.bounds.to<=_4d1.bounds.from||isNaN(_4d6)||!isFinite(_4d6)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _4d7=[],_4d8=[],_4d9=[];while(next<=_4d1.bounds.to+_4d6){if(Math.abs(_4d3-next)<step/2){tick={value:_4d3};if(_4d2.majorLabels){tick.label=_4b9(_4d3,_4d1.major.prec,_4d2);}_4d7.push(tick);_4d3+=_4d1.major.tick;_4d4+=_4d1.minor.tick;_4d5+=_4d1.micro.tick;}else{if(Math.abs(_4d4-next)<step/2){if(_4d2.minorTicks){tick={value:_4d4};if(_4d2.minorLabels&&(_4d1.minMinorStep<=_4d1.minor.tick*_4d1.bounds.scale)){tick.label=_4b9(_4d4,_4d1.minor.prec,_4d2);}_4d8.push(tick);}_4d4+=_4d1.minor.tick;_4d5+=_4d1.micro.tick;}else{if(_4d2.microTicks){_4d9.push({value:_4d5});}_4d5+=_4d1.micro.tick;}}next+=step;}return {major:_4d7,minor:_4d8,micro:_4d9};},getTransformerFromModel:function(_4da){var _4db=_4da.bounds.from,_4dc=_4da.bounds.scale;return function(x){return (x-_4db)*_4dc;};},getTransformerFromPlot:function(_4dd){var _4de=_4dd.bounds.from,_4df=_4dd.bounds.scale;return function(x){return x/_4df+_4de;};}});});},"dojox/gfx/renderer":function(){define("dojox/gfx/renderer",["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_4e0){var _4e1=null;return {load:function(id,_4e2,load){if(_4e1&&id!="force"){load(_4e1);return;}var _4e3=_4e0.forceGfxRenderer,_4e4=!_4e3&&(lang.isString(_4e0.gfxRenderer)?_4e0.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_4e5,_4e6;while(!_4e3&&_4e4.length){switch(_4e4.shift()){case "svg":if("SVGAngle" in win.global){_4e3="svg";}break;case "vml":if(has("ie")){_4e3="vml";}break;case "silverlight":try{if(has("ie")){_4e5=new ActiveXObject("AgControl.AgControl");if(_4e5&&_4e5.IsVersionSupported("1.0")){_4e6=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_4e6=true;}}}catch(e){_4e6=false;}finally{_4e5=null;}if(_4e6){_4e3="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_4e3="canvas";}break;}}if(_4e3==="canvas"&&_4e0.canvasEvents!==false){_4e3="canvasWithEvents";}if(_4e0.isDebug){}function _4e7(){_4e2(["dojox/gfx/"+_4e3],function(_4e8){g.renderer=_4e3;_4e1=_4e8;load(_4e8);});};if(_4e3=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_4e7);}else{_4e7();}}};});},"dojox/charting/widget/Chart":function(){define("dojox/charting/widget/Chart",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/html","dojo/_base/declare","dojo/query","dijit/_Widget","../Chart","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/lambda","dijit/_base/manager"],function(_4e9,lang,arr,html,_4ea,_4eb,_4ec,_4ed,du,df,dfl){var _4ee,_4ef,_4f0,_4f1,_4f2,_4f3=function(o){return o;},dc=lang.getObject("dojox.charting");var _4f4=_4ea("dojox.charting.widget.Chart",_4ec,{theme:null,margins:null,stroke:undefined,fill:undefined,buildRendering:function(){this.inherited(arguments);n=this.domNode;var axes=_4eb("> .axis",n).map(_4ef).filter(_4f3),_4f5=_4eb("> .plot",n).map(_4f0).filter(_4f3),_4f6=_4eb("> .action",n).map(_4f1).filter(_4f3),_4f7=_4eb("> .series",n).map(_4f2).filter(_4f3);n.innerHTML="";var c=this.chart=new _4ed(n,{margins:this.margins,stroke:this.stroke,fill:this.fill,textDir:this.textDir});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_4f5.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_4f6.map(function(_4f8){return new _4f8.action(c,_4f8.plot,_4f8.kwArgs);});var _4f9=df.foldl(_4f7,function(_4fa,_4fb){if(_4fb.type=="data"){c.addSeries(_4fb.name,_4fb.data,_4fb.kwArgs);_4fa=true;}else{c.addSeries(_4fb.name,[0],_4fb.kwArgs);var kw={};du.updateWithPattern(kw,_4fb.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_4fb.kwArgs.sort){kw.sort=lang.clone(_4fb.kwArgs.sort);}lang.mixin(kw,{onComplete:function(data){var _4fc;if("valueFn" in _4fb.kwArgs){var fn=_4fb.kwArgs.valueFn;_4fc=arr.map(data,function(x){return fn(_4fb.data.getValue(x,_4fb.field,0));});}else{_4fc=arr.map(data,function(x){return _4fb.data.getValue(x,_4fb.field,0);});}c.addSeries(_4fb.name,_4fc,_4fb.kwArgs).render();}});_4fb.data.fetch(kw);}return _4fa;},false);if(_4f9){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){this.chart.resize(box);}});_4ee=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_4ef=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=dojo._scopeName+"x.charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=dojo._scopeName+"x.charting.axis2d.Default";}_4ee(node,type,kw);if(kw.font||kw.fontColor){if(!kw.tick){kw.tick={};}if(kw.font){kw.tick.font=kw.font;}if(kw.fontColor){kw.tick.fontColor=kw.fontColor;}}return o;};_4f0=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d&&dc.plot2d[type]){type=dojo._scopeName+"x.charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=dojo._scopeName+"x.charting.plot2d.Default";}_4ee(node,type,kw);return o;};_4f1=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=dojo._scopeName+"x.charting.action2d."+type;}var _4fd=eval("("+type+")");if(!_4fd){return null;}o.action=_4fd;}else{return null;}_4ee(node,type,kw);return o;};_4f2=function(node){var ga=lang.partial(html.attr,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("outline");if(t!=null){kw.outline=eval("("+t+")");}t=ga("shadow");if(t!=null){kw.shadow=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("font");if(t!=null){kw.font=t;}t=ga("fontColor");if(t!=null){kw.fontColor=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=t?arr.map(String(t).split(","),Number):[];return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=dfl.lambda(t);}return o;}return null;};return _4f4;});},"dojox/lang/functional":function(){define("dojox/lang/functional",["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/charting/scaler/common":function(){define("dojox/charting/scaler/common",["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _4fe=lang.getObject("dojox.charting.scaler.common",true);var _4ff={};return lang.mixin(_4fe,{doIfLoaded:function(_500,_501,_502){if(_4ff[_500]==undefined){try{_4ff[_500]=require(_500);}catch(e){_4ff[_500]=null;}}if(_4ff[_500]){return _501(_4ff[_500]);}else{return _502();}},findString:function(val,text){val=val.toLowerCase();for(var i=0;i<text.length;++i){if(val==text[i]){return true;}}return false;},getNumericLabel:function(_503,_504,_505){var def="";_4fe.doIfLoaded("dojo/number",function(_506){def=(_505.fixed?_506.format(_503,{places:_504<0?-_504:0}):_506.format(_503))||"";},function(){def=_505.fixed?_503.toFixed(_504<0?-_504:0):_503.toString();});if(_505.labelFunc){var r=_505.labelFunc(def,_503,_504);if(r){return r;}}if(_505.labels){var l=_505.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_503){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_503)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_503)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_503)){return l[lo].text;}}return def;}});});},"dojox/charting/axis2d/common":function(){define("dojox/charting/axis2d/common",["dojo/_base/lang","dojo/_base/html","dojo/_base/window","dojo/dom-geometry","dojox/gfx"],function(lang,html,win,_507,g){var _508=lang.getObject("dojox.charting.axis2d.common",true);var _509=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _50a=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _507.getMarginBox(n).w;}};return lang.mixin(_508,{createText:{gfx:function(_50b,_50c,x,y,_50d,text,font,_50e){return _50c.createText({x:x,y:y,text:text,align:_50d}).setFont(font).setFill(_50e);},html:function(_50f,_510,x,y,_511,text,font,_512,_513){var p=win.doc.createElement("div"),s=p.style,_514;if(_50f.getTextDir){p.dir=_50f.getTextDir(text);}_509(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_512;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_513){_514=_50a(p);}if(p.dir=="rtl"){x+=_513?_513:_514;}win.body().removeChild(p);s.position="relative";if(_513){s.width=_513+"px";switch(_511){case "middle":s.textAlign="center";s.left=(x-_513/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_513)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_511){case "middle":s.left=Math.floor(x-_514/2)+"px";break;case "end":s.left=Math.floor(x-_514)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_509(w);w.width="0px";w.height="0px";wrap.appendChild(p);_50f.node.insertBefore(wrap,_50f.node.firstChild);return wrap;}}});});},"dijit/_TemplatedMixin":function(){define("dijit/_TemplatedMixin",["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/_base/sniff","dojo/_base/unload","dojo/_base/window"],function(lang,_515,_516,_517,_518,_519,_51a,_51b,has,_51c,win){var _51d=_51a("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){this._attachPoints=[];this._attachEvents=[];},_stringRepl:function(tmpl){var _51e=this.declaredClass,_51f=this;return _517.substitute(tmpl,this,function(_520,key){if(key.charAt(0)=="!"){_520=lang.getObject(key.substr(1),false,_51f);}if(typeof _520=="undefined"){throw new Error(_51e+" template:"+key);}if(_520==null){return "";}return key.charAt(0)=="!"?_520:_520.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this.templateString){this.templateString=_518(this.templatePath,{sanitize:true});}var _521=_51d.getCachedTemplate(this.templateString,this._skipNodeCache);var node;if(lang.isString(_521)){node=_51b.toDom(this._stringRepl(_521));if(node.nodeType!=1){throw new Error("Invalid template: "+_521);}}else{node=_521.cloneNode(true);}this.domNode=node;this.inherited(arguments);this._attachTemplateNodes(node,function(n,p){return n.getAttribute(p);});this._beforeFillContent();this._fillContent(this.srcNodeRef);},_beforeFillContent:function(){},_fillContent:function(_522){var dest=this.containerNode;if(_522&&dest){while(_522.hasChildNodes()){dest.appendChild(_522.firstChild);}}},_attachTemplateNodes:function(_523,_524){var _525=lang.isArray(_523)?_523:(_523.all||_523.getElementsByTagName("*"));var x=lang.isArray(_523)?0:-1;for(;x<_525.length;x++){var _526=(x==-1)?_523:_525[x];if(this.widgetsInTemplate&&(_524(_526,"dojoType")||_524(_526,"data-dojo-type"))){continue;}var _527=_524(_526,"dojoAttachPoint")||_524(_526,"data-dojo-attach-point");if(_527){var _528,_529=_527.split(/\s*,\s*/);while((_528=_529.shift())){if(lang.isArray(this[_528])){this[_528].push(_526);}else{this[_528]=_526;}this._attachPoints.push(_528);}}var _52a=_524(_526,"dojoAttachEvent")||_524(_526,"data-dojo-attach-event");if(_52a){var _52b,_52c=_52a.split(/\s*,\s*/);var trim=lang.trim;while((_52b=_52c.shift())){if(_52b){var _52d=null;if(_52b.indexOf(":")!=-1){var _52e=_52b.split(":");_52b=trim(_52e[0]);_52d=trim(_52e[1]);}else{_52b=trim(_52b);}if(!_52d){_52d=_52b;}this._attachEvents.push(this.connect(_526,_515[_52b]||_52b,_52d));}}}}},destroyRendering:function(){_519.forEach(this._attachPoints,function(_52f){delete this[_52f];},this);this._attachPoints=[];_519.forEach(this._attachEvents,this.disconnect,this);this._attachEvents=[];this.inherited(arguments);}});_51d._templateCache={};_51d.getCachedTemplate=function(_530,_531){var _532=_51d._templateCache;var key=_530;var _533=_532[key];if(_533){try{if(!_533.ownerDocument||_533.ownerDocument==win.doc){return _533;}}catch(e){}_51b.destroy(_533);}_530=_517.trim(_530);if(_531||_530.match(/\$\{([^\}]+)\}/g)){return (_532[key]=_530);}else{var node=_51b.toDom(_530);if(node.nodeType!=1){throw new Error("Invalid template: "+_530);}return (_532[key]=node);}};if(has("ie")){_51c.addOnWindowUnload(function(){var _534=_51d._templateCache;for(var key in _534){var _535=_534[key];if(typeof _535=="object"){_51b.destroy(_535);}delete _534[key];}});}lang.extend(_516,{dojoAttachEvent:"",dojoAttachPoint:""});return _51d;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/window","./lambda"],function(dojo,lang,win,df){var _536={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _536)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _536)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||win.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _536)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||win.global;f=df.lambda(f);for(var i in obj){if(!(i in _536)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||win.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _536)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojo/window":function(){define(["./_base/kernel","./_base/lang","./_base/sniff","./_base/window","./dom","./dom-geometry","./dom-style"],function(dojo,lang,has,_537,dom,geom,_538){lang.getObject("window",true,dojo);dojo.window.getBox=function(){var _539=(_537.doc.compatMode=="BackCompat")?_537.body():_537.doc.documentElement;var _53a=geom.docScroll();var _53b=_537.doc.parentWindow||_537.doc.defaultView;return {l:_53a.x,t:_53a.y,w:_53b.innerWidth||_539.clientWidth,h:_53b.innerHeight||_539.clientHeight};};dojo.window.get=function(doc){if(has("ie")&&window!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;};dojo.window.scrollIntoView=function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_537.doc,body=doc.body||_537.body(),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if((!(has("mozilla")||isIE||isWK||has("opera"))||node==body||node==html)&&(typeof node.scrollIntoView!="undefined")){node.scrollIntoView(false);return;}var _53c=doc.compatMode=="BackCompat",_53d=(isIE>=9&&node.ownerDocument.parentWindow.frameElement)?((html.clientHeight>0&&html.clientWidth>0&&(body.clientHeight==0||body.clientWidth==0||body.clientHeight>html.clientHeight||body.clientWidth>html.clientWidth))?html:body):(_53c?body:html),_53e=isWK?body:_53d,_53f=_53d.clientWidth,_540=_53d.clientHeight,rtl=!geom.isBodyLtr(),_541=pos||geom.position(node),el=node.parentNode,_542=function(el){return ((isIE<=6||(isIE&&_53c))?false:(_538.get(el,"position").toLowerCase()=="fixed"));};if(_542(node)){return;}while(el){if(el==body){el=_53e;}var _543=geom.position(el),_544=_542(el);if(el==_53e){_543.w=_53f;_543.h=_540;if(_53e==html&&isIE&&rtl){_543.x+=_53e.offsetWidth-_543.w;}if(_543.x<0||!isIE){_543.x=0;}if(_543.y<0||!isIE){_543.y=0;}}else{var pb=geom.getPadBorderExtents(el);_543.w-=pb.w;_543.h-=pb.h;_543.x+=pb.l;_543.y+=pb.t;var _545=el.clientWidth,_546=_543.w-_545;if(_545>0&&_546>0){_543.w=_545;_543.x+=(rtl&&(isIE||el.clientLeft>pb.l))?_546:0;}_545=el.clientHeight;_546=_543.h-_545;if(_545>0&&_546>0){_543.h=_545;}}if(_544){if(_543.y<0){_543.h+=_543.y;_543.y=0;}if(_543.x<0){_543.w+=_543.x;_543.x=0;}if(_543.y+_543.h>_540){_543.h=_540-_543.y;}if(_543.x+_543.w>_53f){_543.w=_53f-_543.x;}}var l=_541.x-_543.x,t=_541.y-Math.max(_543.y,0),r=l+_541.w-_543.w,bot=t+_541.h-_543.h;if(r*l>0){var s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_53c)||isIE>=9)){s=-s;}_541.x+=el.scrollLeft;el.scrollLeft+=s;_541.x-=el.scrollLeft;}if(bot*t>0){_541.y+=el.scrollTop;el.scrollTop+=Math[t<0?"max":"min"](t,bot);_541.y-=el.scrollTop;}el=(el!=_53e)&&!_544&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}};return dojo.window;});},"dojox/charting/axis2d/Default":function(){define("dojox/charting/axis2d/Default",["dojo/_base/lang","dojo/_base/array","dojo/_base/sniff","dojo/_base/declare","dojo/_base/connect","dojo/_base/html","dojo/dom-geometry","./Invisible","../scaler/common","../scaler/linear","./common","dojox/gfx","dojox/lang/utils"],function(lang,arr,has,_547,_548,html,_549,_54a,_54b,lin,_54c,g,du){var _54d=4,_54e=45;return _547("dojox.charting.axis2d.Default",_54a,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_54f,_550){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_550);du.updateWithPattern(this.opt,_550,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}},getOffsets:function(){var s=this.scaler,_551={l:0,r:0,t:0,b:0};if(!s){return _551;}var o=this.opt,_552=0,a,b,c,d,gl=_54b.getNumericLabel,_553=0,ma=s.major,mi=s.minor,ta=this.chart.theme.axis,_554=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_555=o.titleFont||(ta.tick&&ta.tick.titleFont),_556=(o.titleGap==0)?0:o.titleGap||(ta.tick&&ta.tick.titleGap)||15,_557=this.chart.theme.getTick("major",o),_558=this.chart.theme.getTick("minor",o),size=_554?g.normalizedLength(g.splitFontString(_554).size):0,_559=_555?g.normalizedLength(g.splitFontString(_555).size):0,_55a=o.rotation%360,_55b=o.leftBottom,cosr=Math.abs(Math.cos(_55a*Math.PI/180)),sinr=Math.abs(Math.sin(_55a*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(_55a<0){_55a+=360;}if(size){if(this.labels){_552=this._groupLabelWidth(this.labels,_554,o.maxLabelCharCount);}else{_552=this._groupLabelWidth([gl(ma.start,ma.prec,o),gl(ma.start+ma.count*ma.tick,ma.prec,o),gl(mi.start,mi.prec,o),gl(mi.start+mi.count*mi.tick,mi.prec,o)],_554,o.maxLabelCharCount);}_552=o.maxLabelSize?Math.min(o.maxLabelSize,_552):_552;if(this.vertical){var side=_55b?"l":"r";switch(_55a){case 0:case 180:_551[side]=_552;_551.t=_551.b=size/2;break;case 90:case 270:_551[side]=size;_551.t=_551.b=_552/2;break;default:if(_55a<=_54e||(180<_55a&&_55a<=(180+_54e))){_551[side]=size*sinr/2+_552*cosr;_551[_55b?"t":"b"]=size*cosr/2+_552*sinr;_551[_55b?"b":"t"]=size*cosr/2;}else{if(_55a>(360-_54e)||(180>_55a&&_55a>(180-_54e))){_551[side]=size*sinr/2+_552*cosr;_551[_55b?"b":"t"]=size*cosr/2+_552*sinr;_551[_55b?"t":"b"]=size*cosr/2;}else{if(_55a<90||(180<_55a&&_55a<270)){_551[side]=size*sinr+_552*cosr;_551[_55b?"t":"b"]=size*cosr+_552*sinr;}else{_551[side]=size*sinr+_552*cosr;_551[_55b?"b":"t"]=size*cosr+_552*sinr;}}}break;}_551[side]+=_54d+Math.max(_557.length,_558.length)+(o.title?(_559+_556):0);}else{var side=_55b?"b":"t";switch(_55a){case 0:case 180:_551[side]=size;_551.l=_551.r=_552/2;break;case 90:case 270:_551[side]=_552;_551.l=_551.r=size/2;break;default:if((90-_54e)<=_55a&&_55a<=90||(270-_54e)<=_55a&&_55a<=270){_551[side]=size*sinr/2+_552*cosr;_551[_55b?"r":"l"]=size*cosr/2+_552*sinr;_551[_55b?"l":"r"]=size*cosr/2;}else{if(90<=_55a&&_55a<=(90+_54e)||270<=_55a&&_55a<=(270+_54e)){_551[side]=size*sinr/2+_552*cosr;_551[_55b?"l":"r"]=size*cosr/2+_552*sinr;_551[_55b?"r":"l"]=size*cosr/2;}else{if(_55a<_54e||(180<_55a&&_55a<(180-_54e))){_551[side]=size*sinr+_552*cosr;_551[_55b?"r":"l"]=size*cosr+_552*sinr;}else{_551[side]=size*sinr+_552*cosr;_551[_55b?"l":"r"]=size*cosr+_552*sinr;}}}break;}_551[side]+=_54d+Math.max(_557.length,_558.length)+(o.title?(_559+_556):0);}}if(_552){this._cachedLabelWidth=_552;}return _551;},cleanGroup:function(_55c){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_55d,_55e,x,y,_55f,_560,font,_561,_562){if(!this.opt.enableCache||_55d=="html"){return _54c.createText[_55d](this.chart,_55e,x,y,_55f,_560,font,_561,_562);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_560,align:_55f});_55e.add(text);}else{text=_54c.createText[_55d](this.chart,_55e,x,y,_55f,_560,font,_561,_562);}this._textUsePool.push(text);return text;},createLine:function(_563,_564){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_564);_563.add(line);}else{line=_563.createLine(_564);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_565){if(!this.dirty){return this;}var o=this.opt,ta=this.chart.theme.axis,_566=o.leftBottom,_567=o.rotation%360,_568,stop,_569,_56a=0,_56b,_56c,_56d,_56e,_56f,_570,_571=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_572=o.titleFont||(ta.tick&&ta.tick.titleFont),_573=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_574=o.titleFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_575=(o.titleGap==0)?0:o.titleGap||(ta.tick&&ta.tick.titleGap)||15,_576=o.titleOrientation||(ta.tick&&ta.tick.titleOrientation)||"axis",_577=this.chart.theme.getTick("major",o),_578=this.chart.theme.getTick("minor",o),_579=this.chart.theme.getTick("micro",o),_57a=Math.max(_577.length,_578.length,_579.length),_57b="stroke" in o?o.stroke:ta.stroke,size=_571?g.normalizedLength(g.splitFontString(_571).size):0,cosr=Math.abs(Math.cos(_567*Math.PI/180)),sinr=Math.abs(Math.sin(_567*Math.PI/180)),_57c=_572?g.normalizedLength(g.splitFontString(_572).size):0;if(_567<0){_567+=360;}if(this.vertical){_568={y:dim.height-_565.b};stop={y:_565.t};_569={y:(dim.height-_565.b+_565.t)/2};_56b=size*sinr+(this._cachedLabelWidth||0)*cosr+_54d+Math.max(_577.length,_578.length)+_57c+_575;_56c={x:0,y:-1};_56f={x:0,y:0};_56d={x:1,y:0};_56e={x:_54d,y:0};switch(_567){case 0:_570="end";_56f.y=size*0.4;break;case 90:_570="middle";_56f.x=-size;break;case 180:_570="start";_56f.y=-size*0.4;break;case 270:_570="middle";break;default:if(_567<_54e){_570="end";_56f.y=size*0.4;}else{if(_567<90){_570="end";_56f.y=size*0.4;}else{if(_567<(180-_54e)){_570="start";}else{if(_567<(180+_54e)){_570="start";_56f.y=-size*0.4;}else{if(_567<270){_570="start";_56f.x=_566?0:size*0.4;}else{if(_567<(360-_54e)){_570="end";_56f.x=_566?0:size*0.4;}else{_570="end";_56f.y=size*0.4;}}}}}}}if(_566){_568.x=stop.x=_565.l;_56a=(_576&&_576=="away")?90:270;_569.x=_565.l-_56b+(_56a==270?_57c:0);_56d.x=-1;_56e.x=-_56e.x;}else{_568.x=stop.x=dim.width-_565.r;_56a=(_576&&_576=="axis")?90:270;_569.x=dim.width-_565.r+_56b-(_56a==270?0:_57c);switch(_570){case "start":_570="end";break;case "end":_570="start";break;case "middle":_56f.x+=size;break;}}}else{_568={x:_565.l};stop={x:dim.width-_565.r};_569={x:(dim.width-_565.r+_565.l)/2};_56b=size*cosr+(this._cachedLabelWidth||0)*sinr+_54d+Math.max(_577.length,_578.length)+_57c+_575;_56c={x:1,y:0};_56f={x:0,y:0};_56d={x:0,y:1};_56e={x:0,y:_54d};switch(_567){case 0:_570="middle";_56f.y=size;break;case 90:_570="start";_56f.x=-size*0.4;break;case 180:_570="middle";break;case 270:_570="end";_56f.x=size*0.4;break;default:if(_567<(90-_54e)){_570="start";_56f.y=_566?size:0;}else{if(_567<(90+_54e)){_570="start";_56f.x=-size*0.4;}else{if(_567<180){_570="start";_56f.y=_566?0:-size;}else{if(_567<(270-_54e)){_570="end";_56f.y=_566?0:-size;}else{if(_567<(270+_54e)){_570="end";_56f.y=_566?size*0.4:0;}else{_570="end";_56f.y=_566?size:0;}}}}}}if(_566){_568.y=stop.y=dim.height-_565.b;_56a=(_576&&_576=="axis")?180:0;_569.y=dim.height-_565.b+_56b-(_56a?_57c:0);}else{_568.y=stop.y=_565.t;_56a=(_576&&_576=="away")?180:0;_569.y=_565.t-_56b+(_56a?0:_57c);_56d.y=-1;_56e.y=-_56e.y;switch(_570){case "start":_570="end";break;case "end":_570="start";break;case "middle":_56f.y-=size;break;}}}this.cleanGroup();try{var s=this.group,c=this.scaler,t=this.ticks,_57d,f=lin.getTransformerFromModel(this.scaler),_57e=(!o.title||!_56a)&&!_567&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_56d.x*_577.length,dy=_56d.y*_577.length;s.createLine({x1:_568.x,y1:_568.y,x2:stop.x,y2:stop.y}).setStroke(_57b);if(o.title){var _57f=_54c.createText[_57e](this.chart,s,_569.x,_569.y,"middle",o.title,_572,_574);if(_57e=="html"){this.htmlElements.push(_57f);}else{_57f.setTransform(g.matrix.rotategAt(_56a,_569.x,_569.y));}}if(t==null){this.dirty=false;return this;}arr.forEach(t.major,function(tick){var _580=f(tick.value),elem,x=_568.x+_56c.x*_580,y=_568.y+_56c.y*_580;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_577);if(tick.label){var _581=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_571,o.maxLabelCharCount):{text:tick.label,truncated:false};_581=o.maxLabelSize?this.getTextWithLimitLength(_581.text,_571,o.maxLabelSize,_581.truncated):_581;elem=this.createText(_57e,s,x+dx+_56e.x+(_567?0:_56f.x),y+dy+_56e.y+(_567?0:_56f.y),_570,_581.text,_571,_573);if(this.chart.truncateBidi&&_581.truncated){this.chart.truncateBidi(elem,tick.label,_57e);}_581.truncated&&this.labelTooltip(elem,this.chart,tick.label,_581.text,_571,_57e);if(_57e=="html"){this.htmlElements.push(elem);}else{if(_567){elem.setTransform([{dx:_56f.x,dy:_56f.y},g.matrix.rotategAt(_567,x+dx+_56e.x,y+dy+_56e.y)]);}}}},this);dx=_56d.x*_578.length;dy=_56d.y*_578.length;_57d=c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _582=f(tick.value),elem,x=_568.x+_56c.x*_582,y=_568.y+_56c.y*_582;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_578);if(_57d&&tick.label){var _583=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_571,o.maxLabelCharCount):{text:tick.label,truncated:false};_583=o.maxLabelSize?this.getTextWithLimitLength(_583.text,_571,o.maxLabelSize,_583.truncated):_583;elem=this.createText(_57e,s,x+dx+_56e.x+(_567?0:_56f.x),y+dy+_56e.y+(_567?0:_56f.y),_570,_583.text,_571,_573);if(this.chart.getTextDir&&_583.truncated){this.chart.truncateBidi(elem,tick.label,_57e);}_583.truncated&&this.labelTooltip(elem,this.chart,tick.label,_583.text,_571,_57e);if(_57e=="html"){this.htmlElements.push(elem);}else{if(_567){elem.setTransform([{dx:_56f.x,dy:_56f.y},g.matrix.rotategAt(_567,x+dx+_56e.x,y+dy+_56e.y)]);}}}},this);dx=_56d.x*_579.length;dy=_56d.y*_579.length;arr.forEach(t.micro,function(tick){var _584=f(tick.value),elem,x=_568.x+_56c.x*_584,y=_568.y+_56c.y*_584;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_579);},this);}catch(e){}this.dirty=false;return this;},labelTooltip:function(elem,_585,_586,_587,font,_588){var _589=["dijit/Tooltip"];var _58a={type:"rect"},_58b=["above","below"],_58c=g._base._getTextBox(_587,{font:font}).w||0,_58d=font?g.normalizedLength(g.splitFontString(font).size):0;if(_588=="html"){lang.mixin(_58a,html.coords(elem.firstChild,true));_58a.width=Math.ceil(_58c);_58a.height=Math.ceil(_58d);this._events.push({shape:dojo,handle:_548.connect(elem.firstChild,"onmouseover",this,function(e){require(_589,function(_58e){_58e.show(_586,_58a,_58b);});})});this._events.push({shape:dojo,handle:_548.connect(elem.firstChild,"onmouseout",this,function(e){require(_589,function(_58f){_58f.hide(_58a);});})});}else{var shp=elem.getShape(),lt=html.coords(_585.node,true);_58a=lang.mixin(_58a,{x:shp.x-_58c/2,y:shp.y});_58a.x+=lt.x;_58a.y+=lt.y;_58a.x=Math.round(_58a.x);_58a.y=Math.round(_58a.y);_58a.width=Math.ceil(_58c);_58a.height=Math.ceil(_58d);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_589,function(_590){_590.show(_586,_58a,_58b);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_589,function(_591){_591.hide(_58a);});})});}}});});},"dojox/charting/plot2d/ClusteredBars":function(){define("dojox/charting/plot2d/ClusteredBars",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Bars","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils"],function(lang,arr,_592,Bars,dc,df,dfr,du){var _593=dfr.lambda("item.purgeGroup()");return _592("dojox.charting.plot2d.ClusteredBars",Bars,{render:function(dim,_594){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_594);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_593);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_595,_596,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_597=Math.max(0,this._hScaler.bounds.lower),_598=ht(_597),_599=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_595=_596=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i],_59a=_596*(this.series.length-i-1);if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _59b=t.next("bar",[this.opt,run]),s=run.group,_59c=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _59d=run.data[j];if(_59d!==null){var v=typeof _59d=="number"?_59d:_59d.y,hv=ht(v),_59e=hv-_598,w=Math.abs(_59e),_59f=typeof _59d!="number"?t.addMixin(_59b,"bar",_59d,true):t.post(_59b,"bar");if(w>=0&&_595>=1){var rect={x:_594.l+(v<_597?hv:_598),y:dim.height-_594.b-vt(j+1.5)+gap+_59a,width:w,height:_595};var _5a0=this._plotFill(_59f.series.fill,dim,_594);_5a0=this._shapeFill(_5a0,rect);var _5a1=s.createRect(rect).setFill(_5a0).setStroke(_59f.series.stroke);run.dyn.fill=_5a1.getFill();run.dyn.stroke=_5a1.getStroke();if(_599){var o={element:"bar",index:j,run:run,shape:_5a1,x:v,y:j+1.5};this._connectEvents(o);_59c[j]=o;}if(this.animate){this._animateBar(_5a1,_594.l+_598,-_59e);}}}}this._eventSeries[run.name]=_59c;run.dirty=false;}this.dirty=false;return this;}});});},"dojox/charting/action2d/MoveSlice":function(){define("dojox/charting/action2d/MoveSlice",["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(hub,_5a2,_5a3,dfe,m,gf,df,dfs,dff){var _5a4=1.05,_5a5=7;return _5a2("dojox.charting.action2d.MoveSlice",_5a3,{defaultParams:{duration:400,easing:dfe.backOut,scale:_5a4,shift:_5a5},optionalParams:{},constructor:function(_5a6,plot,_5a7){if(!_5a7){_5a7={};}this.scale=typeof _5a7.scale=="number"?_5a7.scale:_5a4;this.shift=typeof _5a7.shift=="number"?_5a7.shift:_5a5;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){var _5a8=m._degToRad(o.plot.opt.startAngle);if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",_5a8),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",_5a8),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _5a9=o.index,anim,_5aa,_5ab,_5ac,_5ad,_5ae=(this.angles[_5a9]+this.angles[_5a9+1])/2,_5af=m.rotateAt(-_5ae,o.cx,o.cy),_5b0=m.rotateAt(_5ae,o.cx,o.cy);anim=this.anim[_5a9];if(anim){anim.action.stop(true);}else{this.anim[_5a9]=anim={};}if(o.type=="onmouseover"){_5ac=0;_5ad=this.shift;_5aa=1;_5ab=this.scale;}else{_5ac=this.shift;_5ad=0;_5aa=this.scale;_5ab=1;}anim.action=gf.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_5b0,{name:"translate",start:[_5ac,0],end:[_5ad,0]},{name:"scaleAt",start:[_5aa,o.cx,o.cy],end:[_5ab,o.cx,o.cy]},_5af]});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){delete this.anim[_5a9];});}anim.action.play();},reset:function(){delete this.angles;}});});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_5b1,_5b2){var _5b3=lang.getObject("dojo.colors",true);var _5b4=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_5b1.fromRgb=function(_5b5,obj){var m=_5b5.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_5b2.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _5b1.fromArray(a,obj);}return _5b1.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_5b4(m1,m2,H+1/3)*256,_5b4(m1,m2,H)*256,_5b4(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _5b1.fromArray(a,obj);}}return null;};var _5b6=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_5b1.prototype.sanitize=function(){var t=this;t.r=Math.round(_5b6(t.r,0,255));t.g=Math.round(_5b6(t.g,0,255));t.b=Math.round(_5b6(t.b,0,255));t.a=_5b6(t.a,0,1);return this;};_5b3.makeGrey=_5b1.makeGrey=function(g,a){return _5b1.fromArray([g,g,g,a]);};lang.mixin(_5b1.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _5b1;});},"dijit/Tooltip":function(){require({cache:{"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n"}});define("dijit/Tooltip",["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","."],function(_5b7,_5b8,fx,dom,_5b9,_5ba,_5bb,lang,has,win,_5bc,_5bd,_5be,_5bf,_5c0,_5c1,_5c2){var _5c3=_5b8("dijit._MasterTooltip",[_5be,_5bf],{duration:_5bc.defaultDuration,templateString:_5c1,postCreate:function(){win.body().appendChild(this.domNode);this.bgIframe=new _5c0(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_5c4,_5c5,_5c6,rtl,_5c7){if(this.aroundNode&&this.aroundNode===_5c5&&this.containerNode.innerHTML==_5c4){return;}this.domNode.width="auto";if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_5c4;this.set("textDir",_5c7);this.containerNode.align=rtl?"right":"left";var pos=_5bd.around(this.domNode,_5c5,_5c6&&_5c6.length?_5c6:_5c8.defaultPosition,!rtl,lang.hitch(this,"orient"));var _5c9=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_5c9.y+((_5c9.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_5c9.x+((_5c9.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}}_5bb.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_5c5;},orient:function(node,_5ca,_5cb,_5cc,_5cd){this.connectorNode.style.top="";var _5ce=_5cc.w-this.connectorNode.offsetWidth;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_5ca+"-"+_5cb];this.domNode.style.width="auto";var size=_5ba.getContentBox(this.domNode);var _5cf=Math.min((Math.max(_5ce,1)),size.w);var _5d0=_5cf<size.w;this.domNode.style.width=_5cf+"px";if(_5d0){this.containerNode.style.overflow="auto";var _5d1=this.containerNode.scrollWidth;this.containerNode.style.overflow="visible";if(_5d1>_5cf){_5d1=_5d1+_5bb.get(this.domNode,"paddingLeft")+_5bb.get(this.domNode,"paddingRight");this.domNode.style.width=_5d1+"px";}}if(_5cb.charAt(0)=="B"&&_5ca.charAt(0)=="B"){var mb=_5ba.getMarginBox(node);var _5d2=this.connectorNode.offsetHeight;if(mb.h>_5cc.h){var _5d3=_5cc.h-((_5cd.h+_5d2)>>1);this.connectorNode.style.top=_5d3+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_5cd.h/2-_5d2/2,0),mb.h-_5d2)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_5ce);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_5d4){if(this._onDeck&&this._onDeck[1]==_5d4){this._onDeck=null;}else{if(this.aroundNode===_5d4){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}},_setAutoTextDir:function(node){this.applyTextDir(node,has("ie")?node.outerText:node.textContent);_5b7.forEach(node.children,function(_5d5){this._setAutoTextDir(_5d5);},this);},_setTextDirAttr:function(_5d6){this._set("textDir",typeof _5d6!="undefined"?_5d6:"");if(_5d6=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});_5c2.showTooltip=function(_5d7,_5d8,_5d9,rtl,_5da){if(!_5c8._masterTT){_5c2._masterTT=_5c8._masterTT=new _5c3();}return _5c8._masterTT.show(_5d7,_5d8,_5d9,rtl,_5da);};_5c2.hideTooltip=function(_5db){return _5c8._masterTT&&_5c8._masterTT.hide(_5db);};var _5c8=_5b8("dijit.Tooltip",_5be,{label:"",showDelay:400,connectId:[],position:[],_setConnectIdAttr:function(_5dc){_5b7.forEach(this._connections||[],function(_5dd){_5b7.forEach(_5dd,lang.hitch(this,"disconnect"));},this);this._connectIds=_5b7.filter(lang.isArrayLike(_5dc)?_5dc:(_5dc?[_5dc]:[]),function(id){return dom.byId(id);});this._connections=_5b7.map(this._connectIds,function(id){var node=dom.byId(id);return [this.connect(node,"onmouseenter","_onHover"),this.connect(node,"onmouseleave","_onUnHover"),this.connect(node,"onfocus","_onHover"),this.connect(node,"onblur","_onUnHover")];},this);this._set("connectId",_5dc);},addTarget:function(node){var id=node.id||node;if(_5b7.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_5b7.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_5b9.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_5b7.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},_onHover:function(e){if(!this._showTimer){var _5de=e.target;this._showTimer=setTimeout(lang.hitch(this,function(){this.open(_5de);}),this.showDelay);}},_onUnHover:function(){if(this._focus){return;}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}this.close();},open:function(_5df){if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}_5c8.show(this.label||this.domNode.innerHTML,_5df,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_5df;this.onShow(_5df,this.position);},close:function(){if(this._connectNode){_5c8.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}},onShow:function(){},onHide:function(){},uninitialize:function(){this.close();this.inherited(arguments);}});_5c8._MasterTooltip=_5c3;_5c8.show=_5c2.showTooltip;_5c8.hide=_5c2.hideTooltip;_5c8.defaultPosition=["after","before"];return _5c8;});},"dojox/charting/Element":function(){define("dojox/charting/Element",["dojo/_base/lang","dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx"],function(lang,arr,_5e0,_5e1,gfx){return _5e1("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,constructor:function(_5e2){this.chart=_5e2;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];},createGroup:function(_5e3){if(!_5e3){_5e3=this.chart.surface;}if(!this.group){this.group=_5e3.createGroup();}return this;},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.group.clear();this.group.removeShape();this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(item){item.shape.disconnect(item.handle);});this._events=[];}return this;},cleanGroup:function(_5e4){this.destroyHtmlElements();if(!_5e4){_5e4=this.chart.surface;}if(this.group){this.group.clear();}else{this.group=_5e4.createGroup();}this.dirty=true;return this;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_5e0.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},getTextWidth:function(s,font){return gfx._base._getTextBox(s,{font:font}).w||0;},getTextWithLimitLength:function(s,font,_5e5,_5e6){if(!s||s.length<=0){return {text:"",truncated:_5e6||false};}if(!_5e5||_5e5<=0){return {text:s,truncated:_5e6||false};}var _5e7=2,_5e8=0.618,_5e9=s.substring(0,1)+this.trailingSymbol,_5ea=this.getTextWidth(_5e9,font);if(_5e5<=_5ea){return {text:_5e9,truncated:true};}var _5eb=this.getTextWidth(s,font);if(_5eb<=_5e5){return {text:s,truncated:_5e6||false};}else{var _5ec=0,end=s.length;while(_5ec<end){if(end-_5ec<=_5e7){while(this.getTextWidth(s.substring(0,_5ec)+this.trailingSymbol,font)>_5e5){_5ec-=1;}return {text:(s.substring(0,_5ec)+this.trailingSymbol),truncated:true};}var _5ed=_5ec+Math.round((end-_5ec)*_5e8),_5ee=this.getTextWidth(s.substring(0,_5ed),font);if(_5ee<_5e5){_5ec=_5ed;end=end;}else{_5ec=_5ec;end=_5ed;}}}},getTextWithLimitCharCount:function(s,font,_5ef,_5f0){if(!s||s.length<=0){return {text:"",truncated:_5f0||false};}if(!_5ef||_5ef<=0||s.length<=_5ef){return {text:s,truncated:_5f0||false};}return {text:s.substring(0,_5ef)+this.trailingSymbol,truncated:true};},_plotFill:function(fill,dim,_5f1){if(!fill||!fill.type||!fill.space){return fill;}var _5f2=fill.space;switch(fill.type){case "linear":if(_5f2==="plot"||_5f2==="shapeX"||_5f2==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_5f2;if(_5f2==="plot"||_5f2==="shapeX"){var span=dim.height-_5f1.t-_5f1.b;fill.y1=_5f1.t+span*fill.y1/100;fill.y2=_5f1.t+span*fill.y2/100;}if(_5f2==="plot"||_5f2==="shapeY"){var span=dim.width-_5f1.l-_5f1.r;fill.x1=_5f1.l+span*fill.x1/100;fill.x2=_5f1.l+span*fill.x2/100;}}break;case "radial":if(_5f2==="plot"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_5f2;var _5f3=dim.width-_5f1.l-_5f1.r,_5f4=dim.height-_5f1.t-_5f1.b;fill.cx=_5f1.l+_5f3*fill.cx/100;fill.cy=_5f1.t+_5f4*fill.cy/100;fill.r=fill.r*Math.sqrt(_5f3*_5f3+_5f4*_5f4)/200;}break;case "pattern":if(_5f2==="plot"||_5f2==="shapeX"||_5f2==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_5f2;if(_5f2==="plot"||_5f2==="shapeX"){var span=dim.height-_5f1.t-_5f1.b;fill.y=_5f1.t+span*fill.y/100;fill.height=span*fill.height/100;}if(_5f2==="plot"||_5f2==="shapeY"){var span=dim.width-_5f1.l-_5f1.r;fill.x=_5f1.l+span*fill.x/100;fill.width=span*fill.width/100;}}break;}return fill;},_shapeFill:function(fill,bbox){if(!fill||!fill.space){return fill;}var _5f5=fill.space;switch(fill.type){case "linear":if(_5f5==="shape"||_5f5==="shapeX"||_5f5==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_5f5;if(_5f5==="shape"||_5f5==="shapeX"){var span=bbox.width;fill.x1=bbox.x+span*fill.x1/100;fill.x2=bbox.x+span*fill.x2/100;}if(_5f5==="shape"||_5f5==="shapeY"){var span=bbox.height;fill.y1=bbox.y+span*fill.y1/100;fill.y2=bbox.y+span*fill.y2/100;}}break;case "radial":if(_5f5==="shape"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_5f5;fill.cx=bbox.x+bbox.width/2;fill.cy=bbox.y+bbox.height/2;fill.r=fill.r*bbox.width/200;}break;case "pattern":if(_5f5==="shape"||_5f5==="shapeX"||_5f5==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_5f5;if(_5f5==="shape"||_5f5==="shapeX"){var span=bbox.width;fill.x=bbox.x+span*fill.x/100;fill.width=span*fill.width/100;}if(_5f5==="shape"||_5f5==="shapeY"){var span=bbox.height;fill.y=bbox.y+span*fill.y/100;fill.height=span*fill.height/100;}}break;}return fill;},_pseudoRadialFill:function(fill,_5f6,_5f7,_5f8,end){if(!fill||fill.type!=="radial"||fill.space!=="shape"){return fill;}var _5f9=fill.space;fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_5f9;if(arguments.length<4){fill.cx=_5f6.x;fill.cy=_5f6.y;fill.r=fill.r*_5f7/100;return fill;}var _5fa=arguments.length<5?_5f8:(end+_5f8)/2;return {type:"linear",x1:_5f6.x,y1:_5f6.y,x2:_5f6.x+fill.r*_5f7*Math.cos(_5fa)/100,y2:_5f6.y+fill.r*_5f7*Math.sin(_5fa)/100,colors:fill.colors};return fill;}});});},"dijit/_WidgetBase":function(){define("dijit/_WidgetBase",["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./registry"],function(_5fb,_5fc,_5fd,_5fe,_5ff,_600,dom,_601,_602,_603,_604,_605,_606,lang,on,_607,_608,_609,win,_60a){if(!_606.isAsync){_607(0,function(){var _60b=["dijit/_base/manager"];_5fb(_60b);});}var _60c={};function _60d(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _60e(attr){return function(val){_601[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};return _600("dijit._WidgetBase",_608,{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_60e("lang"),dir:"",_setDirAttr:_60e("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,attributeMap:{},_blankGif:_5fe.blankGif||_5fb.toUrl("dojo/resources/blank.gif"),postscript:function(_60f,_610){this.create(_60f,_610);},create:function(_611,_612){this.srcNodeRef=dom.byId(_612);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_611){this.params=_611;lang.mixin(this,_611);}this.postMixInProperties();if(!this.id){this.id=_60a.getUniqueId(this.declaredClass.replace(/\./g,"_"));}_60a.add(this);this.buildRendering();if(this.domNode){this._applyAttributes();var _613=this.srcNodeRef;if(_613&&_613.parentNode&&this.domNode!==_613){_613.parentNode.replaceChild(this.domNode,_613);}}if(this.domNode){this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(this.srcNodeRef&&!this.srcNodeRef.parentNode){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var ctor=this.constructor,list=ctor._setterAttrs;if(!list){list=(ctor._setterAttrs=[]);for(var attr in this.attributeMap){list.push(attr);}var _614=ctor.prototype;for(var _615 in _614){if(_615 in this.attributeMap){continue;}var _616="_set"+_615.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();})+"Attr";if(_616 in _614){list.push(_615);}}}_5fc.forEach(list,function(attr){if(this.params&&attr in this.params){}else{if(this[attr]){this.set(attr,this[attr]);}}},this);for(var _617 in this.params){this.set(_617,this[_617]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||_603.create("div");}if(this.baseClass){var _618=this.baseClass.split(" ");if(!this.isLeftToRight()){_618=_618.concat(_5fc.map(_618,function(name){return name+"Rtl";}));}_602.add(this.domNode,_618);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_5fc.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_619){this._beingDestroyed=true;this.destroyDescendants(_619);this.destroy(_619);},destroy:function(_61a){this._beingDestroyed=true;this.uninitialize();var c;while(c=this._connects.pop()){c.remove();}var w;while(w=this._supportingWidgets.pop()){if(w.destroyRecursive){w.destroyRecursive();}else{if(w.destroy){w.destroy();}}}this.destroyRendering(_61a);_60a.remove(this.id);this._destroyed=true;},destroyRendering:function(_61b){if(this.bgIframe){this.bgIframe.destroy(_61b);delete this.bgIframe;}if(this.domNode){if(_61b){_601.remove(this.domNode,"widgetId");}else{_603.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_61b){_603.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_61c){_5fc.forEach(this.getChildren(),function(_61d){if(_61d.destroyRecursive){_61d.destroyRecursive(_61c);}});},uninitialize:function(){return false;},_setStyleAttr:function(_61e){var _61f=this.domNode;if(lang.isObject(_61e)){_605.set(_61f,_61e);}else{if(_61f.style.cssText){_61f.style.cssText+="; "+_61e;}else{_61f.style.cssText=_61e;}}this._set("style",_61e);},_attrToDom:function(attr,_620,_621){_621=arguments.length>=3?_621:this.attributeMap[attr];_5fc.forEach(lang.isArray(_621)?_621:[_621],function(_622){var _623=this[_622.node||_622||"domNode"];var type=_622.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_620)){_620=lang.hitch(this,_620);}var _624=_622.attribute?_622.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);_601.set(_623,_624,_620);break;case "innerText":_623.innerHTML="";_623.appendChild(win.doc.createTextNode(_620));break;case "innerHTML":_623.innerHTML=_620;break;case "class":_602.replace(_623,_620,this[attr]);break;}},this);},get:function(name){var _625=this._getAttrNames(name);return this[_625.g]?this[_625.g]():this[name];},set:function(name,_626){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _627=this._getAttrNames(name),_628=this[_627.s];if(lang.isFunction(_628)){var _629=_628.apply(this,Array.prototype.slice.call(arguments,1));}else{var _62a=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_62a].tagName,_62b=_60c[tag]||(_60c[tag]=_60d(this[_62a])),map=name in this.attributeMap?this.attributeMap[name]:_627.s in this?this[_627.s]:((_627.l in _62b&&typeof _626!="function")||/^aria-|^data-|^role$/.test(name))?_62a:null;if(map!=null){this._attrToDom(name,_626,map);}this._set(name,_626);}return _629||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_62c){var _62d=this[name];this[name]=_62c;if(this._watchCallbacks&&this._created&&_62c!==_62d){this._watchCallbacks(name,_62d,_62c);}},on:function(type,func){return _5fd.after(this,this._onMap(type),func,true);},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_60a.findWidgets(this.containerNode):[];},getParent:function(){return _60a.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_62e,_62f){var _630=_5ff.connect(obj,_62e,this,_62f);this._connects.push(_630);return _630;},disconnect:function(_631){var i=_5fc.indexOf(this._connects,_631);if(i!=-1){_631.remove();this._connects.splice(i,1);}},subscribe:function(t,_632){var _633=_609.subscribe(t,lang.hitch(this,_632));this._connects.push(_633);return _633;},unsubscribe:function(_634){this.disconnect(_634);},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_604.isBodyLtr();},isFocusable:function(){return this.focus&&(_605.get(this.domNode,"display")!="none");},placeAt:function(_635,_636){if(_635.declaredClass&&_635.addChild){_635.addChild(this,_636);}else{_603.place(this.domNode,_635,_636);}return this;},getTextDir:function(text,_637){return _637;},applyTextDir:function(){}});});}}});define("dojox/charting/widget/Chart2D",["dojo/_base/kernel","./Chart","../Chart2D","../action2d/Highlight","../action2d/Magnify","../action2d/MoveSlice","../action2d/Shake","../action2d/Tooltip"],function(dojo,_638){dojo.deprecated("dojox.charting.widget.Chart2D","Use dojo.charting.widget.Chart instead and require all other components explicitly","2.0");return dojox.charting.widget.Chart2D=_638;});