.\"
.\" Copyright 1996 Hewlett-Packard Company
.\" Copyright 1996 International Business Machines Corp.
.\" Copyright 1996, 1999, 2004, Oracle and/or its affiliates. All rights reserved.
.\" Copyright 1996 Novell, Inc.
.\" Copyright 1996 Digital Equipment Corp.
.\" Copyright 1996 Fujitsu Limited
.\" Copyright 1996 Hitachi, Ltd.
.\" Copyright 1996 X Consortium, Inc.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a 
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute,
.\" sublicense, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, subject to the following
.\" conditions:
.\" 
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
.\" DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the names of the copyright holders
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" from said copyright holders.
.\"
.TH XpStartPage 3Xp __xorgversion__ "XPRINT FUNCTIONS"
.SH NAME
XpStartPage \- Indicates the beginning of a print page.
.SH SYNOPSIS
.br
      cc [ flag... ] file... -lXp [ library... ]	
.br
      #include <X11/extensions/Print.h>
.LP    
.B void XpStartPage
(
.I display, 
.I window
)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIwindow\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
Specifies a pointer to the Display structure; returned from XOpenDisplay.
.TP
.I window
Specifies the window ID.
.SH DESCRIPTION
.LP
XpStartPage signals the beginning of a new print page, with window serving as 
the drawable representing the page. 
.I window 
is required to be a descendant of the root window of the current print context 
window, else a BadWindow is generated. No generation of document data will occur 
for rendering operations against window or its inferiors prior to XpStartPage.
 
XpStartPage causes window to be mapped. See XpGetPageDimensions and 
XResizeWindow for details on resizing window to the size of the media selected 
prior to calling XpStartPage. Within the XpStartPage and XpEndPage sequence, 
attempts to resize, move or unmap window will yield undefined results. To resize 
or move inferiors of window the standard semantics of ConfigureWindow apply, 
except that the contents of any configured window may be discarded. An Expose 
event will be generated if a window's contents are discarded.

All changes to the XPPageAttr attribute pool (see XpSetAttributes) must be made 
prior to calling XpStartPage, after which an XPBadSequence error will be 
generated if changes are attempted, until XpEndPage is called.

For clients selecting XPPrintMask (see XpSelectInput), the event XPPrintNotify 
will be generated with its detail field set to XPStartPageNotify when the 
.I X Print Server 
has completed XpStartPage. If the event Expose is also selected for (see 
XSelectInput), the exposure events will be generated prior to XPPrintNotify.

The client need not wait for XPStartPageNotify prior to calling any other X 
rendering routines.

.SH DIAGNOSTICS
.TP 15
.SM BadWindow
The value specified for window is not valid.
.TP 15
.SM XPBadContext
A valid print context-id has not been set prior to making this call.
.TP 15
.SM XPBadSequence
The function was not called in the proper order with respect to the 
other X Print Service Extension calls; for example, XpStartPage was 
called before XpStartJob or was called for a type XPDocRaw document.
.SH "SEE ALSO"
.BR XpEndPage (3Xp),
.BR XpGetPageDimensions (3Xp),
.BR XpSelectInput (3Xp),
.BR XpSetAttributes (3Xp)


