-- This file is generated by SWIG. Do *not* modify by hand.
--

with llvm;
with Interfaces.C.Strings;


package LLVM_execution_Engine.Binding is

   procedure LLVMLinkInJIT;

   procedure LLVMLinkInInterpreter;

   function LLVMCreateGenericValueOfInt
     (Ty       : in llvm.LLVMTypeRef;
      N        : in Interfaces.C.Extensions.unsigned_long_long;
      IsSigned : in Interfaces.C.int)
      return     LLVM_execution_Engine.LLVMGenericValueRef;

   function LLVMCreateGenericValueOfPointer
     (P    : access Interfaces.C.Extensions.void)
      return LLVM_execution_Engine.LLVMGenericValueRef;

   function LLVMCreateGenericValueOfFloat
     (Ty   : in llvm.LLVMTypeRef;
      N    : in Interfaces.C.double)
      return LLVM_execution_Engine.LLVMGenericValueRef;

   function LLVMGenericValueIntWidth
     (GenValRef : in LLVM_execution_Engine.LLVMGenericValueRef)
      return      Interfaces.C.unsigned;

   function LLVMGenericValueToInt
     (GenVal   : in LLVM_execution_Engine.LLVMGenericValueRef;
      IsSigned : in Interfaces.C.int)
      return     Interfaces.C.Extensions.unsigned_long_long;

   function LLVMGenericValueToPointer
     (GenVal : in LLVM_execution_Engine.LLVMGenericValueRef)
      return   access Interfaces.C.Extensions.void;

   function LLVMGenericValueToFloat
     (TyRef  : in llvm.LLVMTypeRef;
      GenVal : in LLVM_execution_Engine.LLVMGenericValueRef)
      return   Interfaces.C.double;

   procedure LLVMDisposeGenericValue
     (GenVal : in LLVM_execution_Engine.LLVMGenericValueRef);

   function LLVMCreateExecutionEngine
     (OutEE    : access LLVM_execution_Engine.LLVMExecutionEngineRef;
      MP       : in llvm.LLVMModuleProviderRef;
      OutError : access Interfaces.C.Strings.chars_ptr)
      return     Interfaces.C.int;

   function LLVMCreateInterpreter
     (OutInterp : access LLVM_execution_Engine.LLVMExecutionEngineRef;
      MP        : in llvm.LLVMModuleProviderRef;
      OutError  : access Interfaces.C.Strings.chars_ptr)
      return      Interfaces.C.int;

   function LLVMCreateJITCompiler
     (OutJIT   : access LLVM_execution_Engine.LLVMExecutionEngineRef;
      MP       : in llvm.LLVMModuleProviderRef;
      OptLevel : in Interfaces.C.unsigned;
      OutError : access Interfaces.C.Strings.chars_ptr)
      return     Interfaces.C.int;

   procedure LLVMDisposeExecutionEngine
     (EE : in LLVM_execution_Engine.LLVMExecutionEngineRef);

   procedure LLVMRunStaticConstructors
     (EE : in LLVM_execution_Engine.LLVMExecutionEngineRef);

   procedure LLVMRunStaticDestructors
     (EE : in LLVM_execution_Engine.LLVMExecutionEngineRef);

   function LLVMRunFunctionAsMain
     (EE   : in LLVM_execution_Engine.LLVMExecutionEngineRef;
      F    : in llvm.LLVMValueRef;
      ArgC : in Interfaces.C.unsigned;
      ArgV : access Interfaces.C.Strings.chars_ptr;
      EnvP : access Interfaces.C.Strings.chars_ptr)
      return Interfaces.C.int;

   function LLVMRunFunction
     (EE      : in LLVM_execution_Engine.LLVMExecutionEngineRef;
      F       : in llvm.LLVMValueRef;
      NumArgs : in Interfaces.C.unsigned;
      Args    : access LLVM_execution_Engine.LLVMGenericValueRef)
      return    LLVM_execution_Engine.LLVMGenericValueRef;

   procedure LLVMFreeMachineCodeForFunction
     (EE : in LLVM_execution_Engine.LLVMExecutionEngineRef;
      F  : in llvm.LLVMValueRef);

   procedure LLVMAddModuleProvider
     (EE : in LLVM_execution_Engine.LLVMExecutionEngineRef;
      MP : in llvm.LLVMModuleProviderRef);

   function LLVMRemoveModuleProvider
     (EE       : in LLVM_execution_Engine.LLVMExecutionEngineRef;
      MP       : in llvm.LLVMModuleProviderRef;
      OutMod   : access llvm.LLVMModuleRef;
      OutError : access Interfaces.C.Strings.chars_ptr)
      return     Interfaces.C.int;

   function LLVMFindFunction
     (EE    : in LLVM_execution_Engine.LLVMExecutionEngineRef;
      Name  : in Interfaces.C.Strings.chars_ptr;
      OutFn : access llvm.LLVMValueRef)
      return  Interfaces.C.int;

   function LLVMGetExecutionEngineTargetData
     (EE   : in LLVM_execution_Engine.LLVMExecutionEngineRef)
      return LLVM_execution_Engine.LLVMTargetDataRef;

   procedure LLVMAddGlobalMapping
     (EE     : in LLVM_execution_Engine.LLVMExecutionEngineRef;
      Global : in llvm.LLVMValueRef;
      Addr   : access Interfaces.C.Extensions.void);

   function LLVMGetPointerToGlobal
     (EE     : in LLVM_execution_Engine.LLVMExecutionEngineRef;
      Global : in llvm.LLVMValueRef)
      return   access Interfaces.C.Extensions.void;

private

   pragma Import (C, LLVMLinkInJIT, "Ada_LLVMLinkInJIT");
   pragma Import (C, LLVMLinkInInterpreter, "Ada_LLVMLinkInInterpreter");
   pragma Import
     (C,
      LLVMCreateGenericValueOfInt,
      "Ada_LLVMCreateGenericValueOfInt");
   pragma Import
     (C,
      LLVMCreateGenericValueOfPointer,
      "Ada_LLVMCreateGenericValueOfPointer");
   pragma Import
     (C,
      LLVMCreateGenericValueOfFloat,
      "Ada_LLVMCreateGenericValueOfFloat");
   pragma Import
     (C,
      LLVMGenericValueIntWidth,
      "Ada_LLVMGenericValueIntWidth");
   pragma Import (C, LLVMGenericValueToInt, "Ada_LLVMGenericValueToInt");
   pragma Import
     (C,
      LLVMGenericValueToPointer,
      "Ada_LLVMGenericValueToPointer");
   pragma Import (C, LLVMGenericValueToFloat, "Ada_LLVMGenericValueToFloat");
   pragma Import (C, LLVMDisposeGenericValue, "Ada_LLVMDisposeGenericValue");
   pragma Import
     (C,
      LLVMCreateExecutionEngine,
      "Ada_LLVMCreateExecutionEngine");
   pragma Import (C, LLVMCreateInterpreter, "Ada_LLVMCreateInterpreter");
   pragma Import (C, LLVMCreateJITCompiler, "Ada_LLVMCreateJITCompiler");
   pragma Import
     (C,
      LLVMDisposeExecutionEngine,
      "Ada_LLVMDisposeExecutionEngine");
   pragma Import
     (C,
      LLVMRunStaticConstructors,
      "Ada_LLVMRunStaticConstructors");
   pragma Import
     (C,
      LLVMRunStaticDestructors,
      "Ada_LLVMRunStaticDestructors");
   pragma Import (C, LLVMRunFunctionAsMain, "Ada_LLVMRunFunctionAsMain");
   pragma Import (C, LLVMRunFunction, "Ada_LLVMRunFunction");
   pragma Import
     (C,
      LLVMFreeMachineCodeForFunction,
      "Ada_LLVMFreeMachineCodeForFunction");
   pragma Import (C, LLVMAddModuleProvider, "Ada_LLVMAddModuleProvider");
   pragma Import
     (C,
      LLVMRemoveModuleProvider,
      "Ada_LLVMRemoveModuleProvider");
   pragma Import (C, LLVMFindFunction, "Ada_LLVMFindFunction");
   pragma Import
     (C,
      LLVMGetExecutionEngineTargetData,
      "Ada_LLVMGetExecutionEngineTargetData");
   pragma Import (C, LLVMAddGlobalMapping, "Ada_LLVMAddGlobalMapping");
   pragma Import (C, LLVMGetPointerToGlobal, "Ada_LLVMGetPointerToGlobal");

end LLVM_execution_Engine.Binding;
