/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

using Gwibber;

namespace Gwibber.Test
{
  public class StreamsSuite : Object
  {
    public StreamsSuite ()
    {
      GLib.Test.add_data_func ("/Unit/Gwibber/Streams/streams_model_cols",
                               (TestDataFunc)streams_model_cols);
      GLib.Test.add_data_func ("/Unit/Gwibber/Streams/streams_model_rows",
                               (TestDataFunc)streams_model_rows);
    }

    void streams_model_cols ()
    {
      var streams = new Gwibber.Streams ();
      Dee.Model m = streams.stream_filter_model (streams.stream_model, "home");
      EnumClass e = (EnumClass) typeof (StreamModelColumn).class_ref();
      assert (m.get_n_columns () == e.n_values);
    }

    void streams_model_rows ()
    {
      var streams = new Gwibber.Streams ();
      Dee.Model m = streams.stream_filter_model (streams.stream_model, "home");
      Timeout.add (100, () => {
        assert (m.get_n_rows () > 0);
        return false;
      });
    }
  }
}
