MODULE mismatchedheap ;

(* dg-warning "'DISPOSE' of 'head' which points to memory not on the heap"  *)

FROM SysStorage IMPORT ALLOCATE, DEALLOCATE ;

TYPE
   List = POINTER TO RECORD
                        next : List ;
                        value: CARDINAL ;
                     END ;

   MODULE user ;

   FROM Storage IMPORT ALLOCATE, DEALLOCATE ;
   IMPORT List ;
   EXPORT userProc ;

   PROCEDURE userProc (l: List) ;
   BEGIN
      DISPOSE (l)
   END userProc ;

   END user ;

VAR
   head: List ;
BEGIN
   NEW (head) ;
   userProc (head)
END mismatchedheap.