# Copyright 2010 Canonical Ltd.
#
# This file is part of desktopcouch-tasks.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
#          Vincenzo Di Somma <vincenzo.di.somma@canonical.com>

"""Tests for the Tasks record classes"""

from unittest import TestCase

from desktopcouch.recordtypes.tasks import Task, TASK_RECORD_TYPE


class TestTaskRecord(TestCase):
    """Test the Task Record object."""

    def test_task_record(self):
        """Test that we get the correct record type."""
        task = Task()
        self.assertEqual(TASK_RECORD_TYPE, task.record_type)
        self.assert_(hasattr(task, 'summary'))
        summary = "manuel"
        task.summary = summary
        self.assertEqual(summary, task.summary)
