"""testing desktopcouch/start_local_couchdb.py module"""

import desktopcouch.application.tests as test_environment
import desktopcouch

from desktopcouch.application.tests import TestCase
from desktopcouch.application.replication_services import ubuntuone


class TestReplication(TestCase):
    """Testing that the database/designdoc filesystem loader works"""

    def setUp(self):
        super(TestReplication, self).setUp()
        self.db_apple = None
        self.db_banana = None

    def test_creation(self):
        """Test creation."""
        self.db_apple = desktopcouch.application.server.DesktopDatabase(
            "apple", create=True, ctx=test_environment.test_context)
        other_context = test_environment.create_new_test_environment()
        self.db_banana = desktopcouch.application.server.DesktopDatabase(
            "banana", create=True, ctx=other_context)
        # XXX: assert something.


class TestUbuntuoneReplication(TestCase):
    """Test case for Ubuntuone replication."""

    def setUp(self):
        super(TestUbuntuoneReplication, self).setUp()
        self.ctx = test_environment.create_new_test_environment()

    def test_exclusion(self):
        """Test exclusions."""
        # When no ubuntuone pairing exists, we get a ValueError.
        self.assertRaises(
            ValueError, ubuntuone.ReplicationExclusion, ctx=self.ctx)

        # Make fake pairing...
        from desktopcouch.application.pair.couchdb_pairing import couchdb_io
        result = couchdb_io.put_static_paired_service(None, "ubuntuone",
                ctx=self.ctx)
        self.assertTrue(result != None)

        replication_info = ubuntuone.ReplicationExclusion(ctx=self.ctx)

        db = "banana"
        self.assertNotIn(db, replication_info.all_exclusions())
        replication_info.exclude(db)
        self.assertIn(db, replication_info.all_exclusions())
        replication_info.exclude(db)
        replication_info.exclude(db)
        self.assertIn(db, replication_info.all_exclusions())
        replication_info.replicate(db)
        self.assertNotIn(db, replication_info.all_exclusions())
        replication_info.replicate(db)
        replication_info.replicate(db)
