#!/usr/bin/python
# Copyright 2009 Canonical Ltd.
#
# This file is part of desktopcouch.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Stuart Langridge <stuart.langridge@canonical.com>
#          Tim Cole <tim.cole@canonical.com>
#          Manuel de la Pena <manuel.delapena@canonical.com>
"""IPC code used on linux."""

import dbus.service

from desktopcouch.application.platform.linux import direct_access_find_port


class PortAdvertiser(dbus.service.Object):
    "Advertise the discovered port number on the D-Bus Session bus"

    def __init__(self, death, ctx):
        self.conn = dbus.SessionBus()
        self.death = death
        self.ctx = ctx
        super(PortAdvertiser, self).__init__(object_path="/",
            conn=self.conn)

        # Here we commit to being ready to answer function calls.
        self.bus_name = dbus.service.BusName("org.desktopcouch.CouchDB",
                bus=self.conn)

    # FIXME change this to get_port
    # pylint: disable=C0322
    # pylint: disable=C0103
    @dbus.service.method(
        dbus_interface='org.desktopcouch.CouchDB', in_signature='',
        out_signature='i')
    def getPort(self):
        "Exported method to return the port"
        port = int(direct_access_find_port(ctx=self.ctx))
        return port
    # pylint: enable=C0103

    @dbus.service.method(dbus_interface='org.desktopcouch.CouchDB',
                         in_signature='', out_signature='')
    def quit(self):
        "Exported method to quit the program"
        self.death()
    # pylint: enable=C0322
