#ifndef DEBTAGS_LOADER_H
#define DEBTAGS_LOADER_H

/*
 * On demand loader for data files
 *
 * Copyright (C) 2003--2012  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>
#include <memory>
#include "printer.h"

class DebtagsOptions;

namespace ept {

namespace apt {
class Apt;
}

namespace debtags {
class Debtags;
class Vocabulary;
}

}

class Loader
{
protected:
	/// Apt data provider
	ept::apt::Apt* m_apt;

	/// Debtags data provider
	ept::debtags::Debtags* m_debtags;

	/// Vocabulary data provider
	ept::debtags::Vocabulary* m_vocabulary;

	// Whether the debtags database is open editable
	bool _editable;

public:
    Loader() throw ();

    /**
     * Set to true if you want to load an editable version of
     * ept::debtags::Debtags.
     *
     * By default, a non editable version is loaded.
     *
     * Of course this needs to be called before using debtags(), if an editable
     * database is needed.
     */
    void editable(bool val=true);

	/// Access the apt data provider
	ept::apt::Apt& apt();

	/// Access the debtags data provider
	ept::debtags::Debtags& debtags();

	/// Access the tag vocabulary
	ept::debtags::Vocabulary& voc();

    std::auto_ptr<CollPrinter> make_coll_printer(const DebtagsOptions& opts);
    std::auto_ptr<PackagePrinter> make_package_printer(
            const DebtagsOptions& opts,
            PackagePrinter::Type default_type);
    std::auto_ptr<PackagePrinter> make_package_printer(PackagePrinter::Type type);
};

#endif
