.\"
.\" cancel man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cancel 1 "CUPS" "15 April 2014" "Apple Inc."
.SH NAME
cancel \- cancel jobs
.SH SYNOPSIS
.B cancel
[
.B \-E
] [
.B \-U
.I username
] [
.B \-a
] [
.B \-h
.I hostname[:port]
] [
.B \-u
.I username
] [
.B \-x
] [
.I id
] [
.I destination
] [
.I destination\-id
]
.SH DESCRIPTION
The \fBcancel\fR command cancels print jobs.
If no \fIdestination\fR or \fIid\fR is specified, the currently printing job on the default destination is canceled.
.SH OPTIONS
The following options are recognized by \fBcancel\fR:
.TP 5
.B \-a
Cancel all jobs on the named destination, or all jobs on all
destinations if none is provided.
.TP 5
.B \-E
Forces encryption when connecting to the server.
.TP 5
\fB\-h \fIhostname\fR[\fI:port\fR]
Specifies an alternate server.
.TP 5
\fB\-U \fIusername\fR
Specifies the username to use when connecting to the server.
.TP 5
\fB\-u \fIusername\fR
Cancels jobs owned by \fIusername\fR.
.TP 5
.B \-x
Deletes job data files in addition to canceling.
.SH CONFORMING TO
Unlike the System V printing system, CUPS allows printer names to contain any printable character except SPACE, TAB, "/", or "#". Also, printer and class names are \fInot\fR case-sensitive.
.SH EXAMPLES
Cancel the current print job:
.nf

    cancel

.fi
Cancel job "myprinter-42":
.nf

    cancel myprinter\-42

.fi
Cancel all jobs:
.nf

    cancel \-a
.fi
.SH NOTES
Administrators wishing to prevent unauthorized cancellation of jobs via the \fI\-u\fR option should require authentication for Cancel-Jobs operations in
.BR cupsd.conf (5).
.SH SEE ALSO
.BR cupsd.conf (5),
.BR lp (1),
.BR lpmove (8),
.BR lpstat (1),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2016 by Apple Inc.
