# setup.py - distutils module for Computer Janitor
#
# Copyright (C) 2008-2011  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import os
import re

from setuptools import setup
from DistUtilsExtra.command import *


# Pattern for sucking the __version__ string out of the
# computerjanitorapp/__init__.py file.  This way they cannot get out of sync.
# Be sure to bump the version string there of course.
pattern = r'__version__\s*=\s*[\'"](?P<version>[\d.]+)[\'"]'

disabled = [
    'add_nfs_common_plugin.py',
    'check_admin_group_plugin.py',
    'fstab_plugin.py',
    'landscape_stub_plugin.py',
    ]


def plugins():
    return [os.path.join('plugins', name)
            for name in os.listdir('plugins')
            if name.endswith('_plugin.py') and name not in disabled]


with open('computerjanitorapp/__init__.py') as fp:
    for line in fp:
        mo = re.search(pattern, line)
        if mo:
            __version__ = mo.group('version')
            break
    else:
        raise RuntimeError('No version string found')


setup(name='computer-janitor',
      version=__version__,
      description="Clean up a system so it's more like a freshly "
                  'installed one',
      author='Computer Janitor Hackers',
      author_email='barry@ubuntu.com',
      packages=[
          'computerjanitorapp',
          'computerjanitorapp.cli',
          'computerjanitorapp.gtk',
          'computerjanitord',
          ],
      scripts=['computer-janitor', 'computer-janitor-gtk'],
      data_files=[
          ('share/man/man8', ['computer-janitor.8',
                              'computer-janitor-gtk.8']),
          # plugins
          ('share/computerjanitor/plugins', plugins()),
          # gtkbuilder ui
          ('share/computer-janitor', ['data/ComputerJanitor.ui']),
          # desktop
          ('share/applications', ['data/computer-janitor-gtk.desktop']),
          # icons
          ('share/computer-janitor', ['data/computerjanitor-256x256.png']),
          ('share/icons/hicolor/24x24/apps',
           ['data/computerjanitor-24x24.png']),
          # dbus stuff
          ('share/dbus-1/system-services',
           ['computerjanitord/data/com.ubuntu.ComputerJanitor.service']),
          ('../etc/dbus-1/system.d/',
           ['computerjanitord/data/com.ubuntu.ComputerJanitor.conf']),
          ('share/computerjanitor/', ['janitord']),
          ('share/polkit-1/actions/',
           ['computerjanitord/data/com.ubuntu.computerjanitor.policy']),
          ],
      cmdclass = {
          'build': build_extra.build_extra,
          'build_i18n': build_i18n.build_i18n,
          'build_help': build_help.build_help,
          'build_icons': build_icons.build_icons,
          },
      test_suite = 'computerjanitorapp.tests.test_all.test_suite',
      )
